// RUN: %clang_cc1 -triple x86_64-pc-linux -Wdocumentation -ast-dump=json %s | FileCheck %s

int global_decl;
extern __attribute__((alias("global_decl"))) int global_alias;

void cleanup_function(int*);
void some() {
  __attribute__((cleanup(cleanup_function))) int var;
}

__attribute__((deprecated)) int deprecated_var0;
__attribute__((deprecated("reason"))) int deprecated_var1;
__attribute__((deprecated("reason", "replacement"))) int deprecated_var2;

__attribute__((unavailable)) int unavailable_var0;
__attribute__((unavailable("reason"))) int unavailable_var1;

__attribute__ ((section ("SECTION_NAME"))) int section_var;

__attribute__ ((visibility ("hidden"))) int visibility_var;

__thread __attribute__ ((tls_model ("local-exec"))) int tls_model_var;

// NOTE: CHECK lines have been autogenerated by gen_ast_dump_json_test.py
// using --filters=VarDecl


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 97,
// CHECK-NEXT:   "file": "{{.*}}",
// CHECK-NEXT:   "line": 3,
// CHECK-NEXT:   "col": 5,
// CHECK-NEXT:   "tokLen": 11
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 93,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 3
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 97,
// CHECK-NEXT:    "col": 5,
// CHECK-NEXT:    "tokLen": 11
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "global_decl",
// CHECK-NEXT:  "mangledName": "global_decl",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  }
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 159,
// CHECK-NEXT:   "line": 4,
// CHECK-NEXT:   "col": 50,
// CHECK-NEXT:   "tokLen": 12
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 110,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 159,
// CHECK-NEXT:    "col": 50,
// CHECK-NEXT:    "tokLen": 12
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "global_alias",
// CHECK-NEXT:  "mangledName": "global_alias",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "storageClass": "extern",
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "AliasAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 132,
// CHECK-NEXT:      "col": 23,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 151,
// CHECK-NEXT:      "col": 42,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "aliasee": "global_decl"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 266,
// CHECK-NEXT:   "col": 50,
// CHECK-NEXT:   "tokLen": 3
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 219,
// CHECK-NEXT:    "col": 3,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 266,
// CHECK-NEXT:    "col": 50,
// CHECK-NEXT:    "tokLen": 3
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "var",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CleanupAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 234,
// CHECK-NEXT:      "col": 18,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 258,
// CHECK-NEXT:      "col": 42,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "cleanup_function": {
// CHECK-NEXT:     "id": "0x{{.*}}",
// CHECK-NEXT:     "kind": "FunctionDecl",
// CHECK-NEXT:     "name": "cleanup_function",
// CHECK-NEXT:     "type": {
// CHECK-NEXT:      "qualType": "void (int *)"
// CHECK-NEXT:     }
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 306,
// CHECK-NEXT:   "line": 11,
// CHECK-NEXT:   "col": 33,
// CHECK-NEXT:   "tokLen": 15
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 274,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 306,
// CHECK-NEXT:    "col": 33,
// CHECK-NEXT:    "tokLen": 15
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "deprecated_var0",
// CHECK-NEXT:  "mangledName": "deprecated_var0",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "DeprecatedAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 289,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 289,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     }
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 365,
// CHECK-NEXT:   "line": 12,
// CHECK-NEXT:   "col": 43,
// CHECK-NEXT:   "tokLen": 15
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 323,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 365,
// CHECK-NEXT:    "col": 43,
// CHECK-NEXT:    "tokLen": 15
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "deprecated_var1",
// CHECK-NEXT:  "mangledName": "deprecated_var1",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "DeprecatedAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 338,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 357,
// CHECK-NEXT:      "col": 35,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "message": "reason"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 439,
// CHECK-NEXT:   "line": 13,
// CHECK-NEXT:   "col": 58,
// CHECK-NEXT:   "tokLen": 15
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 382,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 439,
// CHECK-NEXT:    "col": 58,
// CHECK-NEXT:    "tokLen": 15
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "deprecated_var2",
// CHECK-NEXT:  "mangledName": "deprecated_var2",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "DeprecatedAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 397,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 431,
// CHECK-NEXT:      "col": 50,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "message": "reason",
// CHECK-NEXT:    "replacement": "replacement"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 490,
// CHECK-NEXT:   "line": 15,
// CHECK-NEXT:   "col": 34,
// CHECK-NEXT:   "tokLen": 16
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 457,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 490,
// CHECK-NEXT:    "col": 34,
// CHECK-NEXT:    "tokLen": 16
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "unavailable_var0",
// CHECK-NEXT:  "mangledName": "unavailable_var0",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "UnavailableAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 472,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 11
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 472,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 11
// CHECK-NEXT:     }
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 551,
// CHECK-NEXT:   "line": 16,
// CHECK-NEXT:   "col": 44,
// CHECK-NEXT:   "tokLen": 16
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 508,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 551,
// CHECK-NEXT:    "col": 44,
// CHECK-NEXT:    "tokLen": 16
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "unavailable_var1",
// CHECK-NEXT:  "mangledName": "unavailable_var1",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "UnavailableAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 523,
// CHECK-NEXT:      "col": 16,
// CHECK-NEXT:      "tokLen": 11
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 543,
// CHECK-NEXT:      "col": 36,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "message": "reason"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 617,
// CHECK-NEXT:   "line": 18,
// CHECK-NEXT:   "col": 48,
// CHECK-NEXT:   "tokLen": 11
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 570,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 617,
// CHECK-NEXT:    "col": 48,
// CHECK-NEXT:    "tokLen": 11
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "section_var",
// CHECK-NEXT:  "mangledName": "section_var",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "SectionAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 586,
// CHECK-NEXT:      "col": 17,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 609,
// CHECK-NEXT:      "col": 40,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "section_name": "SECTION_NAME"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 675,
// CHECK-NEXT:   "line": 20,
// CHECK-NEXT:   "col": 45,
// CHECK-NEXT:   "tokLen": 14
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 631,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 675,
// CHECK-NEXT:    "col": 45,
// CHECK-NEXT:    "tokLen": 14
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "visibility_var",
// CHECK-NEXT:  "mangledName": "visibility_var",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "VisibilityAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 647,
// CHECK-NEXT:      "col": 17,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 667,
// CHECK-NEXT:      "col": 37,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "visibility": "hidden"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "VarDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 748,
// CHECK-NEXT:   "line": 22,
// CHECK-NEXT:   "col": 57,
// CHECK-NEXT:   "tokLen": 13
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 692,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 8
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 748,
// CHECK-NEXT:    "col": 57,
// CHECK-NEXT:    "tokLen": 13
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "tls_model_var",
// CHECK-NEXT:  "mangledName": "tls_model_var",
// CHECK-NEXT:  "type": {
// CHECK-NEXT:   "qualType": "int"
// CHECK-NEXT:  },
// CHECK-NEXT:  "tls": "static",
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "TLSModelAttr",
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 717,
// CHECK-NEXT:      "col": 26,
// CHECK-NEXT:      "tokLen": 9
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 740,
// CHECK-NEXT:      "col": 49,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tls_model": "local-exec"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }
