// RUN: llvm-mc -arch=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

tbuffer_load_format_x v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0xff,0x02,0x03]

tbuffer_load_format_x v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_x v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_x v5, off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_x v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_x v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_x v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_x v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_x v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_x v5, off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_x v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_x v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_x v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_x v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_x v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_x v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_x v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_x v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_x v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_x v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x10,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x18,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x20,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x28,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x30,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x38,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x40,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x48,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x50,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x58,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x60,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x68,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x70,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x78,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x00,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x88,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x08,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x88,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x08,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x88,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x08,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x88,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_x v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x08,0xe8,0x00,0x05,0x42,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0xfe,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_xy v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_xy v[5:6], off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_xy v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_xy v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_xy v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_xy v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_xy v[5:6], off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_xy v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_xy v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_xy v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_xy v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_xy v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_xy v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_xy v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_xy v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_xy v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_xy v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x10,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x18,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x20,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x28,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x30,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x38,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x40,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x48,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x50,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x58,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x60,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x68,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x70,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x78,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x00,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x88,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x08,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x88,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x08,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x88,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x08,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x88,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0xaf,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x9f,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x80,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x80,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x80,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0xcf,0x08,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x8f,0x08,0xe8,0x00,0x05,0x42,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[253:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0xfd,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_xyz v[5:7], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_xyz v[5:7], off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_xyz v[5:7], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_xyz v[5:7], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_xyz v[5:7], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_xyz v[5:7], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_xyz v[5:7], off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_xyz v[5:7], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_xyz v[5:7], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_xyz v[5:7], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_xyz v[5:7], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_xyz v[5:7], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_xyz v[5:7], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_xyz v[5:7], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_xyz v[5:7], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_xyz v[5:7], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_xyz v[5:7], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x11,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x19,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x21,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x29,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x31,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x39,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x41,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x49,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x51,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x59,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x61,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x69,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x71,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x79,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x01,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x89,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x09,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x89,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x09,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x89,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x09,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x89,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3
// CHECK: [0x00,0x00,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x09,0xe8,0x00,0x05,0x42,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[252:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0xfc,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_xyzw v[5:8], off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x11,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x19,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x21,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x29,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x31,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x39,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x41,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x49,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x51,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x59,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x61,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x69,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x71,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x79,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x01,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x89,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x09,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x89,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x09,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x89,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x09,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x89,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0xaf,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x9f,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3
// CHECK: [0x00,0x80,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x80,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x80,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0xcf,0x09,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x8f,0x09,0xe8,0x00,0x05,0x42,0x03]

tbuffer_store_format_x v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0xff,0x03,0x04]

tbuffer_store_format_x v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_x v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_x v1, off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_x v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_x v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_x v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_x v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_x v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_x v1, off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_x v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_x v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_x v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_x v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_x v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_x v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_x v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_x v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_x v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_x v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x12,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x1a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x22,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x2a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x32,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x3a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x42,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x4a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x52,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x5a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x62,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x6a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x72,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x7a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x02,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x8a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x0a,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x8a,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x0a,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x8a,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x0a,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x8a,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_x v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x0a,0xe8,0x00,0x01,0x43,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0xfe,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_xy v[1:2], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_xy v[1:2], off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_xy v[1:2], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_xy v[1:2], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_xy v[1:2], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_xy v[1:2], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_xy v[1:2], off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_xy v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_xy v[1:2], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_xy v[1:2], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_xy v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_xy v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_xy v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_xy v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_xy v[1:2], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_xy v[1:2], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_xy v[1:2], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x12,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x1a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x22,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x2a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x32,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x3a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x42,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x4a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x52,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x5a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x62,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x6a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x72,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x7a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x02,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x8a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x0a,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x8a,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x0a,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x8a,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x0a,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x8a,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0xaf,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x9f,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x80,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x80,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x80,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0xcf,0x0a,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x8f,0x0a,0xe8,0x00,0x01,0x43,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[253:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0xfd,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_xyz v[1:3], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_xyz v[1:3], off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_xyz v[1:3], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_xyz v[1:3], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_xyz v[1:3], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_xyz v[1:3], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_xyz v[1:3], off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_xyz v[1:3], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_xyz v[1:3], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_xyz v[1:3], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_xyz v[1:3], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_xyz v[1:3], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_xyz v[1:3], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_xyz v[1:3], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_xyz v[1:3], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_xyz v[1:3], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_xyz v[1:3], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x13,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x1b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x23,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x2b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x33,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x3b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x43,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x4b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x53,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x5b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x63,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x6b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x73,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x7b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x03,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x8b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x0b,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x8b,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x0b,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x8b,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x0b,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x8b,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4
// CHECK: [0x00,0x00,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x0b,0xe8,0x00,0x01,0x43,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[252:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0xfc,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_xyzw v[1:4], off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x13,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x1b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x23,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x2b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x33,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x3b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x43,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x4b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x53,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x5b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x63,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x6b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x73,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x7b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x03,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x8b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x0b,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x8b,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x0b,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x8b,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x0b,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x8b,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0xaf,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x9f,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4
// CHECK: [0x00,0x80,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x80,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x80,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0xcf,0x0b,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x8f,0x0b,0xe8,0x00,0x01,0x43,0x04]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0xff,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_d16_x v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_d16_x v5, off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_d16_x v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_d16_x v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_d16_x v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_d16_x v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_d16_x v5, off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_d16_x v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_d16_x v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_d16_x v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_d16_x v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_d16_x v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_d16_x v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_d16_x v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_d16_x v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_d16_x v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_d16_x v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x14,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x24,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x34,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x44,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x54,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x64,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x74,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x04,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x0c,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x0c,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x0c,0xe8,0x00,0x05,0x42,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0xff,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_d16_xy v5, off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_d16_xy v5, off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_d16_xy v5, off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_d16_xy v5, off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_d16_xy v5, off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_d16_xy v5, off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_d16_xy v5, off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_d16_xy v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_d16_xy v5, off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_d16_xy v5, off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_d16_xy v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_d16_xy v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_d16_xy v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_d16_xy v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_d16_xy v5, off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_d16_xy v5, off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_d16_xy v5, off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x14,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x1c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x24,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x2c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x34,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x3c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x44,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x4c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x54,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x5c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x64,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x6c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x74,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x7c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x04,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x8c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x8c,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x0c,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x8c,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x0c,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x8c,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0xaf,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x9f,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3
// CHECK: [0x00,0x80,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x80,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x80,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0xcf,0x0c,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x8f,0x0c,0xe8,0x00,0x05,0x42,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0xfe,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x15,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x1d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x25,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x2d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x35,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x3d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x45,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x4d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x55,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x5d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x65,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x6d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x75,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x7d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x05,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x8d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x0d,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x8d,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x0d,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x8d,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x0d,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x8d,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x0d,0xe8,0x00,0x05,0x42,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0xfe,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x03,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[96:99], s3 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x18,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, ttmp[12:15], s3 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x1e,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s101 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x65]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x66]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x67]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x6a]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x6b]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x7b]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x7c]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x7e]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x7f]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x80]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0xc1]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0xf0]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0xf7]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0xfb]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], src_execz offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0xfc]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], src_scc offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0xfd]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x15,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x1d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x25,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x2d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x35,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x3d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x45,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x4d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x55,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x5d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x65,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x6d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x75,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x7d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x05,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x8d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x0d,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x8d,0xe9,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x0d,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x8d,0xea,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x0d,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x8d,0xeb,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0xaf,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x9f,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x80,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x80,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x80,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0xcf,0x0d,0xe8,0x00,0x05,0x02,0x03]

tbuffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x8f,0x0d,0xe8,0x00,0x05,0x42,0x03]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0xff,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_d16_x v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_d16_x v1, off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_d16_x v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_d16_x v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_d16_x v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_d16_x v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_d16_x v1, off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_d16_x v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_d16_x v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_d16_x v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_d16_x v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_d16_x v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_d16_x v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_d16_x v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_d16_x v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_d16_x v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_d16_x v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x16,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x1e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x26,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x2e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x36,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x3e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x46,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x4e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x56,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x5e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x66,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x6e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x76,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x7e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x06,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x8e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x0e,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x8e,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x0e,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x8e,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x0e,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x8e,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x0e,0xe8,0x00,0x01,0x43,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0xff,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_d16_xy v1, off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_d16_xy v1, off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_d16_xy v1, off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_d16_xy v1, off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_d16_xy v1, off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_d16_xy v1, off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_d16_xy v1, off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_d16_xy v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_d16_xy v1, off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_d16_xy v1, off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_d16_xy v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_d16_xy v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_d16_xy v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_d16_xy v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_d16_xy v1, off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_d16_xy v1, off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_d16_xy v1, off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x16,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x1e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x26,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x2e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x36,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x3e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x46,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x4e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x56,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x5e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x66,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x6e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x76,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x7e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x06,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x8e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x0e,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x8e,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x0e,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x8e,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x0e,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x8e,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0xaf,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x9f,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4
// CHECK: [0x00,0x80,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x80,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x80,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0xcf,0x0e,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x8f,0x0e,0xe8,0x00,0x01,0x43,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0xfe,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x0f,0x17,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x0f,0x1f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x0f,0x27,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x0f,0x2f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x0f,0x37,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x0f,0x3f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x0f,0x47,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x0f,0x4f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x0f,0x57,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x0f,0x5f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x0f,0x67,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x6f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x0f,0x77,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x0f,0x7f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x0f,0x07,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x0f,0x8f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x0f,0x0f,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x0f,0x8f,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x0f,0x0f,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x0f,0x8f,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x0f,0x0f,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x0f,0x8f,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x0f,0xe8,0x00,0x01,0x43,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0xfe,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x04,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[96:99], s4 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x18,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, ttmp[12:15], s4 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x1e,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s101 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x65]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], flat_scratch_lo offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x66]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], flat_scratch_hi offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x67]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], vcc_lo offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x6a]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], vcc_hi offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x6b]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], ttmp15 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x7b]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x7c]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], exec_lo offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x7e]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], exec_hi offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x7f]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x80]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0xc1]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0xf0]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0xf7]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], src_vccz offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0xfb]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], src_execz offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0xfc]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], src_scc offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0xfd]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8] offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16] offset:4095
// CHECK: [0xff,0x8f,0x17,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8] offset:4095
// CHECK: [0xff,0x8f,0x1f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32] offset:4095
// CHECK: [0xff,0x8f,0x27,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16] offset:4095
// CHECK: [0xff,0x8f,0x2f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_11_11] offset:4095
// CHECK: [0xff,0x8f,0x37,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_11_11_10] offset:4095
// CHECK: [0xff,0x8f,0x3f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_10_10_10_2] offset:4095
// CHECK: [0xff,0x8f,0x47,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_2_10_10_10] offset:4095
// CHECK: [0xff,0x8f,0x4f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_8_8_8_8] offset:4095
// CHECK: [0xff,0x8f,0x57,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32] offset:4095
// CHECK: [0xff,0x8f,0x5f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_16_16_16_16] offset:4095
// CHECK: [0xff,0x8f,0x67,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x6f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_32_32_32_32] offset:4095
// CHECK: [0xff,0x8f,0x77,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_RESERVED_15] offset:4095
// CHECK: [0xff,0x8f,0x7f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_DATA_FORMAT_INVALID] offset:4095
// CHECK: [0xff,0x8f,0x07,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UNORM] offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SNORM] offset:4095
// CHECK: [0xff,0x8f,0x8f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_USCALED] offset:4095
// CHECK: [0xff,0x8f,0x0f,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SSCALED] offset:4095
// CHECK: [0xff,0x8f,0x8f,0xe9,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_UINT] offset:4095
// CHECK: [0xff,0x8f,0x0f,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_SINT] offset:4095
// CHECK: [0xff,0x8f,0x8f,0xea,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_RESERVED_6] offset:4095
// CHECK: [0xff,0x8f,0x0f,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 format:[BUF_NUM_FORMAT_FLOAT] offset:4095
// CHECK: [0xff,0x8f,0x8f,0xeb,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0xaf,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x9f,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x80,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x80,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x80,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0xcf,0x0f,0xe8,0x00,0x01,0x03,0x04]

tbuffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x8f,0x0f,0xe8,0x00,0x01,0x43,0x04]
