#include <string>
#include <unistd.h>
#include <pthread.h>
#include <sstream>

#include "keyboard.h"

#include "logger.h"

using namespace std;

Keyboard::Keyboard(AppletWindowParams params,
		   const string& layout_l,
		   const string& layout_p,
		   KeyboardForegroundColors c
		   )	:Applet(params),
			 layout_landscape(layout_l),
			 layout_portrait(layout_p),
			 colors(c),
			 lastkeyx(-1),
			 lastkeyy(-1){
}

int scale(double a, double b, double c){
    return a*c/b;
}

void Keyboard::DrawSym(MyWindow* win, int x, int y, Keymap::Key k, bool highlite){
    ostringstream os;
    string look = k.look;
    int r = colors.transparent[colors.cur_transparent].red / 255,
	g = colors.transparent[colors.cur_transparent].green / 255,
	b = colors.transparent[colors.cur_transparent].blue / 255;
    if (highlite){
	r = 255 - r;
	g = 255 - g;
	b = 255 - b;
    }
    if (look.size() < 4 || look.substr(look.size() - 4) != ".png"){
	win->AddText(x, y, look, MyWindow::CENTER, r, g, b);
    } else {
	win->AddImage(x, y, look, NULL, NULL, MyWindow::CENTER, r, g, b);
    }
}

void Keyboard::DrawKey(MyWindow* win, Keymap::Key k, bool highlite){
    string look = k.look;
    int px = scale(k.px, keymap.Width(),  win->Width()),
	py = scale(k.py, keymap.Height(), win->Height()),
	w  = scale(k.w,  keymap.Width(),  win->Width()), 
	h  = scale(k.h,  keymap.Height(), win->Height());
    DrawSym(win, px + w/2, py + h/2, k, highlite);
/*    for (int i=0; i<w; ++i)
	win->AddPixel(px+i,py);
    for (int i=0; i<h; ++i)
	win->AddPixel(px,py+i);*/

}

void Keyboard::Load(const string& layout){
    keymap.ReadMap(layout);
    win.Clear();
    DrawKeys();
    ostringstream bufname;
    bufname << keymap.CurrentFunction() << rot;
    win.SaveBuffer(bufname.str());
}

void Keyboard::DrawKeys(){
    const vector<Keymap::Key>& keys = keymap.GetCurrentKeys();
    LOG(INFO) << "Drawing " << (int)keys.size() << " keys";
    for (int i=0; i<keys.size(); ++i)
	DrawKey(&win, keys[i]);
    LOG(INFO) << "Done";
}


AppAction Keyboard::OnMousePress(int px, int py){
    vibrator->Vibrate();
    lastpressx = px;
    lastpressy = py;
    return OnMouseMove(px, py);
}

AppAction Keyboard::OnMouseMove(int x, int y){
    int px = scale(x, win.Width(),  keymap.Width()),
	py = scale(y, win.Height(), keymap.Height());


    Keymap::Key key(0,0,0,0);
    if (keymap.GetKey(px, py, &key)){
	if (lastkeyx == key.px && lastkeyy == key.py)
	    return "";
	int kx = scale(key.px, keymap.Width(),  win.Width()),
	    ky = scale(key.py, keymap.Height(), win.Height()),
	    kw = scale(key.w,  keymap.Width(),  win.Width()), 
	    kh = scale(key.h,  keymap.Height(), win.Height());
	Keymap::Key lastkey(0,0,0,0);
	if (keymap.GetKey(lastkeyx, lastkeyy, &lastkey)){
	    DrawKey(&win, lastkey, false);
	    win.Refresh(scale(lastkey.px, keymap.Width(), win.Width()),
		        scale(lastkey.py, keymap.Height(), win.Height()),
			scale(lastkey.w, keymap.Width(), win.Width()),
		        scale(lastkey.h, keymap.Height(), win.Height()));
	}
	DrawKey(&win, key, true);
	int wpx = scale(key.px, keymap.Width(), win.Width()),
	    wpy = scale(key.py, keymap.Height(), win.Height()),
	    ww = scale(key.w, keymap.Width(), win.Width()),
	    wh = scale(key.h, keymap.Height(), win.Height());
	win.Refresh(wpx, wpy, ww, wh);
	lastkeyx = key.px;
	lastkeyy = key.py;
    }
    return "";
}

AppAction Keyboard::OnMouseRelease(int x, int y){
    int px = scale(x, win.Width(),  keymap.Width()),
	py = scale(y, win.Height(), keymap.Height());
    if (y - lastpressy > 60) {
	Hide();
	return "slider_show";
    }
    string action = keymap.GetAction(px, py);

 /*   lastkeyx = -1;
    lastkeyy = -1;*/
    bool refresh = false;
    LOG(INFO) <<"Action from keypress " << action;
    if (action.substr(0,8) == "refresh:"){
	refresh = true;
	action = action.substr(8);
    }
    if (action.substr(0,4) == "$is_"){
	keymap.SetFunction(action.substr(4));
	if (action != "$is_ctrl" && action != "$is_alt")
	    refresh = true;
    }
 
    if (action == "$change_color"){
	colors.cur_transparent = (colors.cur_transparent + 1)%colors.transparent.size();
	refresh = true;
    }   
    if (action == "$toggle_bkground"){
	ToggleTransparent();
	refresh = true;
    }   
    if (refresh){
	LOG(INFO) << "Refreshing keyboard";
	ostringstream bufname;
	bufname << keymap.CurrentFunction() << rot << colors.cur_transparent;
	if (win.LoadBuffer(bufname.str())){
	    LOG(INFO) << "Buffer " << bufname.str() << " loaded";
	} else {
	    LOG(INFO) << "Buffer " << bufname.str() << " not found";
	    win.Clear();
	    DrawKeys();
	}
	if (IsTransparent())
	    SetTransparent(true);
	win.SaveBuffer(bufname.str());
	Refresh();
    }

    win.GetDisplay().GenKeyEvent(action);
    return "";
}


void Keyboard::OnRotate(Rotation rot){
    switch (rot){
	case LANDSCAPE: Load(layout_landscape);
			LOG(INFO) << "Orienting to landscape";
			break;
	case PORTRAIT:  Load(layout_portrait);
			LOG(INFO) << "Orienting to portrait";
			break;
    }
    Refresh();
    SetTransparent(IsTransparent());
}


