/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEdit;
import org.lisaac.ldt.model.LisaacCompletionParser;
import org.lisaac.ldt.model.items.ICode;
import org.lisaac.ldt.model.items.ITMRead;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.model.types.TypeSimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITMReadArg2
extends ITMRead {
    protected ICode argFirst;
    protected ICode argSecond;

    public ITMReadArg2(String name, ICode a1, ICode a2) {
        super(name);
        this.argFirst = a1;
        this.argSecond = a2;
    }

    @Override
    public IType getType(Slot slot, Prototype prototype) {
        if (this.name.startsWith("__")) {
            Slot operatorSlot;
            Prototype operatorPrototype;
            IType type = this.argFirst.getType(slot, prototype);
            if (type != null) {
                try {
                    operatorPrototype = LisaacCompletionParser.findPrototype("" + type);
                    if (operatorPrototype != null) {
                        operatorSlot = operatorPrototype.lookupSlot(this.name);
                        if (operatorSlot != null) {
                            return operatorSlot.getResultType();
                        }
                        if (this.name.compareTo("__infix_equal") == 0) {
                            return TypeSimple.getTypeBoolean();
                        }
                    }
                }
                catch (CoreException coreException) {}
            }
            if ((type = this.argSecond.getType(slot, prototype)) != null) {
                try {
                    operatorPrototype = LisaacCompletionParser.findPrototype("" + type);
                    if (operatorPrototype != null && (operatorSlot = operatorPrototype.lookupSlot(this.name)) != null) {
                        return operatorSlot.getResultType();
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return super.getType(slot, prototype);
    }

    @Override
    public void refactorRenamePrototype(String oldName, String newName, List<TextEdit> edits) {
        this.argFirst.refactorRenamePrototype(oldName, newName, edits);
        this.argSecond.refactorRenamePrototype(oldName, newName, edits);
    }
}

