package latexDraw.ui.components;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.dialog.ExceptionFrameDialog;



/** 
 * This class defines a button which allows the user to close a window<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 05/23/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class CloseButton extends JButton implements ActionListener
{
	private static final long serialVersionUID = 1L;

	/** The panel to close */
	private JPanel closePanel;
	
	/** The width of the button */
	public static final int ICON_WIDTH = 14;
	
	/** The height of the button */
	public static final int ICON_HEIGHT = 14;
	
	/** The image of the button. */
	protected final static ImageIcon closeOut = new ImageIcon(Class.class.getClass().getResource("/res/closeOut.png"));//$NON-NLS-1$
	
	/** The image of the button when the mouse is on. */
	protected final static ImageIcon closeIn = new ImageIcon(Class.class.getClass().getResource("/res/closeIn.png"));//$NON-NLS-1$
	
	/** The name and the action command of the button. */
	public static final String NAME_BUTTON = "CLOSE_BUTTON";//$NON-NLS-1$
	
	
	/**
	 * The constructor by default.
	 * @param panel The panel to close (can be null).
	 */
	public CloseButton(JPanel panel)
	{
		try
		{
			closePanel = panel;
			
			addActionListener(this);
			
			setSize(ICON_WIDTH, ICON_HEIGHT);
			setPreferredSize(new Dimension(ICON_WIDTH, ICON_HEIGHT));
			setMinimumSize(new Dimension(ICON_WIDTH, ICON_HEIGHT));
			setMaximumSize(new Dimension(ICON_WIDTH, ICON_HEIGHT));
			setActionCommand(NAME_BUTTON);
			setName(NAME_BUTTON);
			setIcon(closeOut);
			setRolloverIcon(closeIn);
			setToolTipText(LaTeXDrawLang.getOthersString("CloseButton.closePanel")); //$NON-NLS-1$
			
		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}
	


	public void actionPerformed(ActionEvent e)
	{
		Object o = e.getSource();
		
		if(o instanceof CloseButton && closePanel!=null)
		{
			closePanel.setVisible(false);
			return ;
		}
	}
}
