package latexDraw.generators.svg;

import java.util.Vector;

import latexDraw.figures.Draw;
import latexDraw.figures.Figure;
import latexDraw.parsers.svg.LaTeXDrawFiguresFactory;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGDocument;
import latexDraw.parsers.svg.elements.SVGElement;
import latexDraw.parsers.svg.elements.SVGGElement;
import latexDraw.util.LaTeXDrawNamespace;

import org.w3c.dom.NodeList;

/**
 * Defines a SVG generator for a drawing.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 11/11/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 */
public class LDrawingSVGGenerator extends LShapeSVGGenerator
{

	public LDrawingSVGGenerator(Draw f)
	{
		super(f);
	}


	
	public LDrawingSVGGenerator(SVGGElement elt)
	{
		this(elt, true);
	}
	
	
	
	/**
	 * Creates a drawing from a G element.
	 * @param elt The source element.
	 * @since 2.0.0
	 */
	public LDrawingSVGGenerator(SVGGElement elt, boolean withTransformation)
	{
		this(new Draw(true, true));
		
		if(elt==null)
			throw new IllegalArgumentException();
		
		NodeList nl = elt.getChildNodes();
		Figure f;
		Draw d = (Draw)getShape();
		
		if(nl.getLength()<2)
			throw new IllegalArgumentException();
		
		for(int i=0, size=nl.getLength(); i<size; i++)
		{
			f = LaTeXDrawFiguresFactory.createFigure((SVGElement)nl.item(i), withTransformation);
			
			if(f!=null)
				d.addFigure(f);
		}
		
		setNumber(elt);
	}


	
	@Override
	public SVGElement toSVG(SVGDocument doc)
	{
		if(doc==null)
			return null;
		
		Draw d = (Draw)shape;
		
		if(d.isDrawFigures() && !d.isEmpty())
		{
			 SVGElement root = new SVGGElement(doc);
			 Vector<Figure> figures = d.getFigures();
			 
			 root.setAttribute(LaTeXDrawNamespace.LATEXDRAW_NAMESPACE+':'+LaTeXDrawNamespace.XML_TYPE, LaTeXDrawNamespace.XML_TYPE_DRAWING);
			 root.setAttribute(SVGAttributes.SVG_ID, getSVGID());
			 
			 for(Figure f : figures)
				 root.appendChild(SVGShapesFactory.createSVGElement(f, doc));
			 
			 return root;
		}		 
		 
		return null;
	}
}
