Name:		lat
Version:	1.2.4
Release: 	1
Summary: 	LDAP Administration Tool

Group: 		Applications/System
License: 	GPL
URL: 		https://sourceforge.net/projects/ldap-at/
BuildRoot: 	%{_tmppath}/%{name}-root
BuildArch:      noarch
Source: 	https://sourceforge.net/projects/ldap-at/files/LAT/%{name}-%{version}.tar.gz

Packager:	Loren Bandiera <lorenb@mmgsecurity.com>

Requires: mono-data
Requires: gtk-sharp2
Requires: dbus-sharp
Requires: avahi-sharp
Requires(post): desktop-file-utils
Requires(post): scrollkeeper
Requires(postun): desktop-file-utils
Requires(postun): scrollkeeper
BuildRequires: mono-data
BuildRequires: gtk-sharp2
BuildRequires: dbus-sharp
BuildRequires: avahi-sharp
BuildRequires: gnome-keyring-devel
BuildRequires: scrollkeeper

%description
LAT stands for LDAP Administration Tool. The tool allows you to browse LDAP-based directories and add/edit/delete entries contained within. It can store profiles for quick access to different servers. There are also different views available such as Users, Groups and Hosts which allow you to easily manage objects without having to deal with the intricacies of LDAP.

%prep
%setup -q

%build
%configure

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%find_lang %name

%clean
rm -rf $RPM_BUILD_ROOT

%post
update-desktop-database &> /dev/null ||:
scrollkeeper-update -q -o %{_datadir}/omf/%{name} || :

%postun
update-desktop-database &> /dev/null ||:
scrollkeeper-update -q || :

%files -f %{name}.lang
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{_bindir}/lat
%{_libdir}/%{name}/*
%{_libdir}/pkgconfig/*
%{_mandir}/man1/lat.1.gz
%{_datadir}/locale/*
%{_datadir}/gnome/help/*
%{_datadir}/omf/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/application-registry/%{name}.applications
%{_datadir}/pixmaps/*
%exclude /var/scrollkeeper

%changelog
* Mon Sep 19 2005 Loren Bandiera <lorenb@mmgsecurity.com>
- Added depend on mono-data which contains the Novell.Directory.Ldap.dll
	
* Thu Feb 03 2005 Loren Bandiera <lorenb@mmgsecurity.com>
- Initial RPM release
