/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "advancedsettingsdialog.h"
#include "toolinfo.h"

AdvancedSettingsDialog::AdvancedSettingsDialog(QWidget *parent, const QString& caption, VpnAccountData *currentProfile, VpnAccountData::ConnectionType connectionType, KVpncConfig *GlobalConfig) : KDialog(parent)
{
    Q_UNUSED(caption);

    setupUi(this);
    setMinimumSize(sizeHint());

    this->currentProfile = currentProfile;
    this->connectionType = connectionType;

    connect(AdvancedSettingsCheckbox, SIGNAL(toggled(bool)), this, SLOT(advancedSettingsToggled(bool)));
    connect(ApplicationVersionCheckbox, SIGNAL(toggled(bool)), this, SLOT(applicationVersionToggled(bool)));
    connect(PerfectForwardSecurityCheckbox, SIGNAL(toggled(bool)), this, SLOT(perfectForwardSecurityToggled(bool)));
    connect(IkeGroupCheckbox, SIGNAL(toggled(bool)), this, SLOT(IkeGroupToggled(bool)));
    connect(SingleDesCheckbox, SIGNAL(toggled(bool)), this, SLOT(singleDesToggled(bool)));

    IkeGroupCheckbox->setEnabled(false);
    PerfectForwardSecrecyCombobox->setEnabled(false);
    SingleDesCheckbox->setEnabled(false);
    ApplicationVersionLineedit->setEnabled(false);
    PerfectForwardSecurityCheckbox->setEnabled(false);
    IkeGroupCombobox->setEnabled(false);
    ApplicationVersionCheckbox->setEnabled(false);
    IkeGroupCombobox->setEnabled(false);

    QString vpnc_version = "";
    for (int toolIdx = 0; toolIdx < GlobalConfig->ToolList->size(); ++toolIdx) {
        if (GlobalConfig->ToolList->at(toolIdx)->Name == "vpnc") {
            vpnc_version = GlobalConfig->ToolList->at(toolIdx)->Version;
            break;
        }
    }



    if (currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::cisco)) {
        //PerfectForwardSecrecyCombobox->setEnabled( false );
        PerfectForwardSecrecyCombobox->clear();
        PerfectForwardSecrecyCombobox->insertItem(0, "server");
        PerfectForwardSecrecyCombobox->insertItem(1, "nopfs");
        PerfectForwardSecrecyCombobox->insertItem(2, "dh1");
        PerfectForwardSecrecyCombobox->insertItem(3, "dh2");
        PerfectForwardSecrecyCombobox->insertItem(4, "dh5");

        //IkeGroupCombobox->setEnabled( false );
        IkeGroupCombobox->clear();
        IkeGroupCombobox->insertItem(0, "dh1");
        IkeGroupCombobox->insertItem(1, "dh2");
        IkeGroupCombobox->insertItem(2, "dh5");
    } else if (currentProfile->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon)) {
        //PerfectForwardSecrecyCombobox->setEnabled( false );
        PerfectForwardSecrecyCombobox->clear();
        PerfectForwardSecrecyCombobox->insertItem(0, "dh1");
        PerfectForwardSecrecyCombobox->insertItem(1, "dh2");
        PerfectForwardSecrecyCombobox->insertItem(2, "dh5");
        PerfectForwardSecrecyCombobox->insertItem(3, "dh14");
        PerfectForwardSecrecyCombobox->insertItem(4, "dh15");
        PerfectForwardSecrecyCombobox->insertItem(5, "dh16");
        PerfectForwardSecrecyCombobox->insertItem(6, "dh17");
        PerfectForwardSecrecyCombobox->insertItem(7, "dh18");


        IkeGroupCheckbox->setEnabled(false);
        IkeGroupCombobox->clear();
        IkeGroupCombobox->insertItem(0, "dh1");
        IkeGroupCombobox->insertItem(1, "dh2");
        IkeGroupCombobox->insertItem(2, "dh5");
        IkeGroupCombobox->insertItem(3, "dh1");
        IkeGroupCombobox->insertItem(4, "dh2");
        IkeGroupCombobox->insertItem(5, "dh5");
        IkeGroupCombobox->insertItem(6, "dh14");
        IkeGroupCombobox->insertItem(7, "dh15");
        IkeGroupCombobox->insertItem(8, "dh16");
        IkeGroupCombobox->insertItem(9, "dh17");
        IkeGroupCombobox->insertItem(10, "dh18");
    }

    ApplicationVersionLineedit->setText("Cisco Systems VPN Client " + vpnc_version + ":Linux");

    AdvancedSettingsCheckbox->setChecked(currentProfile->getUseAdvancedSettings());
    this->advancedSettingsToggled(true);
}

AdvancedSettingsDialog::~AdvancedSettingsDialog()
{
}

void AdvancedSettingsDialog::advancedSettingsToggled(bool)
{
    IkeGroupCheckbox->setEnabled(false);
    PerfectForwardSecrecyCombobox->setEnabled(false);
    SingleDesCheckbox->setEnabled(false);
    ApplicationVersionLineedit->setEnabled(false);
    PerfectForwardSecurityCheckbox->setEnabled(false);
    IkeGroupCombobox->setEnabled(false);
    ApplicationVersionCheckbox->setEnabled(false);

    if (this->AdvancedSettingsCheckbox->isChecked()) {
        groupBox3->setEnabled(true);
        if (connectionType == VpnAccountData::ConnectionType(VpnAccountData::cisco)) {
            //if (currentProfile->getUseAdvancedSettings())
            //{
            SingleDesCheckbox->setEnabled(true);
            PerfectForwardSecurityCheckbox->setEnabled(true);
            ApplicationVersionCheckbox->setEnabled(true);
            PerfectForwardSecurityCheckbox->setEnabled(true);
            IkeGroupCheckbox->setEnabled(true);

        } else if (connectionType == VpnAccountData::ConnectionType(VpnAccountData::racoon)) {

            //PerfectForwardSecrecyCombobox->setEnabled( false );
            SingleDesCheckbox->setEnabled(false);
            ApplicationVersionLineedit->setEnabled(false);
            PerfectForwardSecurityCheckbox->setEnabled(true);
            IkeGroupCombobox->setEnabled(false);
            ApplicationVersionCheckbox->setEnabled(false);
            IkeGroupCheckbox->setEnabled(true);
        }

    }

    else {
        groupBox3->setEnabled(false);
    }
}

void AdvancedSettingsDialog::applicationVersionToggled(bool)
{
    if (ApplicationVersionCheckbox->isChecked())
        ApplicationVersionLineedit->setEnabled(true);
    else
        ApplicationVersionLineedit->setEnabled(false);
}

void AdvancedSettingsDialog::IkeGroupToggled(bool)
{
    if (IkeGroupCheckbox->isChecked())
        IkeGroupCombobox->setEnabled(true);
    else
        IkeGroupCombobox->setEnabled(false);
}

void AdvancedSettingsDialog::perfectForwardSecurityToggled(bool)
{
    if (PerfectForwardSecurityCheckbox->isChecked())
        PerfectForwardSecrecyCombobox->setEnabled(true);
    else
        PerfectForwardSecrecyCombobox->setEnabled(false);
}

void AdvancedSettingsDialog::singleDesToggled(bool)
{}

void AdvancedSettingsDialog::helpClicked()
{}


void AdvancedSettingsDialog::accept()
{
    currentProfile->setUseAdvancedSettings(this->AdvancedSettingsCheckbox->isChecked());
    currentProfile->setApplicationVersion(this->ApplicationVersionLineedit->text());
    currentProfile->setUseApplicationVersion(this->ApplicationVersionCheckbox->isChecked());
    currentProfile->setIkeGroup(this->IkeGroupCombobox->currentText());
    currentProfile->setUseIkeGroup(this->IkeGroupCheckbox->isChecked());
    currentProfile->setPerfectForwardSecrety(this->PerfectForwardSecrecyCombobox->currentText());
    currentProfile->setUsePerfectForwardSecrety(this->PerfectForwardSecurityCheckbox->isChecked());
    currentProfile->setUseSingleDes(this->SingleDesCheckbox->isChecked());

    QDialog::accept();
}

#include "advancedsettingsdialog.moc"
