/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef UPDATEDIALOG_H
#define UPDATEDIALOG_H

#include <QWidget>
#include <QHttp>
#include <QUrl>
#include <QGridLayout>
#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QCheckBox>
#include <QStringList>
#include <QSettings>
#include <QMessageBox>
#include <QDomDocument>
#include "../constants.h"

class UpdateDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *label;
    QString versionWeb;
    QString descriptionWeb;
    QCheckBox *checkbox;
    QSettings *settings;
    UpdateDialog(QString version, QString description)
          :versionWeb(version), descriptionWeb(description)
    {
        settings = new QSettings("OpenNetwork", "KontrolPack", this);
        QString update = settings->value("startup/update",
                                      "false").toString();
        label = new QLabel(tr("A new KontrolPack release : version ") + versionWeb + tr(" is now available on KontrolPack Web site."), this);
        QLabel *creatorLabel = new QLabel(tr("KontrolPack web site : <a href=\"http://www.kontrolpack.com/\">http://www.kontrolpack.com/</a><br/><br/>"), this);
        creatorLabel->setOpenExternalLinks(true);
        QLabel *descriptionLabel = new QLabel(descriptionWeb, this);
        checkbox = new QCheckBox(tr("Do not tell me when a new KontrolPack version is available."), this);
        if (update.startsWith("true", Qt::CaseInsensitive))
            checkbox->setCheckState(Qt::Checked);
        else
            checkbox->setCheckState(Qt::Unchecked);
        connect(checkbox, SIGNAL(stateChanged(int)), this, SLOT(checked(int)));
        QPushButton *button = new QPushButton(tr("Close"));
        this->setWindowTitle(tr("New KontrolPack available"));
        this->setWindowIcon(QIcon(":/images/kontrolpack.png"));
        connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
        QVBoxLayout* layout = new QVBoxLayout();
        layout->addWidget(label);
        layout->addWidget(descriptionLabel);
        layout->addWidget(creatorLabel);
        layout->addWidget(checkbox);
        layout->addWidget(button);
        setLayout(layout);
    }
private slots:
void checked(int check)
{
    if (checkbox->isChecked())
        settings->setValue("startup/update", "true");
    else
        settings->setValue("startup/update", "false");
    check++;
}
void onClic()
  {
    hide();
  }
};

class UpdateManagerDialog : public QDialog
{
  Q_OBJECT
public:
    QLabel *label;
    QString versionWeb;
    QCheckBox *checkbox;
    QSettings *settings;
    UpdateManagerDialog(QString version)
          :versionWeb(version)
    {
        settings = new QSettings("OpenNetwork", "KontrolPack", this);
        QString update = settings->value("startup/update",
                                      "false").toString();
        label = new QLabel(tr("You are running the last KontrolPack version. No need to update."), this);
        QLabel *creatorLabel = new QLabel(tr("KontrolPack web site : <a href=\"http://www.kontrolpack.com/\">http://www.kontrolpack.com/</a><br/><br/>"), this);
        creatorLabel->setOpenExternalLinks(true);
        checkbox = new QCheckBox(tr("Do not tell me when a new KontrolPack version is available."), this);
        if (update.startsWith("true", Qt::CaseInsensitive))
            checkbox->setCheckState(Qt::Checked);
        else
            checkbox->setCheckState(Qt::Unchecked);
        connect(checkbox, SIGNAL(stateChanged(int)), this, SLOT(checked(int)));
        QPushButton *button = new QPushButton(tr("Close"));
        this->setWindowTitle(tr("New KontrolPack available"));
        this->setWindowIcon(QIcon(":/images/kontrolpack.png"));
        connect(button, SIGNAL(clicked()), this, SLOT(onClic()));
        QVBoxLayout* layout = new QVBoxLayout();
        layout->addWidget(label);
        layout->addWidget(creatorLabel);
        layout->addWidget(checkbox);
        layout->addWidget(button);
        setLayout(layout);
    }
private slots:
void checked(int check)
{
    if (checkbox->isChecked())
        settings->setValue("startup/update", "true");
    else
        settings->setValue("startup/update", "false");
    check++;
}
void onClic()
  {
    hide();
  }
};



class UpdateManager : public QWidget
{
    Q_OBJECT

public:
    UpdateManager();
    QHttp *http;
public slots:
    void readVersion();
    QStringList getVersion(QString xml);
    void updateManager();
    void autoReadVersion();
    void autoUpdateManager();
protected:


};
#endif
