/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "sharedfolder_description.h"

using namespace Form;

Description::Entry::List SharedFolderDescription::entries() const
{
  Entry::List entries;

  {
    Entry entry;
    entry.setName( "cn" );
    entry.setType( "non-empty-string" );
    entry.setLabel( QObject::tr( "Folder Name" ) );
    entry.setComment( QObject::tr( "Required" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "kolabHomeServer" );
    entry.setType( "non-empty-string" );
    entry.setLabel( QObject::tr( "Folder Location" ) );
    entry.setComment( QObject::tr( "Required, non volatile" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "cyrus-userquota" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Quota Limit" ) );
    entry.setComment( QObject::tr( "MBytes (empty for unlimited)" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "acls" );
    entry.setType( "aclselection" );
    entry.setLabel( QObject::tr( "Permission for UID/GID" ) );
    entries.append( entry );
  }

  return entries;
}
