/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "entry.h"

using namespace Form;

Entry::Entry()
{
}

Entry::~Entry()
{
}

void Entry::setId( const QString &id )
{
  mId = id;
}

QString Entry::id() const
{
  return mId;
}

QStringList Entry::keys() const
{
  return mValues.keys();
}

QString Entry::value( const QString &key ) const
{
  if ( !mValues.contains( key ) )
    return QString();
  else if ( mValues[ key ].isEmpty() )
    return QString();
  else
    return mValues[ key ].first();
}

QStringList Entry::values( const QString &key ) const
{
  if ( !mValues.contains( key ) )
    return QStringList();
  else
    return mValues[ key ];
}

void Entry::setValue( const QString &key, const QString &value )
{
  if ( !mValues.contains( key ) )
    mValues.insert( key, QStringList() );

  mValues[ key ] = QStringList( value );
}

void Entry::addValue( const QString &key, const QString &value )
{
  if ( !mValues.contains( key ) )
    mValues.insert( key, QStringList() );

  mValues[ key ].append( value );
}

void Entry::clearValue( const QString &key )
{
  mValues.remove( key );
}

void Entry::dump() const
{
  QMap<QString, QStringList>::ConstIterator it;
  for ( it = mValues.begin(); it != mValues.end(); ++it ) {
    for ( int i = 0; i < it.value().count(); ++i ) {
      qDebug( "%s: %s", qPrintable( it.key() ), qPrintable( it.value()[ i ] ) );
    }
  }

  qDebug( " " );
}

Entry Entry::fromLdapEntry( const QLdapEntry &ldapEntry )
{
  Entry entry;

  entry.setId( ldapEntry.dn() );

  QStringList names = ldapEntry.attributeNames();
  for ( int i = 0; i < names.count(); ++i ) {
    QStringList values = ldapEntry.values( names[ i ] );
    for ( int j = 0; j < values.count(); ++j ) {
      entry.addValue( names[ i ], values[ j ] );
    }
  }

  return entry;
}
