#include "Heap.h"
#include "VMState.h"
#include "FnCache.h"
#include <iostream>

#define CACHE_SIZE 1

FnCache::FnCache(VMState* vm):m_vm(vm)
{
    m_cache = (Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*CACHE_SIZE);
    m_cacheptr = m_cache;
    m_cacheend = m_cache+CACHE_SIZE;
}

void FnCache::addEntry(Value* result)
{
    // Easy. special case
    cout << "Storing " << result << endl;
    *m_cache = result;
}

void FnCache::addEntry(Value* arg1, Value* result)
{
    // Easy. special case
    *m_cache = arg1;
    *(m_cache+1) = result;
    m_cache+=2;
}

Value* FnCache::checkCache(int args)
{
    if (args==0) {
	// Easy, special case
	cout << "Cached " << *m_cache << endl;
	return *m_cache;
    }

    return NULL;
}
