/*
 * tempfile.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __TEMPFILE_HH__
#define __TEMPFILE_HH__

#include <string>

class TempFile {
public:
  TempFile();
  ~TempFile();
  bool ok(std::string&);
  std::string& get_name();
  bool write(const std::string&, std::string&);
  bool read(std::string&, std::string&);
private:
  int fd;
  bool _ok;
  std::string name;
  std::string err;
};

#endif /* __TEMPFILE_HH__ */
