/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptableObject {
    static final long serialVersionUID = -6345305608474346996L;
    private static final Object OBJECT_TAG = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int MAX_PROTOTYPE_ID = 8;

    static void init(Scriptable scope, boolean sealed) {
        NativeObject obj = new NativeObject();
        obj.exportAsJSClass(8, scope, sealed);
    }

    public String getClassName() {
        return "Object";
    }

    public String toString() {
        return ScriptRuntime.defaultObjectToString(this);
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toLocaleString";
                break;
            }
            case 4: {
                arity = 0;
                s = "valueOf";
                break;
            }
            case 5: {
                arity = 1;
                s = "hasOwnProperty";
                break;
            }
            case 6: {
                arity = 1;
                s = "propertyIsEnumerable";
                break;
            }
            case 7: {
                arity = 1;
                s = "isPrototypeOf";
                break;
            }
            case 8: {
                arity = 0;
                s = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(OBJECT_TAG, id, s, arity);
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(OBJECT_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj != null) {
                    return f.construct(cx, scope, args);
                }
                if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
                    return new NativeObject();
                }
                return ScriptRuntime.toObject(cx, scope, args[0]);
            }
            case 2: 
            case 3: {
                if (cx.hasFeature(4)) {
                    String s = ScriptRuntime.defaultObjectToSource(cx, scope, thisObj, args);
                    int L = s.length();
                    if (L != 0 && s.charAt(0) == '(' && s.charAt(L - 1) == ')') {
                        s = s.substring(1, L - 1);
                    }
                    return s;
                }
                return ScriptRuntime.defaultObjectToString(thisObj);
            }
            case 4: {
                return thisObj;
            }
            case 5: {
                boolean result;
                if (args.length == 0) {
                    result = false;
                } else {
                    String s = ScriptRuntime.toStringIdOrIndex(cx, args[0]);
                    if (s == null) {
                        int index = ScriptRuntime.lastIndexResult(cx);
                        result = thisObj.has(index, thisObj);
                    } else {
                        result = thisObj.has(s, thisObj);
                    }
                }
                return ScriptRuntime.wrapBoolean(result);
            }
            case 6: {
                boolean result;
                if (args.length == 0) {
                    result = false;
                } else {
                    String s = ScriptRuntime.toStringIdOrIndex(cx, args[0]);
                    if (s == null) {
                        int index = ScriptRuntime.lastIndexResult(cx);
                        result = thisObj.has(index, thisObj);
                        if (result && thisObj instanceof ScriptableObject) {
                            ScriptableObject so = (ScriptableObject)thisObj;
                            int attrs = so.getAttributes(index);
                            result = (attrs & 2) == 0;
                        }
                    } else {
                        result = thisObj.has(s, thisObj);
                        if (result && thisObj instanceof ScriptableObject) {
                            ScriptableObject so = (ScriptableObject)thisObj;
                            int attrs = so.getAttributes(s);
                            result = (attrs & 2) == 0;
                        }
                    }
                }
                return ScriptRuntime.wrapBoolean(result);
            }
            case 7: {
                boolean result = false;
                if (args.length != 0 && args[0] instanceof Scriptable) {
                    Scriptable v = (Scriptable)args[0];
                    do {
                        if ((v = v.getPrototype()) != thisObj) continue;
                        result = true;
                        break;
                    } while (v != null);
                }
                return ScriptRuntime.wrapBoolean(result);
            }
            case 8: {
                return ScriptRuntime.defaultObjectToSource(cx, scope, thisObj, args);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    protected int findPrototypeId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 7: {
                X = "valueOf";
                id = 4;
                break;
            }
            case 8: {
                char c = s.charAt(3);
                if (c == 'o') {
                    X = "toSource";
                    id = 8;
                    break;
                }
                if (c != 't') break;
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
            case 13: {
                X = "isPrototypeOf";
                id = 7;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'h') {
                    X = "hasOwnProperty";
                    id = 5;
                    break;
                }
                if (c != 't') break;
                X = "toLocaleString";
                id = 3;
                break;
            }
            case 20: {
                X = "propertyIsEnumerable";
                id = 6;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

