/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Locale;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleError
extends SimpleMessage
implements ValidationError {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getInstance(SimpleError.class);
    private String fieldNameKey;
    private String actionPath;
    private Class<? extends ActionBean> beanclass;

    public SimpleError(String message, Object ... parameter) {
        super(message, SimpleError.processReplacementParameters(parameter));
    }

    static Object[] processReplacementParameters(Object ... parameter) {
        if (parameter == null) {
            return new Object[2];
        }
        Object[] out = new Object[parameter.length + 2];
        System.arraycopy(parameter, 0, out, 2, parameter.length);
        return out;
    }

    @Override
    public String getMessage(Locale locale) {
        this.resolveFieldName(locale);
        return super.getMessage(locale);
    }

    protected void resolveFieldName(Locale locale) {
        log.debug("Looking up localized field name with messageKey: ", this.fieldNameKey);
        if (this.fieldNameKey == null) {
            this.getReplacementParameters()[0] = "FIELD NAME NOT SUPPLIED IN CODE";
        } else {
            this.getReplacementParameters()[0] = LocalizationUtility.getLocalizedFieldName(this.fieldNameKey, this.actionPath, this.beanclass, locale);
            if (this.getReplacementParameters()[0] == null) {
                this.getReplacementParameters()[0] = LocalizationUtility.makePseudoFriendlyName(this.fieldNameKey);
            }
        }
    }

    @Override
    public void setFieldName(String name) {
        this.fieldNameKey = name;
    }

    @Override
    public String getFieldName() {
        return this.fieldNameKey;
    }

    @Override
    public void setFieldValue(String value) {
        this.getReplacementParameters()[1] = value;
    }

    @Override
    public String getFieldValue() {
        return (String)this.getReplacementParameters()[1];
    }

    @Override
    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    @Override
    public String getActionPath() {
        return this.actionPath;
    }

    @Override
    public Class<? extends ActionBean> getBeanclass() {
        return this.beanclass;
    }

    @Override
    public void setBeanclass(Class<? extends ActionBean> beanclass) {
        this.beanclass = beanclass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleError that = (SimpleError)o;
        if (this.actionPath != null ? !this.actionPath.equals(that.actionPath) : that.actionPath != null) {
            return false;
        }
        return !(this.fieldNameKey != null ? !this.fieldNameKey.equals(that.fieldNameKey) : that.fieldNameKey != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.fieldNameKey != null ? this.fieldNameKey.hashCode() : 0);
        result = 29 * result + (this.actionPath != null ? this.actionPath.hashCode() : 0);
        return result;
    }
}

