#include "common/config.h"

#ifndef __KERNEL__
#include <errno.h>
#endif

void init_request_hdr(struct request_hdr *hdr, xlator_type xt,
		enum config_mode mode, enum config_operation operation,
		bool force)
{
	hdr->magic[0] = 'j';
	hdr->magic[1] = 'o';
	hdr->magic[2] = 'o';
	hdr->magic[3] = 'l';
	hdr->xt = xt;
	hdr->castness = 'u';
	hdr->force = force;
	hdr->slop1 = 0;
	hdr->version = htonl(xlat_version());
	hdr->mode = mode;
	hdr->operation = operation;
	hdr->slop2 = 0;
}

/* TODO duplicate code (src/usr/iptables/common.c) */
int iname_validate(const char *iname, bool allow_null)
{
	unsigned int i;

	if (!iname)
		return allow_null ? 0 : -EINVAL;

	for (i = 0; i < INAME_MAX_LEN; i++) {
		if (iname[i] == '\0')
			return 0;
		if (iname[i] < 32) /* "if not printable" */
			break;
	}

	return -EINVAL;
}

int xt_validate(xlator_type xt)
{
	return (xt == XT_SIIT || xt == XT_NAT64) ? 0 : -EINVAL;
}

int xf_validate(xlator_framework xf)
{
	return (xf == XF_NETFILTER || xf == XF_IPTABLES) ? 0 : -EINVAL;
}

xlator_type xlator_flags2xt(xlator_flags flags)
{
	return flags & 0x03;
}

xlator_framework xlator_flags2xf(xlator_flags flags)
{
	return flags & 0x0C;
}
