/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package javax.sql;

import java.sql.SQLException;

/**
 * An object implementing the RowSetReader interface may be registered with a RowSet object that supports
 * the reader/writer paradigm. A RowSetReader object is called by a rowset to produce a new set of rows which
 * will become the rowset's contents. 
 */
public interface RowSetReader {
  /**
   * <p>Read the new contents of a rowset. This method is invoked internally by the RowSet.execute()
   * method for rowsets that support the reader/writer paradigm.</p>
   *
   * <p>The readData() method uses the RowSet.insertRow() or RowSet.populate() methods to add rows
   * to the caller. In general, any of the caller's methods may be called by the reader with one
   * exception, calling execute() will throw an SQLException since execute may not be called
   * recursively. Also, rowset events, such as RowSetChanged, etc. are not generated by RowSet methods
   * invoked by a reader.</p>
   *
   * @param rowSetInternal - the rowset that called the reader
   * @exception SQLException - if a database-access error occurs
   */
  public void readData(RowSetInternal rowSetInternal)
    throws SQLException;
}
