/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.algorithm;

import java.security.NoSuchAlgorithmException;
import jonelo.jacksum.adapt.org.bouncycastle.crypto.Digest;
import jonelo.jacksum.adapt.org.bouncycastle.crypto.digests.GOST3411Digest;
import jonelo.jacksum.adapt.org.bouncycastle.crypto.digests.RIPEMD256Digest;
import jonelo.jacksum.adapt.org.bouncycastle.crypto.digests.RIPEMD320Digest;
import jonelo.jacksum.algorithm.AbstractChecksum;

public class MDbouncycastle
extends AbstractChecksum {
    private Digest md = null;
    private boolean virgin = true;
    private byte[] digest = null;

    public MDbouncycastle(String string) throws NoSuchAlgorithmException {
        this.length = 0L;
        this.filename = null;
        this.separator = " ";
        this.encoding = "hex";
        this.virgin = true;
        if (string.equalsIgnoreCase("gost")) {
            this.md = new GOST3411Digest();
        } else if (string.equalsIgnoreCase("ripemd256")) {
            this.md = new RIPEMD256Digest();
        } else if (string.equalsIgnoreCase("ripemd320")) {
            this.md = new RIPEMD320Digest();
        } else {
            throw new NoSuchAlgorithmException(string + " is an unknown algorithm.");
        }
    }

    public void reset() {
        this.md.reset();
        this.length = 0L;
        this.virgin = true;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
        this.length += (long)n2;
    }

    public void update(byte by) {
        this.md.update(by);
        ++this.length;
    }

    public void update(int n) {
        this.update((byte)(n & 0xFF));
    }

    public String toString() {
        return this.getFormattedValue() + this.separator + (this.isTimestampWanted() ? this.getTimestampFormatted() + this.separator : "") + this.getFilename();
    }

    public byte[] getByteArray() {
        if (this.virgin) {
            this.digest = new byte[this.md.getDigestSize()];
            this.md.doFinal(this.digest, 0);
            this.virgin = false;
        }
        byte[] byArray = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, byArray, 0, this.digest.length);
        return byArray;
    }
}

