/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.ide.util.projectWizard;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.util.xmlb.annotations.Attribute;

/**
 * @author peter
 */
public class ModuleBuilderFactory extends AbstractExtensionPointBean {
  @Attribute("builderClass")
  public String builderClass;

  public ModuleBuilder createBuilder() {
    try {
      return instantiate(builderClass, ApplicationManager.getApplication().getPicoContainer());
    }
    catch (ClassNotFoundException e) {
      throw new RuntimeException(e);
    }
  }


}
