Testing the Intel(R) Processor Trace (Intel PT) Decoder Library and Samples {#pttc}
===========================================================================

<!---
 ! Copyright (c) 2013-2016, Intel Corporation
 !
 ! Redistribution and use in source and binary forms, with or without
 ! modification, are permitted provided that the following conditions are met:
 !
 !  * Redistributions of source code must retain the above copyright notice,
 !    this list of conditions and the following disclaimer.
 !  * Redistributions in binary form must reproduce the above copyright notice,
 !    this list of conditions and the following disclaimer in the documentation
 !    and/or other materials provided with the distribution.
 !  * Neither the name of Intel Corporation nor the names of its contributors
 !    may be used to endorse or promote products derived from this software
 !    without specific prior written permission.
 !
 ! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 ! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 ! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 ! ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 ! LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 ! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 ! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 ! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 ! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 ! POSSIBILITY OF SUCH DAMAGE.
 !-->

This chapter documents how to use the pttc tool to generate and run tests.
Pttc takes a yasm assembly file and creates a Processor Trace stream from
special directives in its input.


Usage
-----

	$ pttc path/to/file.ptt

If no error occurs, the following files will be generated in the current working
directory:

	file.lst
	file.bin
	file.pt
	file.exp

The `.lst` and `.bin` files are generated by a call to yasm. The `.pt` file
contains the Processor Trace and the `.exp` file contains the content of the
comments after the `.exp` directive.

Pttc prints the filenames of the generated `.exp` files to stdout.


Syntax
------

Pttc allows annotations in the comments of yasm assembler source files.  The
parser recognizes all comments that contain the `@pt` directive marker.

Every pt directive can be preceded by a label name followed by a colon (`:`).
Refer to the description of the `.exp()` directive below on how to use these
labels.

The general syntax for pt directives is as follows:

	@pt [label:]directive([arguments])


### Directives

This section lists the directives that are understood by pttc.


#### psb, psbend, pad, ovf, stop

	@pt psb()
	@pt psbend()
	@pt pad()
	@pt ovf()
	@pt stop()

These packets do not have any arguments and correspond to the packets from the
specification.


#### tnt, tnt64

	@pt tnt(args)
	@pt tnt64(args)

The arguments of the tnt and tnt64 packets is a list of Takens `t` and
Not-Takens `n`. For better readability an arbitrary number of blanks and dots
can be intervened.

It is an error if no characters, only blanks or dots, or other characters are in
the payload. Additionally for the TNT packet and the TNT64 packet it is an error
to have more than 6 and more than 47 t's or n's in the payload, respectively.


#### tip, tip.pge, tip.pgd, fup

	@pt tip(ipc: addr)
	@pt tip.pge(ipc: addr)
	@pt tip.pgd(ipc: addr)
	@pt fup(ipc: addr)

These packets accept arbitrary addresses. `Addr` must be a parsable integer or a
valid label name. `Ipc` specifies the IP compression bits as integer number.

If `addr` is given as a label, the address is truncated according to the IP
bytes value given in `ipc`.  Otherwise the address needs to be a zero-extended
integer no bigger than specified in `ipc`.


#### mode.exec, mode.tsx

	@pt mode.exec(mode)
	@pt mode.tsx(state)

`Mode` must be either `16bit` or `32bit` or `64bit`; `state` must be `begin` or
`abort` or `commit`.


#### pip

	@pt pip(addr[, nr])

Addr is the value that was written to CR3.

If nr is specified after addr, the non-root bit is set.


#### tsc

	@pt tsc(value)

Value is the timestamp.


#### cbr

	@pt cbr(value)

Value is the core/bus ratio.


#### tma

    @pt tma(ctc, fc)

Ctc is the 16bit crystal clock component.
Fc is the 9bit fast counter component.


#### mtc

    @pt mtc(value)

Value is the 8bit crystal clock component.


#### cyc

    @pt cyc(value)

Value is the cycle count.


#### vmcs

    @pt vmcs(value)

Value is the VMCS base address.  Beware that only bits 12 to 51 will be used.
The rest will be silently ignored.


#### mnt

    @pt mnt(value)

Value is the 8-byte packet payload represented as 64-bit little-endian number.


#### .exp

	@pt .exp([extra])

Every occurrence of this directive prints all the lines, following this
directive, to a `file[-extra].exp`.

The first occurrence of this directive stops processing of other directives.

In order to have a valid yasm file, it is necessary to put the expected output
into yasm comments (with the semi-colon character (`;`)). Any character up to
(and including) the semi-colon is not printed to the `.exp` file. Trailing white
space is removed from each line.

Comments are made with the `#` character and go to the end of line.  Comments
and whitespace before comments are not printed in the `.exp` file.

Each line that contains no yasm comment at all is not printed to the exp file.
Empty lines can be used to structure the expected output text.

In `.exp` files, the address of a yasm label can be substituted using:

	%[?0]label[.<number>].


Labels are prefixed with `%`, for example, `%%label`.  A label name can consist
of alphanumeric characters and underscores.  Labels must be unique.  The address
of label will be substituted with a hex number including leading `0x`.

Prefixing the label with `0`, for example `%0label`, prints the address with
leading zeroes using 16 hex digits plus the leading `0x`.

The least significant `n` bytes of an address can be masked by appending `.n` to
the label.  For example, `%%label.2` with `label` = `0xffffff004c` is printed as
`0x4c`.

Prefixing the label with `?` in combination with masking replaces the masked out
parts with `?` using 16 digits for the address plus the leading `0x`.  The
remaining number is zero extended.  For example, `%?label.2` with `label` =
`0xc0001` is printed as `0x????????????0001`.

The packet number of pt directives can also be substituted in the output. These
numbers are printed in decimal. The syntax is as follows:

	%label


### Special Labels

There is a special label for the byte offset after the last packet: `%%eos`.


Labels in sections are relative to the section's vstart address.  PTTC also adds
the following special section labels:

 * *section_<name>_start*   gives the section's offset in the binary file
 * *section_<name>_vstart*  gives the virtual base address of the mapped section
 * *section_<name>_length*  gives the size of the section in bytes

Beware that PTTC does not support switching back and forth between sections.
