/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QtXml/QtXml>
#include <QDir>
#include <QTextStream>

#include "settings.h"

Settings::Settings(QString &fileName)
{
    QDomNodeList nodeList;

    folderName     = QDir::homePath();
    playlistFolder = folderName;
    windowHeight   = 480;
    windowWidth    = 640;
    autoConvert    = false;
    viewAlignment  = Qt::Horizontal;

    QDomDocument doc("ifpgui-settings");
    QFile file(fileName);
    if (!file.open(QIODevice::ReadOnly))
        return;
    if (!doc.setContent(&file))
    {
        file.close();
        return;
    }
    file.close();

    // load settings

    nodeList = doc.elementsByTagName("WindowHeight");
    if (nodeList.count() > 0)
    {
        windowHeight = nodeList.item(0).toElement().text().toInt();
    }

    nodeList = doc.elementsByTagName("WindowWidth");
    if (nodeList.count() > 0)
    {
        windowWidth = nodeList.item(0).toElement().text().toInt();
    }

    nodeList = doc.elementsByTagName("DirViewWidth");
    if (nodeList.count() > 0)
    {
        dirViewWidth = nodeList.item(0).toElement().text().toInt();
    }

    nodeList = doc.elementsByTagName("iFPViewWidth");
    if (nodeList.count() > 0)
    {
        ifpViewWidth = nodeList.item(0).toElement().text().toInt();
    }

    nodeList = doc.elementsByTagName("DefaultFolder");
    if (nodeList.count() > 0)
    {
        folderName = nodeList.item(0).toElement().text();
    }

    nodeList = doc.elementsByTagName("PlaylistFolder");
    if (nodeList.count() > 0)
    {
        playlistFolder = nodeList.item(0).toElement().text();
    }

    nodeList = doc.elementsByTagName("Auto-ConvertRECFiles");
    if (nodeList.count() > 0)
    {
        if (nodeList.item(0).toElement().text() == "TRUE")
            autoConvert = true;
    }

    nodeList = doc.elementsByTagName("iFPViewAlignment");
    if (nodeList.count() > 0)
    {
        if (nodeList.item(0).toElement().text() == "VERT")
            viewAlignment = Qt::Vertical;
    }
}

Settings::~Settings()
{
}

void Settings::saveSettings(QString &fileName)
{
    QDomElement tag;
    QDomText txt;

    QDomDocument doc("ifpgui-settings");
    QDomElement root = doc.createElement("Settings" );
    doc.appendChild( root );

    tag = doc.createElement("WindowWidth");
    root.appendChild(tag);
    txt = doc.createTextNode(QString("%1").arg(windowWidth));
    tag.appendChild(txt);

    tag = doc.createElement("WindowHeight");
    root.appendChild(tag);
    txt = doc.createTextNode(QString("%1").arg(windowHeight));
    tag.appendChild(txt);

    tag = doc.createElement("DirViewWidth");
    root.appendChild(tag);
    txt = doc.createTextNode(QString("%1").arg(dirViewWidth));
    tag.appendChild(txt);

    tag = doc.createElement("iFPViewWidth");
    root.appendChild(tag);
    txt = doc.createTextNode(QString("%1").arg(ifpViewWidth));
    tag.appendChild(txt);

    tag = doc.createElement("DefaultFolder");
    root.appendChild(tag);
    txt = doc.createTextNode(folderName);
    tag.appendChild(txt);

    tag = doc.createElement("PlaylistFolder");
    root.appendChild(tag);
    txt = doc.createTextNode(playlistFolder);
    tag.appendChild(txt);

    tag = doc.createElement("Auto-ConvertRECFiles");
    root.appendChild(tag);
    if (autoConvert == true)
        txt = doc.createTextNode(QString("TRUE"));
    else
        txt = doc.createTextNode(QString("FALSE"));
    tag.appendChild(txt);

    tag = doc.createElement("iFPViewAlignment");
    root.appendChild(tag);
    if (viewAlignment == Qt::Horizontal)
        txt = doc.createTextNode(QString("HORZ"));
    else
        txt = doc.createTextNode(QString("VERT"));
    tag.appendChild(txt);

    QString xml = doc.toString();

    QFile file(fileName);
    if (!file.open(QIODevice::WriteOnly))
        return;
    QTextStream textstream(&file);
    textstream << xml;

    file.close();
}

void Settings::setWindowSize(int width, int height)
{
    windowHeight = height;
    windowWidth  = width;
}

void Settings::setDefaultFolder(QString &defFolder)
{
    folderName = defFolder;
}

void Settings::setPlaylistFolder(QString &defFolder)
{
    playlistFolder = defFolder;
}

void Settings::setDirViewWidth(int width)
{
    dirViewWidth = width;
}

void Settings::setIfpViewWidth(int width)
{
    ifpViewWidth = width;
}

void Settings::setAutoConvertREC(bool autoCvt)
{
    autoConvert = autoCvt;
}

void Settings::setViewAlignment(int alignment)
{
    viewAlignment = alignment;
}

void Settings::getWindowSize(int *width, int *height)
{
    *height = windowHeight;
    *width  = windowWidth;
}

QString Settings::getDefaultFolder()
{
    return(folderName);
}

QString Settings::getPlaylistFolder()
{
    return(playlistFolder);
}

int Settings::getDirViewWidth()
{
    return(dirViewWidth);
}

int Settings::getIfpViewWidth()
{
    return(ifpViewWidth);
}

bool Settings::getAutoConvertREC()
{
    return(autoConvert);
}

int Settings::getViewAlignment()
{
    return(viewAlignment);
}
