/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.text.Collator;
import java.util.Locale;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Charset;

public class Collation
implements SchemaObject {
    static String defaultCollationName = "SQL_TEXT";
    public static final HashMap nameToJavaName = new HashMap(101);
    public static final HashMap dbNameToJavaName = new HashMap(101);
    public static final HashMap dbNameToCollation = new HashMap(11);
    static final Collation defaultCollation;
    final HsqlNameManager.HsqlName name;
    private Collator collator;
    private Locale locale;
    private boolean equalIsIdentical = true;
    private boolean isFinal;
    private boolean padSpace = true;
    private Charset charset;
    private HsqlNameManager.HsqlName sourceName;

    private Collation() {
        this.locale = Locale.ENGLISH;
        this.name = HsqlNameManager.newInfoSchemaObjectName(defaultCollationName, false, 15);
        this.isFinal = true;
    }

    private Collation(String string, String string2, String string3) {
        this.locale = new Locale(string2, string3);
        this.collator = Collator.getInstance(this.locale);
        this.equalIsIdentical = false;
        this.name = HsqlNameManager.newInfoSchemaObjectName(string, true, 15);
        this.charset = TypeInvariants.SQL_TEXT;
        this.isFinal = true;
    }

    public Collation(HsqlNameManager.HsqlName hsqlName, Collation collation, Charset charset, Boolean bl) {
        this.name = hsqlName;
        this.locale = collation.locale;
        this.collator = collation.collator;
        this.equalIsIdentical = collation.equalIsIdentical;
        this.isFinal = true;
        this.charset = charset;
        this.sourceName = collation.name;
        this.padSpace = bl;
    }

    public static Collation getDefaultInstance() {
        return defaultCollation;
    }

    public static Collation newDatabaseInstance() {
        Collation collation = new Collation();
        collation.isFinal = false;
        return collation;
    }

    public static Iterator getCollationsIterator() {
        return nameToJavaName.keySet().iterator();
    }

    public static Iterator getLocalesIterator() {
        return nameToJavaName.values().iterator();
    }

    public static synchronized Collation getCollation(String string) {
        Collation collation = (Collation)dbNameToCollation.get(string);
        if (collation != null) {
            return collation;
        }
        if (defaultCollationName.equals(string)) {
            dbNameToCollation.put(defaultCollationName, defaultCollation);
            return defaultCollation;
        }
        String string2 = (String)dbNameToJavaName.get(string);
        if (string2 == null && (string2 = (String)nameToJavaName.get(string)) == null) {
            throw Error.error(5501, string2);
        }
        String[] stringArray = StringUtil.split(string2, "-");
        String string3 = stringArray[0];
        String string4 = stringArray.length == 2 ? stringArray[1] : "";
        collation = new Collation(string, string3, string4);
        dbNameToCollation.put(string, collation);
        return collation;
    }

    public void setPadding(boolean bl) {
        if (this.isFinal) {
            throw Error.error(5503);
        }
        this.padSpace = bl;
    }

    public void setCollationAsLocale() {
        Locale locale = Locale.getDefault();
        String string = locale.getDisplayLanguage(Locale.ENGLISH);
        try {
            this.setCollation(string, false);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setCollation(String string, Boolean bl) {
        if (this.isFinal) {
            throw Error.error(5503, string);
        }
        if (defaultCollationName.equals(string)) {
            this.locale = Locale.ENGLISH;
            this.name.rename(defaultCollationName, false);
            this.collator = null;
            this.equalIsIdentical = true;
        } else {
            String string2 = (String)nameToJavaName.get(string);
            if (string2 == null) {
                string2 = (String)dbNameToJavaName.get(string);
            }
            if (string2 == null) {
                throw Error.error(5501, string);
            }
            this.name.rename(string, true);
            String[] stringArray = StringUtil.split(string2, "-");
            String string3 = stringArray[0];
            String string4 = stringArray.length == 2 ? stringArray[1] : "";
            this.locale = new Locale(string3, string4);
            this.collator = Collator.getInstance(this.locale);
            this.equalIsIdentical = false;
        }
        this.padSpace = bl;
    }

    public boolean isPadSpace() {
        return this.padSpace;
    }

    public boolean isEqualAlwaysIdentical() {
        return this.collator == null;
    }

    public int compare(String string, String string2) {
        int n = this.collator == null ? string.compareTo(string2) : this.collator.compare(string, string2);
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public int compareIgnoreCase(String string, String string2) {
        int n = this.collator == null ? JavaSystem.compareIngnoreCase(string, string2) : this.collator.compare(this.toUpperCase(string), this.toUpperCase(string2));
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public String toUpperCase(String string) {
        return string.toUpperCase(this.locale);
    }

    public String toLowerCase(String string) {
        return string.toLowerCase(this.locale);
    }

    public boolean isDefaultCollation() {
        return this.collator == null && this.padSpace;
    }

    public boolean isObjectCollation() {
        return this.isFinal && this.collator != null;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("COLLATION").append(' ');
        stringBuffer.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        stringBuffer.append("FOR").append(' ');
        stringBuffer.append(this.charset.name.getSchemaQualifiedStatementName()).append(' ');
        stringBuffer.append("FROM").append(' ');
        stringBuffer.append(this.sourceName.statementName);
        stringBuffer.append(' ');
        if (this.padSpace) {
            stringBuffer.append("PAD").append(' ').append("SPACE");
        } else {
            stringBuffer.append("NO").append(' ').append("PAD");
        }
        return stringBuffer.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getDatabaseCollationSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("DATABASE").append(' ');
        stringBuffer.append("COLLATION").append(' ');
        stringBuffer.append(this.getName().statementName);
        stringBuffer.append(' ');
        if (this.padSpace) {
            stringBuffer.append("PAD").append(' ').append("SPACE");
        } else {
            stringBuffer.append("NO").append(' ').append("PAD");
        }
        return stringBuffer.toString();
    }

    static {
        nameToJavaName.put("Afrikaans", "af-ZA");
        nameToJavaName.put("Amharic", "am-ET");
        nameToJavaName.put("Arabic", "ar");
        nameToJavaName.put("Assamese", "as-IN");
        nameToJavaName.put("Azerbaijani_Latin", "az-AZ");
        nameToJavaName.put("Azerbaijani_Cyrillic", "az-cyrillic");
        nameToJavaName.put("Belarusian", "be-BY");
        nameToJavaName.put("Bulgarian", "bg-BG");
        nameToJavaName.put("Bengali", "bn-IN");
        nameToJavaName.put("Tibetan", "bo-CN");
        nameToJavaName.put("Bosnian", "bs-BA");
        nameToJavaName.put("Catalan", "ca-ES");
        nameToJavaName.put("Czech", "cs-CZ");
        nameToJavaName.put("Welsh", "cy-GB");
        nameToJavaName.put("Danish", "da-DK");
        nameToJavaName.put("German", "de-DE");
        nameToJavaName.put("Greek", "el-GR");
        nameToJavaName.put("Latin1_General", "en-US");
        nameToJavaName.put("English", "en-US");
        nameToJavaName.put("Spanish", "es-ES");
        nameToJavaName.put("Estonian", "et-EE");
        nameToJavaName.put("Basque", "eu");
        nameToJavaName.put("Finnish", "fi-FI");
        nameToJavaName.put("French", "fr-FR");
        nameToJavaName.put("Guarani", "gn-PY");
        nameToJavaName.put("Gujarati", "gu-IN");
        nameToJavaName.put("Hausa", "ha-NG");
        nameToJavaName.put("Hebrew", "he-IL");
        nameToJavaName.put("Hindi", "hi-IN");
        nameToJavaName.put("Croatian", "hr-HR");
        nameToJavaName.put("Hungarian", "hu-HU");
        nameToJavaName.put("Armenian", "hy-AM");
        nameToJavaName.put("Indonesian", "id-ID");
        nameToJavaName.put("Igbo", "ig-NG");
        nameToJavaName.put("Icelandic", "is-IS");
        nameToJavaName.put("Italian", "it-IT");
        nameToJavaName.put("Inuktitut", "iu-CA");
        nameToJavaName.put("Japanese", "ja-JP");
        nameToJavaName.put("Georgian", "ka-GE");
        nameToJavaName.put("Kazakh", "kk-KZ");
        nameToJavaName.put("Khmer", "km-KH");
        nameToJavaName.put("Kannada", "kn-IN");
        nameToJavaName.put("Korean", "ko-KR");
        nameToJavaName.put("Konkani", "kok-IN");
        nameToJavaName.put("Kashmiri", "ks");
        nameToJavaName.put("Kirghiz", "ky-KG");
        nameToJavaName.put("Lao", "lo-LA");
        nameToJavaName.put("Lithuanian", "lt-LT");
        nameToJavaName.put("Latvian", "lv-LV");
        nameToJavaName.put("Maori", "mi-NZ");
        nameToJavaName.put("Macedonian", "mk-MK");
        nameToJavaName.put("Malayalam", "ml-IN");
        nameToJavaName.put("Mongolian", "mn-MN");
        nameToJavaName.put("Manipuri", "mni-IN");
        nameToJavaName.put("Marathi", "mr-IN");
        nameToJavaName.put("Malay", "ms-MY");
        nameToJavaName.put("Maltese", "mt-MT");
        nameToJavaName.put("Burmese", "my-MM");
        nameToJavaName.put("Danish_Norwegian", "nb-NO");
        nameToJavaName.put("Nepali", "ne-NP");
        nameToJavaName.put("Dutch", "nl-NL");
        nameToJavaName.put("Norwegian", "nn-NO");
        nameToJavaName.put("Oriya", "or-IN");
        nameToJavaName.put("Punjabi", "pa-IN");
        nameToJavaName.put("Polish", "pl-PL");
        nameToJavaName.put("Pashto", "ps-AF");
        nameToJavaName.put("Portuguese", "pt-PT");
        nameToJavaName.put("Romanian", "ro-RO");
        nameToJavaName.put("Russian", "ru-RU");
        nameToJavaName.put("Sanskrit", "sa-IN");
        nameToJavaName.put("Sindhi", "sd-IN");
        nameToJavaName.put("Slovak", "sk-SK");
        nameToJavaName.put("Slovenian", "sl-SI");
        nameToJavaName.put("Somali", "so-SO");
        nameToJavaName.put("Albanian", "sq-AL");
        nameToJavaName.put("Serbian_Cyrillic", "sr-YU");
        nameToJavaName.put("Serbian_Latin", "sh-BA");
        nameToJavaName.put("Swedish", "sv-SE");
        nameToJavaName.put("Swahili", "sw-KE");
        nameToJavaName.put("Tamil", "ta-IN");
        nameToJavaName.put("Telugu", "te-IN");
        nameToJavaName.put("Tajik", "tg-TJ");
        nameToJavaName.put("Thai", "th-TH");
        nameToJavaName.put("Turkmen", "tk-TM");
        nameToJavaName.put("Tswana", "tn-BW");
        nameToJavaName.put("Turkish", "tr-TR");
        nameToJavaName.put("Tatar", "tt-RU");
        nameToJavaName.put("Ukrainian", "uk-UA");
        nameToJavaName.put("Urdu", "ur-PK");
        nameToJavaName.put("Uzbek_Latin", "uz-UZ");
        nameToJavaName.put("Venda", "ven-ZA");
        nameToJavaName.put("Vietnamese", "vi-VN");
        nameToJavaName.put("Yoruba", "yo-NG");
        nameToJavaName.put("Chinese", "zh-CN");
        nameToJavaName.put("Zulu", "zu-ZA");
        Iterator iterator = nameToJavaName.values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.replace('-', '_').toUpperCase(Locale.ENGLISH);
            dbNameToJavaName.put(string2, string);
        }
        defaultCollation = new Collation();
        Collation.defaultCollation.charset = TypeInvariants.SQL_TEXT;
    }
}

