/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

public class HashIndex {
    int[] hashTable;
    int[] linkTable;
    int newNodePointer;
    int elementCount;
    int reclaimedNodePointer = -1;
    boolean fixedSize;
    boolean modified;

    public HashIndex(int n, int n2, boolean bl) {
        if (n2 < n) {
            n2 = n;
        }
        this.reset(n, n2);
        this.fixedSize = bl;
    }

    public void reset(int n, int n2) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n2];
        this.hashTable = nArray;
        this.linkTable = nArray2;
        this.resetTables();
    }

    public void resetTables() {
        int n = this.hashTable.length;
        int[] nArray = this.hashTable;
        while (--n >= 0) {
            nArray[n] = -1;
        }
        this.newNodePointer = 0;
        this.elementCount = 0;
        this.reclaimedNodePointer = -1;
        this.modified = false;
    }

    public void clear() {
        int n = this.linkTable.length;
        int[] nArray = this.linkTable;
        while (--n >= 0) {
            nArray[n] = 0;
        }
        this.resetTables();
    }

    public int getHashIndex(int n) {
        return (n & Integer.MAX_VALUE) % this.hashTable.length;
    }

    public int getLookup(int n) {
        if (this.elementCount == 0) {
            return -1;
        }
        int n2 = (n & Integer.MAX_VALUE) % this.hashTable.length;
        return this.hashTable[n2];
    }

    public int getNextLookup(int n) {
        return this.linkTable[n];
    }

    public int linkNode(int n, int n2) {
        int n3 = this.reclaimedNodePointer;
        if (n3 == -1) {
            n3 = this.newNodePointer++;
        } else {
            this.reclaimedNodePointer = this.linkTable[n3];
        }
        if (n2 == -1) {
            this.hashTable[n] = n3;
        } else {
            this.linkTable[n2] = n3;
        }
        this.linkTable[n3] = -1;
        ++this.elementCount;
        this.modified = true;
        return n3;
    }

    public void unlinkNode(int n, int n2, int n3) {
        if (n2 == -1) {
            this.hashTable[n] = this.linkTable[n3];
        } else {
            this.linkTable[n2] = this.linkTable[n3];
        }
        this.linkTable[n3] = this.reclaimedNodePointer;
        this.reclaimedNodePointer = n3;
        --this.elementCount;
    }

    public boolean removeEmptyNode(int n) {
        boolean bl = false;
        int n2 = -1;
        int n3 = this.reclaimedNodePointer;
        while (n3 >= 0) {
            if (n3 == n) {
                if (n2 == -1) {
                    this.reclaimedNodePointer = this.linkTable[n];
                } else {
                    this.linkTable[n2] = this.linkTable[n];
                }
                bl = true;
                break;
            }
            n2 = n3;
            n3 = this.linkTable[n3];
        }
        if (!bl) {
            return false;
        }
        for (n3 = 0; n3 < this.newNodePointer; ++n3) {
            if (this.linkTable[n3] <= n) continue;
            int n4 = n3;
            this.linkTable[n4] = this.linkTable[n4] - 1;
        }
        System.arraycopy(this.linkTable, n + 1, this.linkTable, n, this.newNodePointer - n - 1);
        this.linkTable[this.newNodePointer - 1] = 0;
        --this.newNodePointer;
        for (n3 = 0; n3 < this.hashTable.length; ++n3) {
            if (this.hashTable[n3] <= n) continue;
            int n5 = n3;
            this.hashTable[n5] = this.hashTable[n5] - 1;
        }
        return true;
    }
}

