<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.filteriterator.php )
 *
 * This abstract iterator filters out unwanted values. This class should
 * be extended to implement custom iterator filters. The
 * FilterIterator::accept() must be implemented in the subclass.
 *
 */
abstract class FilterIterator extends IteratorIterator {
  private $it;

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/filteriterator.construct.php )
   *
   * Constructs a new FilterIterator, which consists of a passed in iterator
   * with filters applied to it. Warning: This function is currently not
   * documented; only its argument list is available.
   *
   * @it         mixed   The iterator that is being filtered.
   *
   * @return     mixed   The FilterIterator.
   */
  public function __construct(\Iterator $it) {
    $this->it = $it;
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/filteriterator.rewind.php )
   *
   *
   * @return     mixed   No value is returned.
   */
  public function rewind() {
    $this->it->rewind();
    $this->fetch();
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/filteriterator.accept.php )
   *
   * Returns whether the current element of the iterator is acceptable
   * through this filter.
   *
   * @return     mixed   TRUE if the current element is acceptable, otherwise
   *                     FALSE.
   */
  abstract function accept();

  private function fetch() {
    while ($this->it->valid()) {
      if ($this->accept()) {
        return;
      }
      $this->it->next();
    }
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/filteriterator.next.php )
   *
   *
   * @return     mixed   No value is returned.
   */
  public function next() {
    $this->it->next();
    $this->fetch();
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/filteriterator.valid.php )
   *
   *
   * @return     mixed   TRUE if the current element is valid, otherwise
   *                     FALSE
   */
  public function valid() {
    return $this->it->valid();
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/filteriterator.key.php )
   *
   *
   * @return     mixed   The current key.
   */
  public function key() {
    return $this->it->key();
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/filteriterator.current.php )
   *
   *
   * @return     mixed   The current element value.
   */
  public function current() {
    return $this->it->current();
  }

  protected function __clone() {
    // disallow clone
  }

  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from
   * http://php.net/manual/en/filteriterator.getinneriterator.php )
   *
   *
   * @return     mixed   The inner iterator.
   */
  public function getInnerIterator() {
    return $this->it;
  }

  public function __call($func, $params) {
    return call_user_func_array(array($this->it, $func), $params);
  }
}

