/*
 ******************************************************************
 * File:        TestAlias.c                                       *
 *                                                                *
 * Date:        Oct 02, 2000                                      *
 * Programmer:  A.Muslimov, Emergent Information Technologies,Inc *
 * Purpose:     Testing Swath interfacing routines                *        
 ******************************************************************
 */

#include        <HE5_HdfEosDef.h>

#define  FILENAME   "Alias.he5"
#define  RANK       2

main()
{
  herr_t       status = FAIL;
  
  int          i, j;
  int          rank       = FAIL;
  int          length     = 0;
  int          attr[1]    = {2000};
  int          fieldgroup = FAIL;
  int          comp_level[5] = { 0,0,0,0,0 };
  int          comp_code;
  int          level[5] = {0,0,0,0,0}, code = 0;
  int          *fldrank = (int *)NULL;

  H5T_class_t  dtype   = H5T_NO_CLASS; 
  hid_t        dtype1  = FAIL;
  H5T_order_t  order   = H5T_ORDER_ERROR;
  hid_t        ntype[3] = {FAIL,FAIL,FAIL}; 

  long         nattr      = FAIL;
  long         nfldalias     = FAIL;
  long         strbufsize = FAIL; 
  long         nflds = FAIL;
  long         nalias = FAIL;

  hid_t        SWid = FAIL, swfid = FAIL;
  hid_t        datatype = FAIL;
  
  float        data[ 20 ][ 10 ];
  float        out_buffer[ 20 ][ 10 ];
  float        fillvalue = -777.777;
  float        out_fillvalue = -1.;

  size_t       size    = 0;

  hssize_t     start[ 2 ] = { 0, 0 };
  hsize_t      count[ 2 ] = { 5, 5};
  hsize_t      nelem = 0;
  hsize_t      dims[8] = {0, 0, 0, 0, 0, 0, 0, 0};
  hsize_t      chunk_dims[ 2 ];
  
  char         dimlist[80];
  char         maxdimlist[80];
  char         *namebuf, attrlist[80];
  char         fldlist[80];
  char         fldalias[80];
  char         aliaslist[80];

  /* 
   *****************************************************************************
   *                 Open/Create the Swath "Test_1"                            *
   *****************************************************************************
   */
  
  swfid = HE5_SWopen(FILENAME, H5F_ACC_TRUNC);
  printf("Swath file ID                      = %d\n", swfid);
  
  SWid   = HE5_SWcreate(swfid,"Test_1"); 
  printf("Swath ID                           = %d\n", SWid);
  
  /* 
   *****************************************************************************
   *                     Define Dimensions                                     *
   *****************************************************************************
   */
  
  
  status = HE5_SWdefdim(SWid,"DataTrack", 20);
  printf("status returned by HE5_SWdefdim        = %d\n", status);
  
  status = HE5_SWdefdim(SWid,"DataXtrack", 10);
  printf("status returned by HE5_SWdefdim        = %d\n", status);

  chunk_dims[ 0 ] = 10;
  chunk_dims[ 1 ] = 5;
  comp_code       = 4;
  comp_level[0]   = 6;
  
  status = HE5_SWdefcomchunk(SWid, comp_code, comp_level, RANK, chunk_dims);
  printf("status returned by HE5_SWdefcomchunk   = %d\n", status);

  status = HE5_SWsetfillvalue(SWid, "Temperature", H5T_NATIVE_FLOAT, &fillvalue);
  printf("status returned by HE5_SWsetfillvalue  = %d\n", status);

  status = HE5_SWdefdatafield(SWid,"Temperature", "DataTrack,DataXtrack", NULL, H5T_NATIVE_FLOAT, 0);
  printf("status returned by HE5_SWdefdatafield  = %d\n", status);

  
  /* 
   *****************************************************************************
   *                  Write data to the field "Temperature"                    *
   *****************************************************************************
   */
  for ( i = 0; i < 20; i++ )
	for( j = 0; j < 10; j++ )
	  data[ i ][ j ] = 1.e0 + i + 5.e-2 * j ;
  
  status  = HE5_SWwritefield(SWid,"Temperature", start, NULL, count, data );
  printf("status returned by HE5_SWwritefield    = %d\n", status);

  /* Set aliases for field "Temperature" */
  /* ----------------------------------- */
  status  = HE5_SWsetalias(SWid,"Temperature","T,Tmp,Temp,L2gpValue,ZZZ");
  printf("status returned by HE5_SWsetalias      = %d\n", status);

  strcpy(fldalias,"");
  nfldalias = HE5_SWinqdfldalias(SWid, fldalias, &strbufsize);
  printf("Number of fields & aliases is: %li\n", nfldalias);
  printf("Fields & aliases list:            %s \n", fldalias);
  printf("Length of fields & aliases list:  %li \n", strbufsize);

  strcpy(aliaslist,"");
  nalias = HE5_SWgetaliaslist(SWid, HE5_HDFE_DATAGROUP, aliaslist, &strbufsize);
  printf("Number of aliases is: %li\n", nalias);
  printf("Aliases list:            %s \n", aliaslist);
  printf("Length of aliases list:  %li \n", strbufsize);


  /* Get information about alias "Temp" */
  /* ---------------------------------- */
  status = HE5_SWaliasinfo(SWid,  HE5_HDFE_DATAGROUP, "Temp", &length, NULL);
  if (status == SUCCEED)
	printf("Name length: %d \n", length);
  
  namebuf = (char *)calloc(length+1, sizeof(char));

  /* Get the actual name of the field "Temp" */
  /* --------------------------------------- */
  status = HE5_SWaliasinfo(SWid,  HE5_HDFE_DATAGROUP, "Temp", &length, namebuf);
  if (status == SUCCEED)
	printf("Original field name: %s \n", namebuf);
  
  free(namebuf);

  /* Remove alias "Tmp" from the alias list */
  /* -------------------------------------- */
  status  = HE5_SWdropalias(SWid, HE5_HDFE_DATAGROUP, "Tmp");
  printf("status returned by HE5_SWdropalias     = %d\n", status);

  /* Remove alias "Temp" from the alias list */
  /* --------------------------------------- */
  status  = HE5_SWdropalias(SWid, HE5_HDFE_DATAGROUP, "Temp");
  printf("status returned by HE5_SWdropalias     = %d\n", status);

  /* Get information about alias  "L2gpValue" */
  /* ---------------------------------------- */  
  status = HE5_SWaliasinfo(SWid,  HE5_HDFE_DATAGROUP, "L2gpValue", &length, NULL);
  if (status == SUCCEED)
	printf("Name length: %d \n", length);
  

  namebuf = (char *)calloc(length+1, sizeof(char));

  /* Get the actual name of the field "L2gpValue" */
  /* -------------------------------------------- */  
  status = HE5_SWaliasinfo(SWid, HE5_HDFE_DATAGROUP, "L2gpValue", &length, namebuf);
  if (status == SUCCEED)
	printf("Original field name: %s \n", namebuf);
  
  free(namebuf);

  count[0] = 20;  count[1] = 10;
  
  /* Read the data from the field calling it by alias */
  /* ------------------------------------------------ */
  status  = HE5_SWreadfield(SWid,"L2gpValue", start, NULL, count, out_buffer);
  printf("status returned by HE5_SWreadfield     = %d\n", status);

  printf("Data from \"L2gpValue\" field: \n");
  for ( i = 0; i < 20; i++ )
	for( j = 0; j < 10; j++ )
	  printf("%f \n", out_buffer[ i ][ j ]);

  /* Write local attribute to "L2gpValue" */
  /* ------------------------------------ */
  count[0] = 1;
  status = HE5_SWwritelocattr(SWid, "L2gpValue", "LocalAttribute", H5T_NATIVE_INT, count, attr);
  printf("status returned by HE5_SWwritelocattr  = %d\n", status);


  status = HE5_SWdetach(SWid);
  printf("status returned by HE5_SWdetach        = %d\n", status); 

  SWid = HE5_SWattach(swfid,"Test_1");
  printf("Swath ID returned by HE5_SWattach      = %d\n", SWid); 

  printf("Local Attributes:\n");
  nattr = HE5_SWinqlocattrs(SWid, "L2gpValue", NULL, &strbufsize);
  printf("Number of attributes:      %li \n", nattr);
  printf("Length of attribute list:  %li \n", strbufsize);
  strcpy(attrlist,"");
  nattr = HE5_SWinqlocattrs(SWid, "L2gpValue", attrlist, &strbufsize);
  printf("Attribute list:            %s \n", attrlist);

  printf("Local Attribute:\n");
  status = HE5_SWlocattrinfo(SWid,"T", "LocalAttribute",&dtype1, &nelem);
  printf("Data type:                 %d\n", dtype1);
  printf("Number of elements:        %lu \n", (unsigned long)nelem);    

  status = HE5_SWfieldinfo(SWid, "L2gpValue", &rank, dims, &dtype1, dimlist, maxdimlist);
  printf("Status returned by HE5_SWfieldinfo	= %d\n", status);
  if (status != FAIL)
	{
	  printf("Field rank:                %d \n", rank);
	  printf("Dimension Sizes: \n");
	  for ( i = 0; i < rank; i++)
		{
		  printf("                           %lu \n", (unsigned long)dims[i]);
		}
  
	  printf("Number type ID:            %d \n", dtype1);  
	  printf("DimList string:            %s \n", dimlist);
	  printf("MaxdimList string:         %s \n", maxdimlist);
	}

  fieldgroup = HE5_HDFE_DATAGROUP;
  status = HE5_SWinqdatatype(SWid, "T", NULL, fieldgroup, &datatype, &dtype, &order, &size);
  printf("status returned by HE5_SWinqdatatype   = %d \n", status);
  if (status != FAIL)
	{
	  printf("Data type ID:              %d \n", datatype);
	  printf("Data type class ID:        %d \n", dtype);
	  printf("Byte order:                %d \n", order);
	  printf("Data size (bytes):         %d \n", (int)size);        
	}

  status  = HE5_SWcompinfo(SWid,"L2gpValue", &code, level);
  printf("status returned by HE5_SWcompinfo      = %d\n", status);
  if (status != FAIL)
	{
	  printf("Compression Information: \n");  
	  printf("Compression code:          %d \n", code);
	  printf("Compression level:         %d \n", level[0]);
	}

  status = HE5_SWgetfillvalue(SWid,"L2gpValue",&out_fillvalue);
  printf("status returned by HE5_SWgetfillvalue  = %d\n", status);
  printf("The fill value:            %f\n", out_fillvalue);

  status = HE5_SWdetach(SWid);
  printf("status returned by HE5_SWdetach        = %d\n", status); 

  SWid = HE5_SWattach(swfid,"Test_1");
  printf("Swath ID returned by HE5_SWattach      = %d\n", SWid); 

  
  nflds = HE5_SWnentries(SWid,4,&strbufsize);
  printf("Value returned by HE5_SWnentries       = %li\n", nflds); 
  if (nflds != FAIL)
	{
	  fldrank   = (int *)calloc(nflds, sizeof(int));
	 
	  nflds = FAIL;
	  nflds = HE5_SWinqdatafields(SWid,fldlist,fldrank,ntype);
	  printf("Value returned by HE5_SWinqdatafields  = %li \n", nflds);
	  if (nflds != FAIL)
		{
		  printf("List of fields:            %s \n", fldlist); 
		  for (i = 0; i < nflds; i++)
			printf("Field rank, number type ID:      %d, %d \n",fldrank[i],ntype[i]);
		}
	  
	  free(fldrank);
	  
	}

  status = HE5_SWdetach(SWid);
  printf("status returned by HE5_SWdetach        = %d\n", status); 
  
  status = HE5_SWclose(swfid);
  printf("status returned by HE5_SWclose         = %d\n", status);
}

















