#-------------------------------------------------------------------------------
MACRO (EXTERNAL_HDF5_LIBRARY compress_type libtype)
  IF (${compress_type} MATCHES "SVN")
    EXTERNALPROJECT_ADD (HDF5
        SVN_REPOSITORY ${HDF5_URL}
        # [SVN_REVISION rev] 
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DHDF_LEGACY_NAMING:BOOL=OFF
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDFEOS_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF5_BUILD_TOOLS:BOOL=ON
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="SVN"
            -DZLIB_SVN_URL:STRING=${ZLIB_SVN_URL}
            -DSZIP_SVN_URL:STRING=${SZIP_SVN_URL}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    ) 
  ENDIF (${compress_type} MATCHES "SVN")
  IF (${compress_type} MATCHES "TGZ")
    EXTERNALPROJECT_ADD (HDF5
        URL ${HDF5_URL}
        URL_MD5 ""
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DHDF_LEGACY_NAMING:BOOL=OFF
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDFEOS_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF5_BUILD_TOOLS:BOOL=ON
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="TGZ"
            -DTGZ_PATH:STRING=${TGZ_PATH}
            -DZLIB_TGZ_NAME:STRING=${ZLIB_TGZ_NAME}
            -DSZIP_TGZ_NAME:STRING=${SZIP_TGZ_NAME}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    ) 
  ENDIF (${compress_type} MATCHES "TGZ")
  EXTERNALPROJECT_GET_PROPERTY (HDF5 BINARY_DIR SOURCE_DIR) 

  IF (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")
    IF (WIN32)
      SET (HDF5_LIB_NAME "hdf5_D")
    ELSE (WIN32)
      SET (HDF5_LIB_NAME "hdf5_debug")
    ENDIF (WIN32)
  ELSE (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")
    SET (HDF5_LIB_NAME "hdf5")
  ENDIF (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")

  # Create imported target hdf5
  ADD_LIBRARY(hdf5 ${libtype} IMPORTED)
  ADD_DEPENDENCIES (hdf5 HDF5)

  IF (${libtype} MATCHES "SHARED")
    IF (WIN32)
      IF (MINGW)
        SET_TARGET_PROPERTIES(hdf5 PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${HDF5_LIB_NAME}.lib"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
        )
      ELSE (MINGW)
        SET_TARGET_PROPERTIES(hdf5 PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
        )
      ENDIF (MINGW)
    ELSE (WIN32)
      SET_TARGET_PROPERTIES(hdf5 PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
          IMPORTED_SONAME "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${HDF5_VERSION_STRING}"
          SOVERSION "${HDF5_VERSION_STRING}"
      )
    ENDIF (WIN32)
  ELSE (${libtype} MATCHES "SHARED")
    IF (WIN32 AND NOT MINGW)
      SET_TARGET_PROPERTIES(hdf5 PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${HDF5_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
    ELSE (WIN32 AND NOT MINGW)
      SET_TARGET_PROPERTIES(hdf5 PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${HDF5_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
    ENDIF (WIN32 AND NOT MINGW)
  ENDIF (${libtype} MATCHES "SHARED")
  SET (HDF5_LIBRARY "hdf5")

  SET (HDF5_INCLUDE_DIR_GEN "${BINARY_DIR}")
  SET (HDF5_INCLUDE_DIR "${SOURCE_DIR}/src")
  SET (HDF5_FOUND 1)
  SET (HDF5_LIBRARIES ${HDF5_LIBRARY})
  SET (HDF5_INCLUDE_DIRS ${HDF5_INCLUDE_DIR_GEN} ${HDF5_INCLUDE_DIR})
  ADD_EXECUTABLE (h5diff IMPORTED)
  IF (${libtype} MATCHES "SHARED" AND WIN32)
    SET_PROPERTY (TARGET h5diff PROPERTY IMPORTED_LOCATION "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/h5diffdll")
  ELSE (${libtype} MATCHES "SHARED" AND WIN32)
    SET_PROPERTY (TARGET h5diff PROPERTY IMPORTED_LOCATION "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/h5diff")
  ENDIF (${libtype} MATCHES "SHARED" AND WIN32)
  SET (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:h5diff>)
ENDMACRO (EXTERNAL_HDF5_LIBRARY)

#-------------------------------------------------------------------------------
MACRO (PACKAGE_HDF5_LIBRARY compress_type)
  ADD_CUSTOM_TARGET (HDF5-GenHeader-Copy ALL
      COMMAND ${CMAKE_COMMAND} -E copy_if_different ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/
      COMMENT "Copying ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h to ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/"
  )
  IF (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "TGZ")
    ADD_DEPENDENCIES (HDF5-GenHeader-Copy HDF5)
  ENDIF (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "TGZ")
ENDMACRO (PACKAGE_HDF5_LIBRARY)
