{-# LANGUAGE OverloadedStrings #-}
module Main where

import Test.Framework (defaultMain, testGroup)
import Crypto.Cipher.Blowfish
import Crypto.Cipher.Types
import Crypto.Cipher.Tests
import Data.ByteString.Char8 () -- orphan IsString for older bytestring versions

vectors_ecb = -- key plaintext cipher
    [ KAT_ECB "\x00\x00\x00\x00\x00\x00\x00\x00" "\x00\x00\x00\x00\x00\x00\x00\x00" "\x4E\xF9\x97\x45\x61\x98\xDD\x78"
    , KAT_ECB "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" "\x51\x86\x6F\xD5\xB8\x5E\xCB\x8A"
    , KAT_ECB "\x30\x00\x00\x00\x00\x00\x00\x00" "\x10\x00\x00\x00\x00\x00\x00\x01" "\x7D\x85\x6F\x9A\x61\x30\x63\xF2"
    , KAT_ECB "\x11\x11\x11\x11\x11\x11\x11\x11" "\x11\x11\x11\x11\x11\x11\x11\x11" "\x24\x66\xDD\x87\x8B\x96\x3C\x9D"
    , KAT_ECB "\x01\x23\x45\x67\x89\xAB\xCD\xEF" "\x11\x11\x11\x11\x11\x11\x11\x11" "\x61\xF9\xC3\x80\x22\x81\xB0\x96"
    , KAT_ECB "\x11\x11\x11\x11\x11\x11\x11\x11" "\x01\x23\x45\x67\x89\xAB\xCD\xEF" "\x7D\x0C\xC6\x30\xAF\xDA\x1E\xC7"
    , KAT_ECB "\x00\x00\x00\x00\x00\x00\x00\x00" "\x00\x00\x00\x00\x00\x00\x00\x00" "\x4E\xF9\x97\x45\x61\x98\xDD\x78"
    , KAT_ECB "\xFE\xDC\xBA\x98\x76\x54\x32\x10" "\x01\x23\x45\x67\x89\xAB\xCD\xEF" "\x0A\xCE\xAB\x0F\xC6\xA0\xA2\x8D"
    , KAT_ECB "\x7C\xA1\x10\x45\x4A\x1A\x6E\x57" "\x01\xA1\xD6\xD0\x39\x77\x67\x42" "\x59\xC6\x82\x45\xEB\x05\x28\x2B"
    , KAT_ECB "\x01\x31\xD9\x61\x9D\xC1\x37\x6E" "\x5C\xD5\x4C\xA8\x3D\xEF\x57\xDA" "\xB1\xB8\xCC\x0B\x25\x0F\x09\xA0"
    , KAT_ECB "\x07\xA1\x13\x3E\x4A\x0B\x26\x86" "\x02\x48\xD4\x38\x06\xF6\x71\x72" "\x17\x30\xE5\x77\x8B\xEA\x1D\xA4"
    , KAT_ECB "\x38\x49\x67\x4C\x26\x02\x31\x9E" "\x51\x45\x4B\x58\x2D\xDF\x44\x0A" "\xA2\x5E\x78\x56\xCF\x26\x51\xEB"
    , KAT_ECB "\x04\xB9\x15\xBA\x43\xFE\xB5\xB6" "\x42\xFD\x44\x30\x59\x57\x7F\xA2" "\x35\x38\x82\xB1\x09\xCE\x8F\x1A"
    , KAT_ECB "\x01\x13\xB9\x70\xFD\x34\xF2\xCE" "\x05\x9B\x5E\x08\x51\xCF\x14\x3A" "\x48\xF4\xD0\x88\x4C\x37\x99\x18"
    , KAT_ECB "\x01\x70\xF1\x75\x46\x8F\xB5\xE6" "\x07\x56\xD8\xE0\x77\x47\x61\xD2" "\x43\x21\x93\xB7\x89\x51\xFC\x98"
    , KAT_ECB "\x43\x29\x7F\xAD\x38\xE3\x73\xFE" "\x76\x25\x14\xB8\x29\xBF\x48\x6A" "\x13\xF0\x41\x54\xD6\x9D\x1A\xE5"
    , KAT_ECB "\x07\xA7\x13\x70\x45\xDA\x2A\x16" "\x3B\xDD\x11\x90\x49\x37\x28\x02" "\x2E\xED\xDA\x93\xFF\xD3\x9C\x79"
    , KAT_ECB "\x04\x68\x91\x04\xC2\xFD\x3B\x2F" "\x26\x95\x5F\x68\x35\xAF\x60\x9A" "\xD8\x87\xE0\x39\x3C\x2D\xA6\xE3"
    , KAT_ECB "\x37\xD0\x6B\xB5\x16\xCB\x75\x46" "\x16\x4D\x5E\x40\x4F\x27\x52\x32" "\x5F\x99\xD0\x4F\x5B\x16\x39\x69"
    , KAT_ECB "\x1F\x08\x26\x0D\x1A\xC2\x46\x5E" "\x6B\x05\x6E\x18\x75\x9F\x5C\xCA" "\x4A\x05\x7A\x3B\x24\xD3\x97\x7B"
    , KAT_ECB "\x58\x40\x23\x64\x1A\xBA\x61\x76" "\x00\x4B\xD6\xEF\x09\x17\x60\x62" "\x45\x20\x31\xC1\xE4\xFA\xDA\x8E"
    , KAT_ECB "\x02\x58\x16\x16\x46\x29\xB0\x07" "\x48\x0D\x39\x00\x6E\xE7\x62\xF2" "\x75\x55\xAE\x39\xF5\x9B\x87\xBD"
    , KAT_ECB "\x49\x79\x3E\xBC\x79\xB3\x25\x8F" "\x43\x75\x40\xC8\x69\x8F\x3C\xFA" "\x53\xC5\x5F\x9C\xB4\x9F\xC0\x19"
    , KAT_ECB "\x4F\xB0\x5E\x15\x15\xAB\x73\xA7" "\x07\x2D\x43\xA0\x77\x07\x52\x92" "\x7A\x8E\x7B\xFA\x93\x7E\x89\xA3"
    , KAT_ECB "\x49\xE9\x5D\x6D\x4C\xA2\x29\xBF" "\x02\xFE\x55\x77\x81\x17\xF1\x2A" "\xCF\x9C\x5D\x7A\x49\x86\xAD\xB5"
    , KAT_ECB "\x01\x83\x10\xDC\x40\x9B\x26\xD6" "\x1D\x9D\x5C\x50\x18\xF7\x28\xC2" "\xD1\xAB\xB2\x90\x65\x8B\xC7\x78"
    , KAT_ECB "\x1C\x58\x7F\x1C\x13\x92\x4F\xEF" "\x30\x55\x32\x28\x6D\x6F\x29\x5A" "\x55\xCB\x37\x74\xD1\x3E\xF2\x01"
    , KAT_ECB "\x01\x01\x01\x01\x01\x01\x01\x01" "\x01\x23\x45\x67\x89\xAB\xCD\xEF" "\xFA\x34\xEC\x48\x47\xB2\x68\xB2"
    , KAT_ECB "\x1F\x1F\x1F\x1F\x0E\x0E\x0E\x0E" "\x01\x23\x45\x67\x89\xAB\xCD\xEF" "\xA7\x90\x79\x51\x08\xEA\x3C\xAE"
    , KAT_ECB "\xE0\xFE\xE0\xFE\xF1\xFE\xF1\xFE" "\x01\x23\x45\x67\x89\xAB\xCD\xEF" "\xC3\x9E\x07\x2D\x9F\xAC\x63\x1D"
    , KAT_ECB "\x00\x00\x00\x00\x00\x00\x00\x00" "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" "\x01\x49\x33\xE0\xCD\xAF\xF6\xE4"
    , KAT_ECB "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" "\x00\x00\x00\x00\x00\x00\x00\x00" "\xF2\x1E\x9A\x77\xB7\x1C\x49\xBC"
    , KAT_ECB "\x01\x23\x45\x67\x89\xAB\xCD\xEF" "\x00\x00\x00\x00\x00\x00\x00\x00" "\x24\x59\x46\x88\x57\x54\x36\x9A"
    , KAT_ECB "\xFE\xDC\xBA\x98\x76\x54\x32\x10" "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" "\x6B\x5C\x5A\x9C\x5D\x9E\x0A\x5A"
    ]

kats = defaultKATs { kat_ECB = vectors_ecb }

main = defaultMain
    [ testBlockCipher kats (undefined :: Blowfish64)
    ]
