% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setTCPNoDelay.R
\name{setTCPNoDelay}
\alias{setTCPNoDelay}
\title{Modify the TCP_NODELAY (`de-Nagle') flag for socket objects}
\usage{
setTCPNoDelay(socket, value = TRUE)
}
\arguments{
\item{socket}{A socket connection object}

\item{value}{Logical indicating whether to set (\code{TRUE}) or unset
(\code{FALSE}) the flag}
}
\value{
The character string "SUCCESS" will be returned invisible if the
operation was successful.  On failure, an error will be generated.
}
\description{
Modify the TCP_NODELAY (`de-Nagle') flag for socket objects
}
\details{
By default, TCP connections wait a small fixed interval before actually
sending data, in order to permit small packets to be combined.  This
algorithm is named after its inventor, John Nagle, and is often referred to
as 'Nagling'.

While this reduces network resource utilization in these situations, it
imposes a delay on all outgoing message data, which can cause problems in
client/server situations.

This function allows this feature to be disabled (de-Nagling,
\code{value=TRUE}) or enabled (Nagling, \code{value=FALSE}) for the
specified socket.
}
\examples{
\dontrun{
host <- "www.r-project.org"
socket <- make.socket(host, 80)
print(socket)
setTCPNoDelay(socket, TRUE)

write.socket(socket, "GET /\n\n")
write.socket(socket, "A")
write.socket(socket, "B\n")
while ((str <- read.socket(socket)) > "") {
  cat(str)
}
close.socket(socket)
}

}
\references{
"Nagle's algorithm" \url{https://en.wikipedia.org/wiki/Nagle's_algorithm},

  Nagle, John. "Congestion Control in IP/TCP Internetworks", IETF Request for
  Comments 896, January 1984. \url{https://www.ietf.org/rfc/rfc0896.txt?number=896}
}
\seealso{
\code{\link{make.socket}}, \code{\link{socketConnection}}
}
\author{
Gregory R. Warnes \email{greg@warnes.net}
}
\keyword{misc}
\keyword{programming}
\keyword{utilities}
