/***************************************************************************
                          check_pocket.cpp  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "check_pocket.h"

check_pocket::check_pocket(GdkRectangle table, double ei){
	cue = eight = false;
	left = table.x + 20;
	right = (table.width + table.x) - 20;
	top = table.y + 20;
	bottom = table.height + table.y - 20;
	left_of_mid = table.x + table.width / 2 - 15;
	right_of_mid = left_of_mid + 30;
	time = ei;
}
check_pocket::~check_pocket(){
}
bool check_pocket::operator() (Ball &b){
	if(b.hCol == time)
	{
		double c = b.y + b.vel.dy * b.hCol;
		if(c < top || c > bottom)
		{
			ball_num = b.ball_num;
			cue = b.is_cue; eight = b.is_eight; nine = b.is_nine;
			solid = b.is_solid; stripe = b.is_stripe;
			category = b.category;
			return true;
		}
	}
	else
	{
		double c = b.x + b.vel.dx * b.vCol;
		if(c < left || c > right || (c > left_of_mid && c < right_of_mid))
		{
			ball_num = b.ball_num;
			cue = b.is_cue; eight = b.is_eight; nine = b.is_nine;
			solid = b.is_solid; stripe = b.is_stripe;
			category = b.category;
			return true;
		}
	}
	return false;
}
