/*___INFO__MARK_BEGIN__*/
/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  the Sun Industry Standards Source License Version 1.2
 *
 *  Sun Microsystems Inc., March, 2001
 *
 *
 *  Sun Industry Standards Source License Version 1.2
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.2 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://gridengine.sunsource.net/Gridengine_SISSL_license.html
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *   Copyright: 2001 by Sun Microsystems, Inc.
 *
 *   All Rights Reserved.
 *
 ************************************************************************/
/*___INFO__MARK_END__*/
/**
 *  Generated from java_event_client.jsp
 *  !!! DO NOT EDIT THIS FILE !!!
 */
<%
  com.sun.grid.cull.JavaHelper jh = (com.sun.grid.cull.JavaHelper)params.get("javaHelper");
  com.sun.grid.cull.CullDefinition cullDef = (com.sun.grid.cull.CullDefinition)params.get("cullDef");
%>
package com.sun.grid.jgdi.management;

import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import com.sun.grid.jgdi.EventClient;
import com.sun.grid.jgdi.event.Event;
import java.util.*;
import java.util.logging.Logger;
import java.util.logging.Level;
/** 
 *  Helper class for mapping JGDI Events to JMX notifications
 *
 */
public class NotificationBridgeFactory {

    private static final Logger log = Logger.getLogger(NotificationBridgeFactory.class.getName());
    private static final Map<Class, EventToNotification> eventMap = new HashMap<Class, EventToNotification>();

    private static class EventToNotification {

        private final String eventName;
        private final Class eventClass;
        private final MBeanNotificationInfo notificationInfo;

        public EventToNotification(String eventName, Class eventClass) {
            this.eventName = eventName;
            this.eventClass = eventClass;
            this.notificationInfo = new MBeanNotificationInfo(new String[]{eventName}, eventClass.getName(), null);
        }

        public MBeanNotificationInfo getNotificationInfo() {
            return notificationInfo;
        }

        public Notification createNotification(Event event, long seqNumber) {
            Notification notification = new Notification(eventName, EventClient.class.getName(), seqNumber);
            notification.setUserData(event);
            return notification;
        }
    }

    public static Notification createNotification(Event evt, long seqNumber) {
        EventToNotification bridge = eventMap.get(evt.getClass());
        if (bridge != null) {
            log.log(Level.FINE, "create notification for event {0}", evt);
            return bridge.createNotification(evt, seqNumber);
        } else {
            return null;
        }
    }
    
    public static NotificationBridge newInstance(String url) {    
        return new NotificationBridge(url);
    }
    
    private static void registerEvent(String eventName, Class eventClass) {
        if (log.isLoggable(Level.FINER)) {
            log.entering("NotificationBridgeFactory", "registerEvent", new Object[]{eventName, eventClass});
        }
        EventToNotification evtNot = new EventToNotification(eventName, eventClass);
        eventMap.put(eventClass, evtNot);
        log.exiting("NotificationBridgeFactory", "registerEvent");
    }

    public static MBeanNotificationInfo[] createMBeanNotificationInfo() {
        log.entering("NotificationBridgeFactory", "createMBeanNotificationInfo");
        MBeanNotificationInfo [] ret = new MBeanNotificationInfo[eventMap.size()];
        int i = 0;
        for (Map.Entry<Class, EventToNotification> entry : eventMap.entrySet()) {
            ret[i++] = entry.getValue().getNotificationInfo();
        }
        log.exiting("NotificationBridgeFactory", "createMBeanNotificationInfo", ret);
        return ret;
    }
    
    
    static {
<%
    com.sun.grid.cull.CullObject cullObj = null;    
    for (String name : cullDef.getObjectNames()) {
      cullObj = cullDef.getCullObject(name); 
      name = cullObj.getIdlName();
//      System.out.println("name = " + name + ", cullname = " + cullObj.getName() + " " + 
//                         (cullObj.hasAddEvent() ? "A" : "") + 
//                         (cullObj.hasDeleteEvent() ? "D" : "") +
//                         (cullObj.hasGetListEvent() ? "L" : "") +
//                         (cullObj.hasGetEvent() ? "G" : "") +
//                         (cullObj.hasModifyEvent() ? "M" : ""));
      if(name == null) {
         throw new IllegalStateException("Have no idl name for " + cullObj.getName());
      }
      String notifType = null;
      String classname = null;
      if(cullObj.hasAddEvent()) {
%>
      registerEvent("Add<%=name%>", com.sun.grid.jgdi.event.<%=cullObj.getIdlName()%>AddEvent.class);
<%    } 
      
      if(cullObj.hasDeleteEvent()) {
%>
      registerEvent("Del<%=name%>", com.sun.grid.jgdi.event.<%=cullObj.getIdlName()%>DelEvent.class);
<%
      }
      if(cullObj.hasModifyEvent()) {
%>
      registerEvent("Mod<%=name%>", com.sun.grid.jgdi.event.<%=cullObj.getIdlName()%>ModEvent.class);
<%
      }
      if(cullObj.hasGetListEvent()) {
%>
      registerEvent("List<%=name%>", com.sun.grid.jgdi.event.<%=cullObj.getIdlName()%>ListEvent.class);
<%
      }
   } // end of for

   String [] specialEvents = {
       "QmasterGoesDown",
       "SchedulerRun",
       "Shutdown",
       "JobFinish",
       "JobUsage",
       "JobFinalUsage",
       "JobPriorityMod",
       "QueueInstanceSuspend",
       "QueueInstanceUnsuspend",
       "ConnectionClosed"
   };
   
   for (int i = 0; i < specialEvents.length; i++) {

%>
      registerEvent("<%=specialEvents[i]%>", com.sun.grid.jgdi.event.<%=specialEvents[i]%>Event.class);
<%
   } // end of for special events
%>
   }
}
