# gozerbot/utils/reboot.py
#
#

"""
     reboot code. 

"""

## IMPORT SECTION

from gozerbot.fleet import fleet
from gozerbot.config import config

from simplejson import dump

import os, sys, pickle, tempfile

## END IMPORT 

## LOCK SECTION

# no locks

## END LOCK

def reboot():

    """
        reboot the bot.

        .. literalinclude:: ../../gozerbot/reboot.py
            :pyobject: reboot

    """

    fleet.exit()
    os.execl(sys.argv[0], *sys.argv)

def reboot_stateful(bot, ievent, fleet, partyline):
    """
        reboot the bot, but keep the connections.

        :param bot: bot on which the reboot command is given
        :type bot: gozerbot.botbase.BotBase	
        :param ievent: event that triggered the reboot
        :type ievent: gozerbot.eventbase. EventBase
        :param fleet: the fleet of the bot
        :type fleet: gozerbot.fleet.Fleet
        :param partyline: partyline of the bot
        :type partyline: gozerbot.partyline.PartyLine

        .. literalinclude:: ../../gozerbot/reboot.py
            :pyobject: reboot_stateful

    """
    config.reload()
    session = {'bots': {}, 'name': bot.name, 'channel': ievent.channel, 'partyline': []}

    for i in fleet.bots:
        session['bots'].update(i._resumedata())

    session['partyline'] = partyline._resumedata()
    sessionfile = tempfile.mkstemp('-session', 'gozerbot-')[1]
    dump(session, open(sessionfile, 'w'))
    fleet.save()
    fleet.exit(jabber=True)
    os.execl(sys.argv[0], sys.argv[0], '-r', sessionfile)

## INIT SECTION

# no vars

## END INIT
