# gozerbot/database/googledb.py
#
#

""" alchemy interface. rewritten to use BigTable"""

__copyright__ = 'this file is in the public domain'

## IMPORT SECTION

# gozerbot imports
from gozerbot.stats import stats
from gozerbot.datadir import datadir
from gozerbot.config import config
from gozerbot.utils.locking import lockdec, funclocked, Locked
from gozerbot.utils.log import rlog
from gozerbot.utils.exception import handle_exception

# google imports
from google.appengine.ext import db

# basic imports
import os, time, logging

## END IMPORT

### MODEL

class GozerUser(db.Expando):

    name = db.StringProperty(required=True)
    email = db.StringProperty()
    userhosts = db.StringListProperty(required=True)
    perms = db.StringListProperty()
    permits = db.StringListProperty()
    statuses = db.StringListProperty()
    password = db.StringProperty()

class GozerUserhost(db.Expando):

    name = db.StringProperty(required=True)
    userhost = db.StringProperty(required=True)

### END MODEL

def query(q):

    """ do a query on the database. """

    res = None
    stats.up('alchemy', 'query')
    res = db.GqlQuery(q).all().fetch(1000)
    return res

def getuser(userhost):

    """ get a user based on userhost. """
    
    uh = GozerUserhost.all().filter('userhost =', userhost).get()
    if not uh:
        rlog(10, 'db', 'no userhost found for %s' % userhost)
        return
    user = db.GqlQuery("SELECT * FROM GozerUser WHERE name = :1", uh.name).get()
    if user:
        return user
    else:
        rlog(10, 'db', 'no user found for %s' % uh.name)

def byname(name):

    """ get a users based on name. """
    user = db.GqlQuery("SELECT * FROM GozerUser WHERE name = :1", name).get()
    return user
