// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/rethinkdb/rethinkdb-go.v6"
	"gopkg.in/rethinkdb/rethinkdb-go.v6/internal/compare"
)

// Tests r.default
func TestDefaultSuite(t *testing.T) {
	suite.Run(t, new(DefaultSuite))
}

type DefaultSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *DefaultSuite) SetupTest() {
	suite.T().Log("Setting up DefaultSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("db_def").Exec(suite.session)
	err = r.DBCreate("db_def").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("db_def").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *DefaultSuite) TearDownSuite() {
	suite.T().Log("Tearing down DefaultSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("db_def").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *DefaultSuite) TestCases() {
	suite.T().Log("Running DefaultSuite: Tests r.default")

	{
		// default.yaml line #3
		/* 1 */
		var expected_ int = 1
		/* r.expr(1).default(2) */

		suite.T().Log("About to run line #3: r.Expr(1).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #3")
	}

	{
		// default.yaml line #5
		/* 2 */
		var expected_ int = 2
		/* r.expr(null).default(2) */

		suite.T().Log("About to run line #5: r.Expr(nil).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #5")
	}

	{
		// default.yaml line #7
		/* 2 */
		var expected_ int = 2
		/* r.expr({})['b'].default(2) */

		suite.T().Log("About to run line #7: r.Expr(map[interface{}]interface{}{}).AtIndex('b').Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{}).AtIndex("b").Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #7")
	}

	{
		// default.yaml line #10
		/* err("ReqlQueryLogicError", "Cannot perform bracket on a non-object non-sequence `\"a\"`.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot perform bracket on a non-object non-sequence `\"a\"`.")
		/* r.expr(r.expr('a')['b']).default(2) */

		suite.T().Log("About to run line #10: r.Expr(r.Expr('a').AtIndex('b')).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(r.Expr("a").AtIndex("b")).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #10")
	}

	{
		// default.yaml line #14
		/* 2 */
		var expected_ int = 2
		/* r.expr([]).reduce(lambda a,b:a+b).default(2) */

		suite.T().Log("About to run line #14: r.Expr([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)}).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #14")
	}

	{
		// default.yaml line #18
		/* 2 */
		var expected_ int = 2
		/* r.expr([]).union([]).reduce(lambda a,b:a+b).default(2) */

		suite.T().Log("About to run line #18: r.Expr([]interface{}{}).Union([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)}).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Union([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// default.yaml line #22
		/* err("ReqlQueryLogicError", "Cannot convert STRING to SEQUENCE", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot convert STRING to SEQUENCE")
		/* r.expr('a').reduce(lambda a,b:a+b).default(2) */

		suite.T().Log("About to run line #22: r.Expr('a').Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)}).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr("a").Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #22")
	}

	{
		// default.yaml line #25
		/* 2 */
		var expected_ int = 2
		/* (r.expr(null) + 5).default(2) */

		suite.T().Log("About to run line #25: r.Expr(nil).Add(5).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Add(5).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #25")
	}

	{
		// default.yaml line #28
		/* 2 */
		var expected_ int = 2
		/* (5 + r.expr(null)).default(2) */

		suite.T().Log("About to run line #28: r.Add(5, r.Expr(nil)).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Add(5, r.Expr(nil)).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #28")
	}

	{
		// default.yaml line #31
		/* 2 */
		var expected_ int = 2
		/* (5 - r.expr(null)).default(2) */

		suite.T().Log("About to run line #31: r.Sub(5, r.Expr(nil)).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Sub(5, r.Expr(nil)).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #31")
	}

	{
		// default.yaml line #34
		/* 2 */
		var expected_ int = 2
		/* (r.expr(null) - 5).default(2) */

		suite.T().Log("About to run line #34: r.Expr(nil).Sub(5).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Sub(5).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #34")
	}

	{
		// default.yaml line #37
		/* err("ReqlQueryLogicError", "Expected type STRING but found NUMBER.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type STRING but found NUMBER.")
		/* (r.expr('a') + 5).default(2) */

		suite.T().Log("About to run line #37: r.Expr('a').Add(5).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr("a").Add(5).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #37")
	}

	{
		// default.yaml line #40
		/* err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* (5 + r.expr('a')).default(2) */

		suite.T().Log("About to run line #40: r.Add(5, r.Expr('a')).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Add(5, r.Expr("a")).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #40")
	}

	{
		// default.yaml line #43
		/* err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* (r.expr('a') - 5).default(2) */

		suite.T().Log("About to run line #43: r.Expr('a').Sub(5).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Expr("a").Sub(5).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #43")
	}

	{
		// default.yaml line #46
		/* err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* (5 - r.expr('a')).default(2) */

		suite.T().Log("About to run line #46: r.Sub(5, r.Expr('a')).Default(2)")

		runAndAssert(suite.Suite, expected_, r.Sub(5, r.Expr("a")).Default(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #46")
	}

	{
		// default.yaml line #50
		/* 1 */
		var expected_ int = 1
		/* r.expr(1).default(r.error()) */

		suite.T().Log("About to run line #50: r.Expr(1).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #50")
	}

	{
		// default.yaml line #52
		/* (null) */
		var expected_ interface{} = nil
		/* r.expr(null).default(r.error()) */

		suite.T().Log("About to run line #52: r.Expr(nil).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #52")
	}

	{
		// default.yaml line #54
		/* err("ReqlNonExistenceError", "No attribute `b` in object:", []) */
		var expected_ Err = err("ReqlNonExistenceError", "No attribute `b` in object:")
		/* r.expr({})['b'].default(r.error()) */

		suite.T().Log("About to run line #54: r.Expr(map[interface{}]interface{}{}).AtIndex('b').Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{}).AtIndex("b").Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #54")
	}

	{
		// default.yaml line #58
		/* err("ReqlNonExistenceError", "Cannot reduce over an empty stream.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Cannot reduce over an empty stream.")
		/* r.expr([]).reduce(lambda a,b:a+b).default(r.error) */

		suite.T().Log("About to run line #58: r.Expr([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)}).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #58")
	}

	{
		// default.yaml line #62
		/* err("ReqlNonExistenceError", "Cannot reduce over an empty stream.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Cannot reduce over an empty stream.")
		/* r.expr([]).union([]).reduce(lambda a,b:a+b).default(r.error) */

		suite.T().Log("About to run line #62: r.Expr([]interface{}{}).Union([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)}).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Union([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #62")
	}

	{
		// default.yaml line #65
		/* err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.")
		/* (r.expr(null) + 5).default(r.error) */

		suite.T().Log("About to run line #65: r.Expr(nil).Add(5).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Add(5).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #65")
	}

	{
		// default.yaml line #68
		/* err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.")
		/* (5 + r.expr(null)).default(r.error) */

		suite.T().Log("About to run line #68: r.Add(5, r.Expr(nil)).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Add(5, r.Expr(nil)).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #68")
	}

	{
		// default.yaml line #71
		/* err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.")
		/* (5 - r.expr(null)).default(r.error) */

		suite.T().Log("About to run line #71: r.Sub(5, r.Expr(nil)).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Sub(5, r.Expr(nil)).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #71")
	}

	{
		// default.yaml line #74
		/* err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.", []) */
		var expected_ Err = err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.")
		/* (r.expr(null) - 5).default(r.error) */

		suite.T().Log("About to run line #74: r.Expr(nil).Sub(5).Default(r.Error())")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Sub(5).Default(r.Error()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #74")
	}

	{
		// default.yaml line #79
		/* 1 */
		var expected_ int = 1
		/* r.expr(1).default(lambda e:e) */

		suite.T().Log("About to run line #79: r.Expr(1).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #79")
	}

	{
		// default.yaml line #83
		/* (null) */
		var expected_ interface{} = nil
		/* r.expr(null).default(lambda e:e) */

		suite.T().Log("About to run line #83: r.Expr(nil).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #83")
	}

	{
		// default.yaml line #87
		/* "No attribute `b` in object:\n{}" */
		var expected_ string = "No attribute `b` in object:\n{}"
		/* r.expr({})['b'].default(lambda e:e) */

		suite.T().Log("About to run line #87: r.Expr(map[interface{}]interface{}{}).AtIndex('b').Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{}).AtIndex("b").Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #87")
	}

	{
		// default.yaml line #91
		/* ("Cannot reduce over an empty stream.") */
		var expected_ string = "Cannot reduce over an empty stream."
		/* r.expr([]).reduce(lambda a,b:a+b).default(lambda e:e) */

		suite.T().Log("About to run line #91: r.Expr([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)}).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #91")
	}

	{
		// default.yaml line #95
		/* ("Cannot reduce over an empty stream.") */
		var expected_ string = "Cannot reduce over an empty stream."
		/* r.expr([]).union([]).reduce(lambda a,b:a+b).default(lambda e:e) */

		suite.T().Log("About to run line #95: r.Expr([]interface{}{}).Union([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)}).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Union([]interface{}{}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #95")
	}

	{
		// default.yaml line #99
		/* ("Expected type NUMBER but found NULL.") */
		var expected_ string = "Expected type NUMBER but found NULL."
		/* (r.expr(null) + 5).default(lambda e:e) */

		suite.T().Log("About to run line #99: r.Expr(nil).Add(5).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Add(5).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #99")
	}

	{
		// default.yaml line #103
		/* ("Expected type NUMBER but found NULL.") */
		var expected_ string = "Expected type NUMBER but found NULL."
		/* (5 + r.expr(null)).default(lambda e:e) */

		suite.T().Log("About to run line #103: r.Add(5, r.Expr(nil)).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Add(5, r.Expr(nil)).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #103")
	}

	{
		// default.yaml line #107
		/* ("Expected type NUMBER but found NULL.") */
		var expected_ string = "Expected type NUMBER but found NULL."
		/* (5 - r.expr(null)).default(lambda e:e) */

		suite.T().Log("About to run line #107: r.Sub(5, r.Expr(nil)).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Sub(5, r.Expr(nil)).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #107")
	}

	{
		// default.yaml line #111
		/* ("Expected type NUMBER but found NULL.") */
		var expected_ string = "Expected type NUMBER but found NULL."
		/* (r.expr(null) - 5).default(lambda e:e) */

		suite.T().Log("About to run line #111: r.Expr(nil).Sub(5).Default(func(e r.Term) interface{} { return e})")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Sub(5).Default(func(e r.Term) interface{} { return e }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #111")
	}

	// default.yaml line #115
	// arr = r.expr([{'a':1},{'a':null},{}]).order_by('a')
	suite.T().Log("Possibly executing: var arr r.Term = r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, }, map[interface{}]interface{}{'a': nil, }, map[interface{}]interface{}{}}).OrderBy('a')")

	arr := r.Expr([]interface{}{map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"a": nil}, map[interface{}]interface{}{}}).OrderBy("a")
	_ = arr // Prevent any noused variable errors

	{
		// default.yaml line #118
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].eq(1)) */

		suite.T().Log("About to run line #118: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)})")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #118")
	}

	{
		// default.yaml line #122
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].eq(1), default=False) */

		suite.T().Log("About to run line #122: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: false, })")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: false}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #122")
	}

	{
		// default.yaml line #126
		/* [{}, {'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].eq(1), default=True) */

		suite.T().Log("About to run line #126: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: true, })")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #126")
	}

	{
		// default.yaml line #131
		/* [{}, {'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].eq(1), default=r.js('true')) */

		suite.T().Log("About to run line #131: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: r.JS('true'), })")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: r.JS("true")}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #131")
	}

	{
		// default.yaml line #135
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].eq(1), default=r.js('false')) */

		suite.T().Log("About to run line #135: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: r.JS('false'), })")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: r.JS("false")}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #135")
	}

	{
		// default.yaml line #139
		/* err("ReqlNonExistenceError", "No attribute `a` in object:", []) */
		var expected_ Err = err("ReqlNonExistenceError", "No attribute `a` in object:")
		/* arr.filter(lambda x:x['a'].eq(1), default=r.error()) */

		suite.T().Log("About to run line #139: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: r.Error(), })")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: r.Error()}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #139")
	}

	{
		// default.yaml line #144
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* r.expr(False).do(lambda d:arr.filter(lambda x:x['a'].eq(1), default=d)) */

		suite.T().Log("About to run line #144: r.Expr(false).Do(func(d r.Term) interface{} { return arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: d, })})")

		runAndAssert(suite.Suite, expected_, r.Expr(false).Do(func(d r.Term) interface{} {
			return arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: d})
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #144")
	}

	{
		// default.yaml line #148
		/* [{}, {'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": 1}}
		/* r.expr(True).do(lambda d:arr.filter(lambda x:x['a'].eq(1), default=d)).order_by('a') */

		suite.T().Log("About to run line #148: r.Expr(true).Do(func(d r.Term) interface{} { return arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: d, })}).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, r.Expr(true).Do(func(d r.Term) interface{} {
			return arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: d})
		}).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #148")
	}

	{
		// default.yaml line #154
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].default(0).eq(1)) */

		suite.T().Log("About to run line #154: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(0).Eq(1)})")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(0).Eq(1) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #154")
	}

	{
		// default.yaml line #158
		/* ([{}, {'a':null}, {'a':1}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": nil}, map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].default(1).eq(1)).order_by('a') */

		suite.T().Log("About to run line #158: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(1).Eq(1)}).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(1).Eq(1) }).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #158")
	}

	{
		// default.yaml line #162
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:x['a'].default(r.error()).eq(1)) */

		suite.T().Log("About to run line #162: arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(r.Error()).Eq(1)})")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(r.Error()).Eq(1) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #162")
	}

	{
		// default.yaml line #168
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* r.expr(0).do(lambda i:arr.filter(lambda x:x['a'].default(i).eq(1))) */

		suite.T().Log("About to run line #168: r.Expr(0).Do(func(i r.Term) interface{} { return arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(i).Eq(1)})})")

		runAndAssert(suite.Suite, expected_, r.Expr(0).Do(func(i r.Term) interface{} {
			return arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(i).Eq(1) })
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #168")
	}

	{
		// default.yaml line #172
		/* ([{},{'a':null},{'a':1}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": nil}, map[interface{}]interface{}{"a": 1}}
		/* r.expr(1).do(lambda i:arr.filter(lambda x:x['a'].default(i).eq(1))).order_by('a') */

		suite.T().Log("About to run line #172: r.Expr(1).Do(func(i r.Term) interface{} { return arr.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(i).Eq(1)})}).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Do(func(i r.Term) interface{} {
			return arr.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(i).Eq(1) })
		}).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #172")
	}

	{
		// default.yaml line #177
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2))) */

		suite.T().Log("About to run line #177: arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))})")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #177")
	}

	{
		// default.yaml line #181
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2)), default=False) */

		suite.T().Log("About to run line #181: arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))}).OptArgs(r.FilterOpts{Default: false, })")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }).OptArgs(r.FilterOpts{Default: false}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #181")
	}

	{
		// default.yaml line #185
		/* ([{}, {'a':null}, {'a':1}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": nil}, map[interface{}]interface{}{"a": 1}}
		/* arr.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2)), default=True).order_by('a') */

		suite.T().Log("About to run line #185: arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))}).OptArgs(r.FilterOpts{Default: true, }).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }).OptArgs(r.FilterOpts{Default: true}).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #185")
	}

	{
		// default.yaml line #189
		/* err("ReqlNonExistenceError", "No attribute `a` in object:", []) */
		var expected_ Err = err("ReqlNonExistenceError", "No attribute `a` in object:")
		/* arr.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2)), default=r.error()) */

		suite.T().Log("About to run line #189: arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))}).OptArgs(r.FilterOpts{Default: r.Error(), })")

		runAndAssert(suite.Suite, expected_, arr.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }).OptArgs(r.FilterOpts{Default: r.Error()}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #189")
	}

	{
		// default.yaml line #193
		/* partial({'tables_created':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_created": 1})
		/* r.table_create('default_test') */

		suite.T().Log("About to run line #193: r.TableCreate('default_test')")

		runAndAssert(suite.Suite, expected_, r.TableCreate("default_test"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #193")
	}

	{
		// default.yaml line #196
		/* ({'deleted':0,'replaced':0,'generated_keys':arrlen(3,uuid()),'unchanged':0,'errors':0,'skipped':0,'inserted':3}) */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0, "replaced": 0, "generated_keys": arrlen(3, compare.IsUUID()), "unchanged": 0, "errors": 0, "skipped": 0, "inserted": 3}
		/* r.table('default_test').insert(arr) */

		suite.T().Log("About to run line #196: r.Table('default_test').Insert(arr)")

		runAndAssert(suite.Suite, expected_, r.Table("default_test").Insert(arr), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #196")
	}

	// default.yaml line #199
	// tbl = r.table('default_test').order_by('a').pluck('a')
	suite.T().Log("Possibly executing: var tbl r.Term = r.Table('default_test').OrderBy('a').Pluck('a')")

	tbl := r.Table("default_test").OrderBy("a").Pluck("a")
	_ = tbl // Prevent any noused variable errors

	{
		// default.yaml line #202
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:x['a'].eq(1)) */

		suite.T().Log("About to run line #202: tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)})")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #202")
	}

	{
		// default.yaml line #206
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:x['a'].eq(1), default=False) */

		suite.T().Log("About to run line #206: tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: false, })")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: false}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #206")
	}

	{
		// default.yaml line #210
		/* [{}, {'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:x['a'].eq(1), default=True) */

		suite.T().Log("About to run line #210: tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: true, })")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: true}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #210")
	}

	{
		// default.yaml line #215
		/* err("ReqlNonExistenceError", "No attribute `a` in object:", []) */
		var expected_ Err = err("ReqlNonExistenceError", "No attribute `a` in object:")
		/* tbl.filter(lambda x:x['a'].eq(1), default=r.error()) */

		suite.T().Log("About to run line #215: tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: r.Error(), })")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: r.Error()}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #215")
	}

	{
		// default.yaml line #220
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* r.expr(False).do(lambda d:tbl.filter(lambda x:x['a'].eq(1), default=d)) */

		suite.T().Log("About to run line #220: r.Expr(false).Do(func(d r.Term) interface{} { return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: d, })})")

		runAndAssert(suite.Suite, expected_, r.Expr(false).Do(func(d r.Term) interface{} {
			return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: d})
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #220")
	}

	{
		// default.yaml line #224
		/* [{}, {'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": 1}}
		/* r.expr(True).do(lambda d:tbl.filter(lambda x:x['a'].eq(1), default=d)).order_by('a') */

		suite.T().Log("About to run line #224: r.Expr(true).Do(func(d r.Term) interface{} { return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Eq(1)}).OptArgs(r.FilterOpts{Default: d, })}).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, r.Expr(true).Do(func(d r.Term) interface{} {
			return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Eq(1) }).OptArgs(r.FilterOpts{Default: d})
		}).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #224")
	}

	{
		// default.yaml line #230
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:x['a'].default(0).eq(1)) */

		suite.T().Log("About to run line #230: tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(0).Eq(1)})")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(0).Eq(1) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #230")
	}

	{
		// default.yaml line #234
		/* ([{}, {'a':null}, {'a':1}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": nil}, map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:x['a'].default(1).eq(1)).order_by('a') */

		suite.T().Log("About to run line #234: tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(1).Eq(1)}).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(1).Eq(1) }).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #234")
	}

	{
		// default.yaml line #238
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:x['a'].default(r.error()).eq(1)) */

		suite.T().Log("About to run line #238: tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(r.Error()).Eq(1)})")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(r.Error()).Eq(1) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #238")
	}

	{
		// default.yaml line #244
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* r.expr(0).do(lambda i:tbl.filter(lambda x:x['a'].default(i).eq(1))) */

		suite.T().Log("About to run line #244: r.Expr(0).Do(func(i r.Term) interface{} { return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(i).Eq(1)})})")

		runAndAssert(suite.Suite, expected_, r.Expr(0).Do(func(i r.Term) interface{} {
			return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(i).Eq(1) })
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #244")
	}

	{
		// default.yaml line #248
		/* ([{},{'a':null},{'a':1}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": nil}, map[interface{}]interface{}{"a": 1}}
		/* r.expr(1).do(lambda i:tbl.filter(lambda x:x['a'].default(i).eq(1))).order_by('a') */

		suite.T().Log("About to run line #248: r.Expr(1).Do(func(i r.Term) interface{} { return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex('a').Default(i).Eq(1)})}).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Do(func(i r.Term) interface{} {
			return tbl.Filter(func(x r.Term) interface{} { return x.AtIndex("a").Default(i).Eq(1) })
		}).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #248")
	}

	{
		// default.yaml line #253
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2))) */

		suite.T().Log("About to run line #253: tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))})")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #253")
	}

	{
		// default.yaml line #257
		/* [{'a':1}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2)), default=False) */

		suite.T().Log("About to run line #257: tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))}).OptArgs(r.FilterOpts{Default: false, })")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }).OptArgs(r.FilterOpts{Default: false}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #257")
	}

	{
		// default.yaml line #261
		/* ([{}, {'a':null}, {'a':1}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{"a": nil}, map[interface{}]interface{}{"a": 1}}
		/* tbl.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2)), default=True).order_by('a') */

		suite.T().Log("About to run line #261: tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))}).OptArgs(r.FilterOpts{Default: true, }).OrderBy('a')")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }).OptArgs(r.FilterOpts{Default: true}).OrderBy("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #261")
	}

	{
		// default.yaml line #265
		/* err("ReqlNonExistenceError", "No attribute `a` in object:", []) */
		var expected_ Err = err("ReqlNonExistenceError", "No attribute `a` in object:")
		/* tbl.filter(lambda x:r.or_(x['a'].eq(1), x['a']['b'].eq(2)), default=r.error()) */

		suite.T().Log("About to run line #265: tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex('a').Eq(1), x.AtIndex('a').AtIndex('b').Eq(2))}).OptArgs(r.FilterOpts{Default: r.Error(), })")

		runAndAssert(suite.Suite, expected_, tbl.Filter(func(x r.Term) interface{} { return r.Or(x.AtIndex("a").Eq(1), x.AtIndex("a").AtIndex("b").Eq(2)) }).OptArgs(r.FilterOpts{Default: r.Error()}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #265")
	}

	{
		// default.yaml line #269
		/* partial({'tables_dropped':1}) */
		var expected_ compare.Expected = compare.PartialMatch(map[interface{}]interface{}{"tables_dropped": 1})
		/* r.table_drop('default_test') */

		suite.T().Log("About to run line #269: r.TableDrop('default_test')")

		runAndAssert(suite.Suite, expected_, r.TableDrop("default_test"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #269")
	}
}
