// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/v1/datastore.proto

package datastore

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The modes available for commits.
type CommitRequest_Mode int32

const (
	// Unspecified. This value must not be used.
	CommitRequest_MODE_UNSPECIFIED CommitRequest_Mode = 0
	// Transactional: The mutations are either all applied, or none are applied.
	// Learn about transactions
	// [here](https://cloud.google.com/datastore/docs/concepts/transactions).
	CommitRequest_TRANSACTIONAL CommitRequest_Mode = 1
	// Non-transactional: The mutations may not apply as all or none.
	CommitRequest_NON_TRANSACTIONAL CommitRequest_Mode = 2
)

var CommitRequest_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "TRANSACTIONAL",
	2: "NON_TRANSACTIONAL",
}

var CommitRequest_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED":  0,
	"TRANSACTIONAL":     1,
	"NON_TRANSACTIONAL": 2,
}

func (x CommitRequest_Mode) String() string {
	return proto.EnumName(CommitRequest_Mode_name, int32(x))
}

func (CommitRequest_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{8, 0}
}

// The possible values for read consistencies.
type ReadOptions_ReadConsistency int32

const (
	// Unspecified. This value must not be used.
	ReadOptions_READ_CONSISTENCY_UNSPECIFIED ReadOptions_ReadConsistency = 0
	// Strong consistency.
	ReadOptions_STRONG ReadOptions_ReadConsistency = 1
	// Eventual consistency.
	ReadOptions_EVENTUAL ReadOptions_ReadConsistency = 2
)

var ReadOptions_ReadConsistency_name = map[int32]string{
	0: "READ_CONSISTENCY_UNSPECIFIED",
	1: "STRONG",
	2: "EVENTUAL",
}

var ReadOptions_ReadConsistency_value = map[string]int32{
	"READ_CONSISTENCY_UNSPECIFIED": 0,
	"STRONG":                       1,
	"EVENTUAL":                     2,
}

func (x ReadOptions_ReadConsistency) String() string {
	return proto.EnumName(ReadOptions_ReadConsistency_name, int32(x))
}

func (ReadOptions_ReadConsistency) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{16, 0}
}

// The request for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupRequest struct {
	// Required. The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The options for this lookup request.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions,proto3" json:"read_options,omitempty"`
	// Required. Keys of entities to look up.
	Keys                 []*Key   `protobuf:"bytes,3,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LookupRequest) Reset()         { *m = LookupRequest{} }
func (m *LookupRequest) String() string { return proto.CompactTextString(m) }
func (*LookupRequest) ProtoMessage()    {}
func (*LookupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{0}
}

func (m *LookupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupRequest.Unmarshal(m, b)
}
func (m *LookupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupRequest.Marshal(b, m, deterministic)
}
func (m *LookupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupRequest.Merge(m, src)
}
func (m *LookupRequest) XXX_Size() int {
	return xxx_messageInfo_LookupRequest.Size(m)
}
func (m *LookupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupRequest proto.InternalMessageInfo

func (m *LookupRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *LookupRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *LookupRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupResponse struct {
	// Entities found as `ResultType.FULL` entities. The order of results in this
	// field is undefined and has no relation to the order of the keys in the
	// input.
	Found []*EntityResult `protobuf:"bytes,1,rep,name=found,proto3" json:"found,omitempty"`
	// Entities not found as `ResultType.KEY_ONLY` entities. The order of results
	// in this field is undefined and has no relation to the order of the keys
	// in the input.
	Missing []*EntityResult `protobuf:"bytes,2,rep,name=missing,proto3" json:"missing,omitempty"`
	// A list of keys that were not looked up due to resource constraints. The
	// order of results in this field is undefined and has no relation to the
	// order of the keys in the input.
	Deferred             []*Key   `protobuf:"bytes,3,rep,name=deferred,proto3" json:"deferred,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LookupResponse) Reset()         { *m = LookupResponse{} }
func (m *LookupResponse) String() string { return proto.CompactTextString(m) }
func (*LookupResponse) ProtoMessage()    {}
func (*LookupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{1}
}

func (m *LookupResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupResponse.Unmarshal(m, b)
}
func (m *LookupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupResponse.Marshal(b, m, deterministic)
}
func (m *LookupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupResponse.Merge(m, src)
}
func (m *LookupResponse) XXX_Size() int {
	return xxx_messageInfo_LookupResponse.Size(m)
}
func (m *LookupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LookupResponse proto.InternalMessageInfo

func (m *LookupResponse) GetFound() []*EntityResult {
	if m != nil {
		return m.Found
	}
	return nil
}

func (m *LookupResponse) GetMissing() []*EntityResult {
	if m != nil {
		return m.Missing
	}
	return nil
}

func (m *LookupResponse) GetDeferred() []*Key {
	if m != nil {
		return m.Deferred
	}
	return nil
}

// The request for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryRequest struct {
	// Required. The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Entities are partitioned into subsets, identified by a partition ID.
	// Queries are scoped to a single partition.
	// This partition ID is normalized with the standard default context
	// partition ID.
	PartitionId *PartitionId `protobuf:"bytes,2,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// The options for this query.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions,proto3" json:"read_options,omitempty"`
	// The type of query.
	//
	// Types that are valid to be assigned to QueryType:
	//	*RunQueryRequest_Query
	//	*RunQueryRequest_GqlQuery
	QueryType            isRunQueryRequest_QueryType `protobuf_oneof:"query_type"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *RunQueryRequest) Reset()         { *m = RunQueryRequest{} }
func (m *RunQueryRequest) String() string { return proto.CompactTextString(m) }
func (*RunQueryRequest) ProtoMessage()    {}
func (*RunQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{2}
}

func (m *RunQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunQueryRequest.Unmarshal(m, b)
}
func (m *RunQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunQueryRequest.Marshal(b, m, deterministic)
}
func (m *RunQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunQueryRequest.Merge(m, src)
}
func (m *RunQueryRequest) XXX_Size() int {
	return xxx_messageInfo_RunQueryRequest.Size(m)
}
func (m *RunQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunQueryRequest proto.InternalMessageInfo

func (m *RunQueryRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RunQueryRequest) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *RunQueryRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

type isRunQueryRequest_QueryType interface {
	isRunQueryRequest_QueryType()
}

type RunQueryRequest_Query struct {
	Query *Query `protobuf:"bytes,3,opt,name=query,proto3,oneof"`
}

type RunQueryRequest_GqlQuery struct {
	GqlQuery *GqlQuery `protobuf:"bytes,7,opt,name=gql_query,json=gqlQuery,proto3,oneof"`
}

func (*RunQueryRequest_Query) isRunQueryRequest_QueryType() {}

func (*RunQueryRequest_GqlQuery) isRunQueryRequest_QueryType() {}

func (m *RunQueryRequest) GetQueryType() isRunQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *RunQueryRequest) GetQuery() *Query {
	if x, ok := m.GetQueryType().(*RunQueryRequest_Query); ok {
		return x.Query
	}
	return nil
}

func (m *RunQueryRequest) GetGqlQuery() *GqlQuery {
	if x, ok := m.GetQueryType().(*RunQueryRequest_GqlQuery); ok {
		return x.GqlQuery
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RunQueryRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RunQueryRequest_Query)(nil),
		(*RunQueryRequest_GqlQuery)(nil),
	}
}

// The response for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryResponse struct {
	// A batch of query results (always present).
	Batch *QueryResultBatch `protobuf:"bytes,1,opt,name=batch,proto3" json:"batch,omitempty"`
	// The parsed form of the `GqlQuery` from the request, if it was set.
	Query                *Query   `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunQueryResponse) Reset()         { *m = RunQueryResponse{} }
func (m *RunQueryResponse) String() string { return proto.CompactTextString(m) }
func (*RunQueryResponse) ProtoMessage()    {}
func (*RunQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{3}
}

func (m *RunQueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunQueryResponse.Unmarshal(m, b)
}
func (m *RunQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunQueryResponse.Marshal(b, m, deterministic)
}
func (m *RunQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunQueryResponse.Merge(m, src)
}
func (m *RunQueryResponse) XXX_Size() int {
	return xxx_messageInfo_RunQueryResponse.Size(m)
}
func (m *RunQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RunQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RunQueryResponse proto.InternalMessageInfo

func (m *RunQueryResponse) GetBatch() *QueryResultBatch {
	if m != nil {
		return m.Batch
	}
	return nil
}

func (m *RunQueryResponse) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

// The request for [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionRequest struct {
	// Required. The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Options for a new transaction.
	TransactionOptions   *TransactionOptions `protobuf:"bytes,10,opt,name=transaction_options,json=transactionOptions,proto3" json:"transaction_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *BeginTransactionRequest) Reset()         { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()    {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{4}
}

func (m *BeginTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginTransactionRequest.Unmarshal(m, b)
}
func (m *BeginTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginTransactionRequest.Marshal(b, m, deterministic)
}
func (m *BeginTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionRequest.Merge(m, src)
}
func (m *BeginTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_BeginTransactionRequest.Size(m)
}
func (m *BeginTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionRequest proto.InternalMessageInfo

func (m *BeginTransactionRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BeginTransactionRequest) GetTransactionOptions() *TransactionOptions {
	if m != nil {
		return m.TransactionOptions
	}
	return nil
}

// The response for [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionResponse struct {
	// The transaction identifier (always present).
	Transaction          []byte   `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginTransactionResponse) Reset()         { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()    {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{5}
}

func (m *BeginTransactionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginTransactionResponse.Unmarshal(m, b)
}
func (m *BeginTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginTransactionResponse.Marshal(b, m, deterministic)
}
func (m *BeginTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionResponse.Merge(m, src)
}
func (m *BeginTransactionResponse) XXX_Size() int {
	return xxx_messageInfo_BeginTransactionResponse.Size(m)
}
func (m *BeginTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionResponse proto.InternalMessageInfo

func (m *BeginTransactionResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
type RollbackRequest struct {
	// Required. The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The transaction identifier, returned by a call to
	// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
	Transaction          []byte   `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackRequest) Reset()         { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()    {}
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{6}
}

func (m *RollbackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackRequest.Unmarshal(m, b)
}
func (m *RollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackRequest.Marshal(b, m, deterministic)
}
func (m *RollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackRequest.Merge(m, src)
}
func (m *RollbackRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackRequest.Size(m)
}
func (m *RollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackRequest proto.InternalMessageInfo

func (m *RollbackRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RollbackRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The response for [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
// (an empty message).
type RollbackResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackResponse) Reset()         { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()    {}
func (*RollbackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{7}
}

func (m *RollbackResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackResponse.Unmarshal(m, b)
}
func (m *RollbackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackResponse.Marshal(b, m, deterministic)
}
func (m *RollbackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackResponse.Merge(m, src)
}
func (m *RollbackResponse) XXX_Size() int {
	return xxx_messageInfo_RollbackResponse.Size(m)
}
func (m *RollbackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackResponse proto.InternalMessageInfo

// The request for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitRequest struct {
	// Required. The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The type of commit to perform. Defaults to `TRANSACTIONAL`.
	Mode CommitRequest_Mode `protobuf:"varint,5,opt,name=mode,proto3,enum=google.datastore.v1.CommitRequest_Mode" json:"mode,omitempty"`
	// Must be set when mode is `TRANSACTIONAL`.
	//
	// Types that are valid to be assigned to TransactionSelector:
	//	*CommitRequest_Transaction
	TransactionSelector isCommitRequest_TransactionSelector `protobuf_oneof:"transaction_selector"`
	// The mutations to perform.
	//
	// When mode is `TRANSACTIONAL`, mutations affecting a single entity are
	// applied in order. The following sequences of mutations affecting a single
	// entity are not permitted in a single `Commit` request:
	//
	// - `insert` followed by `insert`
	// - `update` followed by `insert`
	// - `upsert` followed by `insert`
	// - `delete` followed by `update`
	//
	// When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
	// entity.
	Mutations            []*Mutation `protobuf:"bytes,6,rep,name=mutations,proto3" json:"mutations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{8}
}

func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitRequest.Unmarshal(m, b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
}
func (m *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(m, src)
}
func (m *CommitRequest) XXX_Size() int {
	return xxx_messageInfo_CommitRequest.Size(m)
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

func (m *CommitRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CommitRequest) GetMode() CommitRequest_Mode {
	if m != nil {
		return m.Mode
	}
	return CommitRequest_MODE_UNSPECIFIED
}

type isCommitRequest_TransactionSelector interface {
	isCommitRequest_TransactionSelector()
}

type CommitRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3,oneof"`
}

func (*CommitRequest_Transaction) isCommitRequest_TransactionSelector() {}

func (m *CommitRequest) GetTransactionSelector() isCommitRequest_TransactionSelector {
	if m != nil {
		return m.TransactionSelector
	}
	return nil
}

func (m *CommitRequest) GetTransaction() []byte {
	if x, ok := m.GetTransactionSelector().(*CommitRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *CommitRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CommitRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CommitRequest_Transaction)(nil),
	}
}

// The response for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitResponse struct {
	// The result of performing the mutations.
	// The i-th mutation result corresponds to the i-th mutation in the request.
	MutationResults []*MutationResult `protobuf:"bytes,3,rep,name=mutation_results,json=mutationResults,proto3" json:"mutation_results,omitempty"`
	// The number of index entries updated during the commit, or zero if none were
	// updated.
	IndexUpdates         int32    `protobuf:"varint,4,opt,name=index_updates,json=indexUpdates,proto3" json:"index_updates,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{9}
}

func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResponse.Unmarshal(m, b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
}
func (m *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(m, src)
}
func (m *CommitResponse) XXX_Size() int {
	return xxx_messageInfo_CommitResponse.Size(m)
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

func (m *CommitResponse) GetMutationResults() []*MutationResult {
	if m != nil {
		return m.MutationResults
	}
	return nil
}

func (m *CommitResponse) GetIndexUpdates() int32 {
	if m != nil {
		return m.IndexUpdates
	}
	return 0
}

// The request for [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsRequest struct {
	// Required. The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. A list of keys with incomplete key paths for which to allocate IDs.
	// No key may be reserved/read-only.
	Keys                 []*Key   `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocateIdsRequest) Reset()         { *m = AllocateIdsRequest{} }
func (m *AllocateIdsRequest) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsRequest) ProtoMessage()    {}
func (*AllocateIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{10}
}

func (m *AllocateIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocateIdsRequest.Unmarshal(m, b)
}
func (m *AllocateIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocateIdsRequest.Marshal(b, m, deterministic)
}
func (m *AllocateIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocateIdsRequest.Merge(m, src)
}
func (m *AllocateIdsRequest) XXX_Size() int {
	return xxx_messageInfo_AllocateIdsRequest.Size(m)
}
func (m *AllocateIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocateIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AllocateIdsRequest proto.InternalMessageInfo

func (m *AllocateIdsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AllocateIdsRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsResponse struct {
	// The keys specified in the request (in the same order), each with
	// its key path completed with a newly allocated ID.
	Keys                 []*Key   `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocateIdsResponse) Reset()         { *m = AllocateIdsResponse{} }
func (m *AllocateIdsResponse) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsResponse) ProtoMessage()    {}
func (*AllocateIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{11}
}

func (m *AllocateIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocateIdsResponse.Unmarshal(m, b)
}
func (m *AllocateIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocateIdsResponse.Marshal(b, m, deterministic)
}
func (m *AllocateIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocateIdsResponse.Merge(m, src)
}
func (m *AllocateIdsResponse) XXX_Size() int {
	return xxx_messageInfo_AllocateIdsResponse.Size(m)
}
func (m *AllocateIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocateIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AllocateIdsResponse proto.InternalMessageInfo

func (m *AllocateIdsResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The request for [Datastore.ReserveIds][google.datastore.v1.Datastore.ReserveIds].
type ReserveIdsRequest struct {
	// Required. The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If not empty, the ID of the database against which to make the request.
	DatabaseId string `protobuf:"bytes,9,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// Required. A list of keys with complete key paths whose numeric IDs should not be
	// auto-allocated.
	Keys                 []*Key   `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReserveIdsRequest) Reset()         { *m = ReserveIdsRequest{} }
func (m *ReserveIdsRequest) String() string { return proto.CompactTextString(m) }
func (*ReserveIdsRequest) ProtoMessage()    {}
func (*ReserveIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{12}
}

func (m *ReserveIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReserveIdsRequest.Unmarshal(m, b)
}
func (m *ReserveIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReserveIdsRequest.Marshal(b, m, deterministic)
}
func (m *ReserveIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReserveIdsRequest.Merge(m, src)
}
func (m *ReserveIdsRequest) XXX_Size() int {
	return xxx_messageInfo_ReserveIdsRequest.Size(m)
}
func (m *ReserveIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReserveIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReserveIdsRequest proto.InternalMessageInfo

func (m *ReserveIdsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ReserveIdsRequest) GetDatabaseId() string {
	if m != nil {
		return m.DatabaseId
	}
	return ""
}

func (m *ReserveIdsRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.ReserveIds][google.datastore.v1.Datastore.ReserveIds].
type ReserveIdsResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReserveIdsResponse) Reset()         { *m = ReserveIdsResponse{} }
func (m *ReserveIdsResponse) String() string { return proto.CompactTextString(m) }
func (*ReserveIdsResponse) ProtoMessage()    {}
func (*ReserveIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{13}
}

func (m *ReserveIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReserveIdsResponse.Unmarshal(m, b)
}
func (m *ReserveIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReserveIdsResponse.Marshal(b, m, deterministic)
}
func (m *ReserveIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReserveIdsResponse.Merge(m, src)
}
func (m *ReserveIdsResponse) XXX_Size() int {
	return xxx_messageInfo_ReserveIdsResponse.Size(m)
}
func (m *ReserveIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReserveIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReserveIdsResponse proto.InternalMessageInfo

// A mutation to apply to an entity.
type Mutation struct {
	// The mutation operation.
	//
	// For `insert`, `update`, and `upsert`:
	// - The entity's key must not be reserved/read-only.
	// - No property in the entity may have a reserved name,
	//   not even a property in an entity in a value.
	// - No value in the entity may have meaning 18,
	//   not even a value in an entity in another value.
	//
	// Types that are valid to be assigned to Operation:
	//	*Mutation_Insert
	//	*Mutation_Update
	//	*Mutation_Upsert
	//	*Mutation_Delete
	Operation isMutation_Operation `protobuf_oneof:"operation"`
	// When set, the server will detect whether or not this mutation conflicts
	// with the current version of the entity on the server. Conflicting mutations
	// are not applied, and are marked as such in MutationResult.
	//
	// Types that are valid to be assigned to ConflictDetectionStrategy:
	//	*Mutation_BaseVersion
	ConflictDetectionStrategy isMutation_ConflictDetectionStrategy `protobuf_oneof:"conflict_detection_strategy"`
	XXX_NoUnkeyedLiteral      struct{}                             `json:"-"`
	XXX_unrecognized          []byte                               `json:"-"`
	XXX_sizecache             int32                                `json:"-"`
}

func (m *Mutation) Reset()         { *m = Mutation{} }
func (m *Mutation) String() string { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()    {}
func (*Mutation) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{14}
}

func (m *Mutation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mutation.Unmarshal(m, b)
}
func (m *Mutation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mutation.Marshal(b, m, deterministic)
}
func (m *Mutation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation.Merge(m, src)
}
func (m *Mutation) XXX_Size() int {
	return xxx_messageInfo_Mutation.Size(m)
}
func (m *Mutation) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation proto.InternalMessageInfo

type isMutation_Operation interface {
	isMutation_Operation()
}

type Mutation_Insert struct {
	Insert *Entity `protobuf:"bytes,4,opt,name=insert,proto3,oneof"`
}

type Mutation_Update struct {
	Update *Entity `protobuf:"bytes,5,opt,name=update,proto3,oneof"`
}

type Mutation_Upsert struct {
	Upsert *Entity `protobuf:"bytes,6,opt,name=upsert,proto3,oneof"`
}

type Mutation_Delete struct {
	Delete *Key `protobuf:"bytes,7,opt,name=delete,proto3,oneof"`
}

func (*Mutation_Insert) isMutation_Operation() {}

func (*Mutation_Update) isMutation_Operation() {}

func (*Mutation_Upsert) isMutation_Operation() {}

func (*Mutation_Delete) isMutation_Operation() {}

func (m *Mutation) GetOperation() isMutation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *Mutation) GetInsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Insert); ok {
		return x.Insert
	}
	return nil
}

func (m *Mutation) GetUpdate() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *Mutation) GetUpsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Upsert); ok {
		return x.Upsert
	}
	return nil
}

func (m *Mutation) GetDelete() *Key {
	if x, ok := m.GetOperation().(*Mutation_Delete); ok {
		return x.Delete
	}
	return nil
}

type isMutation_ConflictDetectionStrategy interface {
	isMutation_ConflictDetectionStrategy()
}

type Mutation_BaseVersion struct {
	BaseVersion int64 `protobuf:"varint,8,opt,name=base_version,json=baseVersion,proto3,oneof"`
}

func (*Mutation_BaseVersion) isMutation_ConflictDetectionStrategy() {}

func (m *Mutation) GetConflictDetectionStrategy() isMutation_ConflictDetectionStrategy {
	if m != nil {
		return m.ConflictDetectionStrategy
	}
	return nil
}

func (m *Mutation) GetBaseVersion() int64 {
	if x, ok := m.GetConflictDetectionStrategy().(*Mutation_BaseVersion); ok {
		return x.BaseVersion
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Mutation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Mutation_Insert)(nil),
		(*Mutation_Update)(nil),
		(*Mutation_Upsert)(nil),
		(*Mutation_Delete)(nil),
		(*Mutation_BaseVersion)(nil),
	}
}

// The result of applying a mutation.
type MutationResult struct {
	// The automatically allocated key.
	// Set only when the mutation allocated a key.
	Key *Key `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// The version of the entity on the server after processing the mutation. If
	// the mutation doesn't change anything on the server, then the version will
	// be the version of the current entity or, if no entity is present, a version
	// that is strictly greater than the version of any previous entity and less
	// than the version of any possible future entity.
	Version int64 `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	// Whether a conflict was detected for this mutation. Always false when a
	// conflict detection strategy field is not set in the mutation.
	ConflictDetected     bool     `protobuf:"varint,5,opt,name=conflict_detected,json=conflictDetected,proto3" json:"conflict_detected,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutationResult) Reset()         { *m = MutationResult{} }
func (m *MutationResult) String() string { return proto.CompactTextString(m) }
func (*MutationResult) ProtoMessage()    {}
func (*MutationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{15}
}

func (m *MutationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutationResult.Unmarshal(m, b)
}
func (m *MutationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutationResult.Marshal(b, m, deterministic)
}
func (m *MutationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutationResult.Merge(m, src)
}
func (m *MutationResult) XXX_Size() int {
	return xxx_messageInfo_MutationResult.Size(m)
}
func (m *MutationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutationResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutationResult proto.InternalMessageInfo

func (m *MutationResult) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *MutationResult) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *MutationResult) GetConflictDetected() bool {
	if m != nil {
		return m.ConflictDetected
	}
	return false
}

// The options shared by read requests.
type ReadOptions struct {
	// If not specified, lookups and ancestor queries default to
	// `read_consistency`=`STRONG`, global queries default to
	// `read_consistency`=`EVENTUAL`.
	//
	// Types that are valid to be assigned to ConsistencyType:
	//	*ReadOptions_ReadConsistency_
	//	*ReadOptions_Transaction
	ConsistencyType      isReadOptions_ConsistencyType `protobuf_oneof:"consistency_type"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ReadOptions) Reset()         { *m = ReadOptions{} }
func (m *ReadOptions) String() string { return proto.CompactTextString(m) }
func (*ReadOptions) ProtoMessage()    {}
func (*ReadOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{16}
}

func (m *ReadOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadOptions.Unmarshal(m, b)
}
func (m *ReadOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadOptions.Marshal(b, m, deterministic)
}
func (m *ReadOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadOptions.Merge(m, src)
}
func (m *ReadOptions) XXX_Size() int {
	return xxx_messageInfo_ReadOptions.Size(m)
}
func (m *ReadOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ReadOptions proto.InternalMessageInfo

type isReadOptions_ConsistencyType interface {
	isReadOptions_ConsistencyType()
}

type ReadOptions_ReadConsistency_ struct {
	ReadConsistency ReadOptions_ReadConsistency `protobuf:"varint,1,opt,name=read_consistency,json=readConsistency,proto3,enum=google.datastore.v1.ReadOptions_ReadConsistency,oneof"`
}

type ReadOptions_Transaction struct {
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3,oneof"`
}

func (*ReadOptions_ReadConsistency_) isReadOptions_ConsistencyType() {}

func (*ReadOptions_Transaction) isReadOptions_ConsistencyType() {}

func (m *ReadOptions) GetConsistencyType() isReadOptions_ConsistencyType {
	if m != nil {
		return m.ConsistencyType
	}
	return nil
}

func (m *ReadOptions) GetReadConsistency() ReadOptions_ReadConsistency {
	if x, ok := m.GetConsistencyType().(*ReadOptions_ReadConsistency_); ok {
		return x.ReadConsistency
	}
	return ReadOptions_READ_CONSISTENCY_UNSPECIFIED
}

func (m *ReadOptions) GetTransaction() []byte {
	if x, ok := m.GetConsistencyType().(*ReadOptions_Transaction); ok {
		return x.Transaction
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReadOptions) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReadOptions_ReadConsistency_)(nil),
		(*ReadOptions_Transaction)(nil),
	}
}

// Options for beginning a new transaction.
//
// Transactions can be created explicitly with calls to
// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction] or implicitly by setting
// [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction] in read requests.
type TransactionOptions struct {
	// The `mode` of the transaction, indicating whether write operations are
	// supported.
	//
	// Types that are valid to be assigned to Mode:
	//	*TransactionOptions_ReadWrite_
	//	*TransactionOptions_ReadOnly_
	Mode                 isTransactionOptions_Mode `protobuf_oneof:"mode"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *TransactionOptions) Reset()         { *m = TransactionOptions{} }
func (m *TransactionOptions) String() string { return proto.CompactTextString(m) }
func (*TransactionOptions) ProtoMessage()    {}
func (*TransactionOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{17}
}

func (m *TransactionOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionOptions.Unmarshal(m, b)
}
func (m *TransactionOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionOptions.Marshal(b, m, deterministic)
}
func (m *TransactionOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionOptions.Merge(m, src)
}
func (m *TransactionOptions) XXX_Size() int {
	return xxx_messageInfo_TransactionOptions.Size(m)
}
func (m *TransactionOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionOptions.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionOptions proto.InternalMessageInfo

type isTransactionOptions_Mode interface {
	isTransactionOptions_Mode()
}

type TransactionOptions_ReadWrite_ struct {
	ReadWrite *TransactionOptions_ReadWrite `protobuf:"bytes,1,opt,name=read_write,json=readWrite,proto3,oneof"`
}

type TransactionOptions_ReadOnly_ struct {
	ReadOnly *TransactionOptions_ReadOnly `protobuf:"bytes,2,opt,name=read_only,json=readOnly,proto3,oneof"`
}

func (*TransactionOptions_ReadWrite_) isTransactionOptions_Mode() {}

func (*TransactionOptions_ReadOnly_) isTransactionOptions_Mode() {}

func (m *TransactionOptions) GetMode() isTransactionOptions_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (m *TransactionOptions) GetReadWrite() *TransactionOptions_ReadWrite {
	if x, ok := m.GetMode().(*TransactionOptions_ReadWrite_); ok {
		return x.ReadWrite
	}
	return nil
}

func (m *TransactionOptions) GetReadOnly() *TransactionOptions_ReadOnly {
	if x, ok := m.GetMode().(*TransactionOptions_ReadOnly_); ok {
		return x.ReadOnly
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TransactionOptions) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TransactionOptions_ReadWrite_)(nil),
		(*TransactionOptions_ReadOnly_)(nil),
	}
}

// Options specific to read / write transactions.
type TransactionOptions_ReadWrite struct {
	// The transaction identifier of the transaction being retried.
	PreviousTransaction  []byte   `protobuf:"bytes,1,opt,name=previous_transaction,json=previousTransaction,proto3" json:"previous_transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransactionOptions_ReadWrite) Reset()         { *m = TransactionOptions_ReadWrite{} }
func (m *TransactionOptions_ReadWrite) String() string { return proto.CompactTextString(m) }
func (*TransactionOptions_ReadWrite) ProtoMessage()    {}
func (*TransactionOptions_ReadWrite) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{17, 0}
}

func (m *TransactionOptions_ReadWrite) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionOptions_ReadWrite.Unmarshal(m, b)
}
func (m *TransactionOptions_ReadWrite) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionOptions_ReadWrite.Marshal(b, m, deterministic)
}
func (m *TransactionOptions_ReadWrite) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionOptions_ReadWrite.Merge(m, src)
}
func (m *TransactionOptions_ReadWrite) XXX_Size() int {
	return xxx_messageInfo_TransactionOptions_ReadWrite.Size(m)
}
func (m *TransactionOptions_ReadWrite) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionOptions_ReadWrite.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionOptions_ReadWrite proto.InternalMessageInfo

func (m *TransactionOptions_ReadWrite) GetPreviousTransaction() []byte {
	if m != nil {
		return m.PreviousTransaction
	}
	return nil
}

// Options specific to read-only transactions.
type TransactionOptions_ReadOnly struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransactionOptions_ReadOnly) Reset()         { *m = TransactionOptions_ReadOnly{} }
func (m *TransactionOptions_ReadOnly) String() string { return proto.CompactTextString(m) }
func (*TransactionOptions_ReadOnly) ProtoMessage()    {}
func (*TransactionOptions_ReadOnly) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ad66bfcb30c1b57, []int{17, 1}
}

func (m *TransactionOptions_ReadOnly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionOptions_ReadOnly.Unmarshal(m, b)
}
func (m *TransactionOptions_ReadOnly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionOptions_ReadOnly.Marshal(b, m, deterministic)
}
func (m *TransactionOptions_ReadOnly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionOptions_ReadOnly.Merge(m, src)
}
func (m *TransactionOptions_ReadOnly) XXX_Size() int {
	return xxx_messageInfo_TransactionOptions_ReadOnly.Size(m)
}
func (m *TransactionOptions_ReadOnly) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionOptions_ReadOnly.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionOptions_ReadOnly proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("google.datastore.v1.CommitRequest_Mode", CommitRequest_Mode_name, CommitRequest_Mode_value)
	proto.RegisterEnum("google.datastore.v1.ReadOptions_ReadConsistency", ReadOptions_ReadConsistency_name, ReadOptions_ReadConsistency_value)
	proto.RegisterType((*LookupRequest)(nil), "google.datastore.v1.LookupRequest")
	proto.RegisterType((*LookupResponse)(nil), "google.datastore.v1.LookupResponse")
	proto.RegisterType((*RunQueryRequest)(nil), "google.datastore.v1.RunQueryRequest")
	proto.RegisterType((*RunQueryResponse)(nil), "google.datastore.v1.RunQueryResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.datastore.v1.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "google.datastore.v1.BeginTransactionResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.datastore.v1.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "google.datastore.v1.RollbackResponse")
	proto.RegisterType((*CommitRequest)(nil), "google.datastore.v1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.datastore.v1.CommitResponse")
	proto.RegisterType((*AllocateIdsRequest)(nil), "google.datastore.v1.AllocateIdsRequest")
	proto.RegisterType((*AllocateIdsResponse)(nil), "google.datastore.v1.AllocateIdsResponse")
	proto.RegisterType((*ReserveIdsRequest)(nil), "google.datastore.v1.ReserveIdsRequest")
	proto.RegisterType((*ReserveIdsResponse)(nil), "google.datastore.v1.ReserveIdsResponse")
	proto.RegisterType((*Mutation)(nil), "google.datastore.v1.Mutation")
	proto.RegisterType((*MutationResult)(nil), "google.datastore.v1.MutationResult")
	proto.RegisterType((*ReadOptions)(nil), "google.datastore.v1.ReadOptions")
	proto.RegisterType((*TransactionOptions)(nil), "google.datastore.v1.TransactionOptions")
	proto.RegisterType((*TransactionOptions_ReadWrite)(nil), "google.datastore.v1.TransactionOptions.ReadWrite")
	proto.RegisterType((*TransactionOptions_ReadOnly)(nil), "google.datastore.v1.TransactionOptions.ReadOnly")
}

func init() {
	proto.RegisterFile("google/datastore/v1/datastore.proto", fileDescriptor_9ad66bfcb30c1b57)
}

var fileDescriptor_9ad66bfcb30c1b57 = []byte{
	// 1543 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x4f, 0x6f, 0xe3, 0xd4,
	0x16, 0xaf, 0xd3, 0x36, 0x93, 0x9c, 0xf4, 0x4f, 0x7a, 0xdb, 0x37, 0x93, 0xc9, 0xcc, 0x68, 0xf2,
	0xdc, 0xe9, 0x9b, 0xbe, 0xd2, 0x49, 0xa6, 0x05, 0x84, 0xd4, 0x8e, 0x90, 0x92, 0x34, 0x33, 0x2d,
	0x4c, 0x93, 0xe2, 0x76, 0xca, 0x80, 0x8a, 0x22, 0xd7, 0xbe, 0x4d, 0x4d, 0x1d, 0x5f, 0xd7, 0xbe,
	0x69, 0xa9, 0x10, 0x0b, 0x40, 0xb0, 0x41, 0xac, 0x66, 0xc1, 0x0a, 0x01, 0x12, 0x2b, 0x58, 0x21,
	0x58, 0x22, 0x21, 0xb1, 0x9c, 0x25, 0xec, 0xba, 0x62, 0xc1, 0x37, 0xe0, 0x0b, 0x20, 0x5f, 0x5f,
	0xc7, 0x76, 0x6a, 0x37, 0x2d, 0x62, 0x97, 0x7b, 0xef, 0xef, 0x9c, 0xf3, 0x3b, 0x7f, 0x7c, 0xce,
	0x51, 0x60, 0xba, 0x45, 0x48, 0x4b, 0xc7, 0x25, 0x55, 0xa6, 0xb2, 0x4d, 0x89, 0x85, 0x4b, 0x47,
	0x0b, 0xfe, 0xa1, 0x68, 0x5a, 0x84, 0x12, 0x34, 0xe9, 0x82, 0x8a, 0xfe, 0xfd, 0xd1, 0x42, 0xfe,
	0x26, 0x97, 0x94, 0x4d, 0xad, 0x24, 0x1b, 0x06, 0xa1, 0x32, 0xd5, 0x88, 0x61, 0xbb, 0x22, 0xf9,
	0x6b, 0x81, 0x57, 0x45, 0xd7, 0xb0, 0x41, 0xf9, 0xc3, 0xed, 0xc0, 0xc3, 0x9e, 0x86, 0x75, 0xb5,
	0xb9, 0x8b, 0xf7, 0xe5, 0x23, 0x8d, 0x58, 0x1c, 0x50, 0x88, 0x62, 0x84, 0x0d, 0xaa, 0xd1, 0x93,
	0x1e, 0x15, 0x21, 0xc4, 0x61, 0x07, 0x5b, 0x1c, 0x20, 0x7e, 0x2f, 0xc0, 0xe8, 0x63, 0x42, 0x0e,
	0x3a, 0xa6, 0x84, 0x0f, 0x3b, 0xd8, 0xa6, 0x48, 0x04, 0x30, 0x2d, 0xf2, 0x2e, 0x56, 0x68, 0x53,
	0x53, 0x73, 0xa9, 0x82, 0x30, 0x9b, 0xae, 0x0c, 0xfe, 0x51, 0x4e, 0x48, 0x69, 0x7e, 0xbd, 0xa6,
	0xa2, 0x2a, 0x8c, 0x58, 0x58, 0x56, 0x9b, 0xc4, 0x64, 0x8e, 0xe4, 0x84, 0x82, 0x30, 0x9b, 0x59,
	0x2c, 0x14, 0x23, 0x9c, 0x2f, 0x4a, 0x58, 0x56, 0x1b, 0x2e, 0x4e, 0xca, 0x58, 0xfe, 0x01, 0x2d,
	0xc0, 0xd0, 0x01, 0x3e, 0xb1, 0x73, 0x83, 0x85, 0xc1, 0xd9, 0xcc, 0x62, 0x2e, 0x52, 0xf8, 0x75,
	0x7c, 0xe2, 0x1a, 0x67, 0x50, 0xf1, 0x67, 0x01, 0xc6, 0x3c, 0xb6, 0xb6, 0x49, 0x0c, 0x1b, 0xa3,
	0x57, 0x60, 0x78, 0x8f, 0x74, 0x0c, 0x35, 0x27, 0x30, 0x35, 0xff, 0x8d, 0x54, 0x53, 0x63, 0x31,
	0x91, 0xb0, 0xdd, 0xd1, 0xa9, 0xe4, 0xe2, 0xd1, 0x32, 0x5c, 0x69, 0x6b, 0xb6, 0xad, 0x19, 0xad,
	0x5c, 0xe2, 0xa2, 0xa2, 0x9e, 0x04, 0x7a, 0x09, 0x52, 0x2a, 0xde, 0xc3, 0x96, 0x85, 0xd5, 0x7e,
	0xfc, 0xa5, 0x2e, 0x52, 0xfc, 0x25, 0x01, 0xe3, 0x52, 0xc7, 0x78, 0xc3, 0x89, 0xff, 0x25, 0xc3,
	0x6d, 0xca, 0x16, 0xd5, 0x9c, 0xb8, 0x39, 0xa8, 0xc4, 0x39, 0xe1, 0xde, 0xf0, 0x80, 0x6b, 0xaa,
	0x94, 0x31, 0xfd, 0xc3, 0xbf, 0x93, 0xb3, 0x45, 0x18, 0x66, 0xd5, 0x93, 0x1b, 0x64, 0xd2, 0xf9,
	0x48, 0x69, 0xe6, 0xdf, 0xea, 0x80, 0xe4, 0x42, 0xd1, 0x03, 0x48, 0xb7, 0x0e, 0xf5, 0xa6, 0x2b,
	0x77, 0x85, 0xc9, 0xdd, 0x8a, 0x94, 0x7b, 0x74, 0xa8, 0x7b, 0xa2, 0xa9, 0x16, 0xff, 0x5d, 0x19,
	0x01, 0x60, 0x92, 0x4d, 0x7a, 0x62, 0x62, 0xf1, 0x43, 0x01, 0xb2, 0x7e, 0x04, 0x79, 0x09, 0x2c,
	0xc3, 0xf0, 0xae, 0x4c, 0x95, 0x7d, 0xee, 0xd2, 0x4c, 0x3c, 0x29, 0x37, 0x8d, 0x15, 0x07, 0x2c,
	0xb9, 0x32, 0xe8, 0xbe, 0xe7, 0x51, 0xa2, 0x9f, 0x47, 0xdc, 0x1f, 0xf1, 0x0b, 0x01, 0xae, 0x55,
	0x70, 0x4b, 0x33, 0xb6, 0x2c, 0xd9, 0xb0, 0x65, 0xc5, 0x89, 0xcc, 0x65, 0xb2, 0xf9, 0x14, 0x26,
	0xa9, 0x2f, 0xd9, 0xcd, 0x07, 0x30, 0xfb, 0x77, 0x23, 0xed, 0x07, 0x2c, 0x79, 0x69, 0x41, 0xf4,
	0xcc, 0x9d, 0xf8, 0x00, 0x72, 0x67, 0x89, 0xf1, 0x20, 0x15, 0x20, 0x13, 0x90, 0x60, 0xa1, 0x1a,
	0x91, 0x82, 0x57, 0xe2, 0x0e, 0x8c, 0x4b, 0x44, 0xd7, 0x77, 0x65, 0xe5, 0xe0, 0x32, 0xee, 0xcc,
	0x44, 0x28, 0x76, 0x41, 0x21, 0xed, 0x08, 0xb2, 0xbe, 0x76, 0x97, 0x93, 0xf8, 0x43, 0x02, 0x46,
	0xab, 0xa4, 0xdd, 0xd6, 0xe8, 0x65, 0x0c, 0x2e, 0xc3, 0x50, 0x9b, 0xa8, 0x38, 0x37, 0x5c, 0x10,
	0x66, 0xc7, 0x62, 0x02, 0x16, 0xd2, 0x5a, 0x5c, 0x27, 0x2a, 0x96, 0x98, 0x10, 0x12, 0x23, 0xd8,
	0xae, 0x0e, 0x84, 0xa8, 0xa2, 0x65, 0x48, 0xb7, 0x3b, 0xbc, 0x47, 0xe7, 0x92, 0xec, 0xeb, 0x8e,
	0x2e, 0xd8, 0x75, 0x8e, 0x92, 0x7c, 0xbc, 0xf8, 0x10, 0x86, 0x1c, 0x73, 0x68, 0x0a, 0xb2, 0xeb,
	0x8d, 0x95, 0x5a, 0xf3, 0x49, 0x7d, 0x73, 0xa3, 0x56, 0x5d, 0x7b, 0xb8, 0x56, 0x5b, 0xc9, 0x0e,
	0xa0, 0x09, 0x18, 0xdd, 0x92, 0xca, 0xf5, 0xcd, 0x72, 0x75, 0x6b, 0xad, 0x51, 0x2f, 0x3f, 0xce,
	0x0a, 0xe8, 0x3f, 0x30, 0x51, 0x6f, 0xd4, 0x9b, 0xe1, 0xeb, 0x44, 0xe5, 0x2a, 0x4c, 0x05, 0xab,
	0xc4, 0xc6, 0x3a, 0x56, 0x28, 0xb1, 0xc4, 0x4f, 0x04, 0x18, 0xf3, 0xbc, 0xe3, 0xa9, 0xad, 0x43,
	0xd6, 0xb3, 0xdf, 0xb4, 0x58, 0x85, 0x7b, 0x4d, 0x75, 0xfa, 0x7c, 0xda, 0x6e, 0x53, 0x1b, 0x6f,
	0x87, 0xce, 0x36, 0x9a, 0x86, 0x51, 0xcd, 0x50, 0xf1, 0x7b, 0xcd, 0x8e, 0xa9, 0xca, 0x14, 0xdb,
	0xb9, 0xa1, 0x82, 0x30, 0x3b, 0x2c, 0x8d, 0xb0, 0xcb, 0x27, 0xee, 0x9d, 0x78, 0x00, 0xa8, 0xac,
	0xeb, 0x44, 0x91, 0x29, 0x5e, 0x53, 0xed, 0xcb, 0xe4, 0xcf, 0xeb, 0xfb, 0xc2, 0xc5, 0xfb, 0x7e,
	0x15, 0x26, 0x43, 0xc6, 0xb8, 0xe3, 0xf3, 0x17, 0xd3, 0xc4, 0x95, 0x7c, 0x26, 0xc0, 0x84, 0x84,
	0x6d, 0x6c, 0x1d, 0x5d, 0x96, 0xf1, 0x6d, 0xc8, 0x38, 0x3a, 0x77, 0x65, 0x1b, 0x3b, 0xa0, 0xb4,
	0x03, 0x92, 0xc0, 0xbb, 0xfa, 0x67, 0x2e, 0x4d, 0x01, 0x0a, 0x92, 0xe1, 0x5f, 0xc4, 0x4f, 0x09,
	0x48, 0x79, 0xe9, 0x41, 0x2f, 0x43, 0x52, 0x33, 0x6c, 0x6c, 0x51, 0x96, 0x80, 0xcc, 0xe2, 0x8d,
	0x73, 0x06, 0xd4, 0xea, 0x80, 0xc4, 0xc1, 0x8e, 0x98, 0x9b, 0x38, 0xf6, 0x85, 0xf4, 0x17, 0x73,
	0xc1, 0xae, 0x18, 0xb3, 0x96, 0xbc, 0xa0, 0x18, 0xb3, 0xb6, 0x08, 0x49, 0x15, 0xeb, 0x98, 0x62,
	0xde, 0xda, 0x63, 0x9d, 0x77, 0x64, 0x5c, 0x24, 0x9a, 0x86, 0x11, 0x16, 0xcb, 0x23, 0x6c, 0xd9,
	0xce, 0x57, 0xe8, 0x44, 0x7d, 0x70, 0x55, 0x90, 0x32, 0xce, 0xed, 0xb6, 0x7b, 0x59, 0xc9, 0x40,
	0x9a, 0x98, 0xd8, 0x62, 0xa1, 0xa8, 0xdc, 0x82, 0x1b, 0x0a, 0x31, 0xf6, 0x74, 0x4d, 0xa1, 0x4d,
	0x15, 0x53, 0xcc, 0x3f, 0x0a, 0x6a, 0xc9, 0x14, 0xb7, 0x4e, 0xc4, 0x8f, 0x05, 0x18, 0x0b, 0x57,
	0x35, 0x9a, 0x83, 0xc1, 0x03, 0xec, 0xcd, 0xa9, 0xf8, 0xd2, 0x70, 0x40, 0x28, 0x07, 0x57, 0x3c,
	0x2a, 0x4e, 0xa4, 0x07, 0x25, 0xef, 0x88, 0x5e, 0x80, 0x89, 0x1e, 0xbb, 0x58, 0x65, 0x61, 0x4d,
	0x49, 0x59, 0xef, 0x61, 0x85, 0xdf, 0x8b, 0x7f, 0x09, 0x90, 0x09, 0x4c, 0x4e, 0xf4, 0x0e, 0x64,
	0xd9, 0xc4, 0x55, 0x88, 0x61, 0x6b, 0x36, 0xc5, 0x86, 0x72, 0xc2, 0x1a, 0xce, 0xd8, 0xe2, 0xfd,
	0x7e, 0x53, 0x97, 0xfd, 0xae, 0xfa, 0x72, 0xab, 0x03, 0xd2, 0xb8, 0x15, 0xbe, 0xea, 0x6d, 0x65,
	0x89, 0x88, 0x56, 0x26, 0xae, 0xc3, 0x78, 0x8f, 0x26, 0x54, 0x80, 0x9b, 0x52, 0xad, 0xbc, 0xd2,
	0xac, 0x36, 0xea, 0x9b, 0x6b, 0x9b, 0x5b, 0xb5, 0x7a, 0xf5, 0xad, 0x9e, 0x26, 0x05, 0x90, 0xdc,
	0xdc, 0x92, 0x1a, 0xf5, 0x47, 0x59, 0x01, 0x8d, 0x40, 0xaa, 0xb6, 0x5d, 0xab, 0x6f, 0x3d, 0x61,
	0x4d, 0x09, 0x41, 0x36, 0xe0, 0x8c, 0x3b, 0x92, 0x3f, 0x4f, 0x00, 0x3a, 0x3b, 0x9f, 0x90, 0x04,
	0xc0, 0x9c, 0x3f, 0xb6, 0x34, 0x8a, 0xf9, 0x64, 0x5e, 0xb8, 0xe0, 0x70, 0x63, 0xde, 0xbf, 0xe9,
	0x08, 0xae, 0x0e, 0x48, 0x69, 0xcb, 0x3b, 0xa0, 0x06, 0xa4, 0xdd, 0x15, 0xc6, 0xd0, 0xbd, 0x79,
	0x7d, 0xff, 0x32, 0x2a, 0x1b, 0x86, 0xce, 0x96, 0x0b, 0x8b, 0xff, 0xce, 0xbf, 0x0a, 0xe9, 0xae,
	0x29, 0xb4, 0x00, 0x53, 0xa6, 0x85, 0x8f, 0x34, 0xd2, 0xb1, 0x9b, 0x67, 0x47, 0xe5, 0xa4, 0xf7,
	0x16, 0xd0, 0x9d, 0x07, 0x48, 0x79, 0x7a, 0x2b, 0x49, 0x77, 0x2c, 0x2d, 0x3e, 0x03, 0x48, 0xaf,
	0x78, 0x64, 0xd0, 0x97, 0x02, 0x24, 0xdd, 0x8d, 0x15, 0x89, 0x91, 0x54, 0x43, 0xcb, 0x77, 0x7e,
	0xfa, 0x5c, 0x0c, 0x6f, 0x12, 0xaf, 0x9d, 0x96, 0x6f, 0xfa, 0x3d, 0x6b, 0x3e, 0xb8, 0xd5, 0xcd,
	0x3b, 0xbd, 0xe5, 0xa3, 0xdf, 0xff, 0x7c, 0x96, 0x98, 0x11, 0x0b, 0xce, 0xae, 0xcf, 0x71, 0x76,
	0xe9, 0x7d, 0x5f, 0xe2, 0x83, 0x25, 0x9d, 0x29, 0x5c, 0x12, 0xe6, 0xd0, 0xa7, 0x02, 0xa4, 0xbc,
	0x85, 0x0a, 0xdd, 0x89, 0x2e, 0xcb, 0xf0, 0xc6, 0x9a, 0x9f, 0xe9, 0x83, 0xe2, 0x2c, 0xef, 0x31,
	0x1a, 0x77, 0x45, 0x31, 0x9e, 0x86, 0xc5, 0x65, 0x1c, 0x22, 0x3f, 0x0a, 0x90, 0xed, 0x5d, 0x5e,
	0xd0, 0x7c, 0xa4, 0xa9, 0x98, 0xe5, 0x2b, 0x7f, 0xef, 0x82, 0x68, 0x4e, 0xb0, 0x72, 0x5a, 0x0e,
	0xb4, 0x7e, 0xc6, 0xb6, 0x24, 0xce, 0xc5, 0xb3, 0xdd, 0xed, 0x51, 0xe4, 0xb0, 0xfe, 0x55, 0x80,
	0xa4, 0x3b, 0x8d, 0x63, 0xd2, 0x1b, 0x5a, 0x44, 0x62, 0xd2, 0x1b, 0x1e, 0xe7, 0x22, 0x39, 0x2d,
	0xcf, 0x04, 0xd2, 0xeb, 0x14, 0xd5, 0x7c, 0xa0, 0x1e, 0xe7, 0xbb, 0xbb, 0xc6, 0x69, 0xf9, 0x7a,
	0x2f, 0xae, 0xfb, 0xd6, 0xbf, 0x06, 0x14, 0x66, 0xd5, 0x71, 0xe2, 0x2b, 0xa7, 0x06, 0xf8, 0x6e,
	0x16, 0x57, 0x03, 0xe1, 0xc5, 0x30, 0xae, 0x06, 0x7a, 0x17, 0xbc, 0x87, 0xa7, 0xe5, 0xab, 0x01,
	0x8a, 0x01, 0x2f, 0x2e, 0x50, 0x1c, 0x5c, 0x99, 0xc3, 0xf0, 0x5b, 0x01, 0x32, 0x81, 0x05, 0x00,
	0x45, 0x2f, 0x7d, 0x67, 0xf7, 0x91, 0xfc, 0x6c, 0x7f, 0xa0, 0x5f, 0x0d, 0xe3, 0x01, 0xaa, 0xdd,
	0xef, 0x68, 0x4e, 0x9c, 0x89, 0xe7, 0x28, 0xfb, 0x8a, 0x1c, 0x9a, 0x5f, 0x0b, 0x00, 0xfe, 0x50,
	0x47, 0xff, 0x8b, 0xe9, 0xf2, 0x3d, 0x2b, 0x48, 0xfe, 0x6e, 0x5f, 0x1c, 0xe7, 0x58, 0x8e, 0xe1,
	0xf8, 0x7f, 0xf1, 0xce, 0x39, 0x71, 0xec, 0xea, 0x59, 0x12, 0xe6, 0xf2, 0x47, 0xcf, 0xcb, 0x39,
	0xdf, 0x8c, 0x6b, 0x57, 0x36, 0x35, 0xbb, 0xa8, 0x90, 0xf6, 0x6f, 0xe5, 0xa7, 0xfb, 0x94, 0x9a,
	0xf6, 0x52, 0xa9, 0x74, 0x7c, 0x7c, 0xdc, 0xf3, 0x58, 0x92, 0x3b, 0x74, 0xbf, 0xa4, 0xe8, 0xa4,
	0xa3, 0xde, 0x33, 0x75, 0x99, 0xee, 0x11, 0xab, 0x3d, 0xdf, 0x0f, 0xde, 0xb5, 0x54, 0xf9, 0x46,
	0x80, 0x6b, 0x0a, 0x69, 0x47, 0x79, 0x5a, 0x19, 0xeb, 0xb6, 0xcb, 0x0d, 0x8b, 0x50, 0xb2, 0x21,
	0xbc, 0xfd, 0x80, 0xc3, 0x5a, 0x44, 0x97, 0x8d, 0x56, 0x91, 0x58, 0xad, 0x52, 0x0b, 0x1b, 0xec,
	0x1f, 0x8b, 0x92, 0x6f, 0x27, 0xf4, 0xaf, 0xc6, 0x72, 0xf7, 0xf0, 0x5d, 0xe2, 0xfa, 0x23, 0x57,
	0xbc, 0xea, 0xb0, 0x2d, 0x76, 0xb5, 0x17, 0xb7, 0x17, 0x9e, 0x7b, 0x6f, 0x3b, 0xec, 0x6d, 0xa7,
	0xfb, 0xb6, 0xb3, 0xbd, 0xb0, 0x9b, 0x64, 0x06, 0x5e, 0xfc, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x85,
	0xac, 0xde, 0x32, 0xe9, 0x11, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DatastoreClient is the client API for Datastore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatastoreClient interface {
	// Looks up entities by key.
	Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error)
	// Prevents the supplied keys' IDs from being auto-allocated by Cloud
	// Datastore.
	ReserveIds(ctx context.Context, in *ReserveIdsRequest, opts ...grpc.CallOption) (*ReserveIdsResponse, error)
}

type datastoreClient struct {
	cc *grpc.ClientConn
}

func NewDatastoreClient(cc *grpc.ClientConn) DatastoreClient {
	return &datastoreClient{cc}
}

func (c *datastoreClient) Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error) {
	out := new(LookupResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/Lookup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error) {
	out := new(RunQueryResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/RunQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/BeginTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error) {
	out := new(RollbackResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error) {
	out := new(AllocateIdsResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/AllocateIds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) ReserveIds(ctx context.Context, in *ReserveIdsRequest, opts ...grpc.CallOption) (*ReserveIdsResponse, error) {
	out := new(ReserveIdsResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/ReserveIds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastoreServer is the server API for Datastore service.
type DatastoreServer interface {
	// Looks up entities by key.
	Lookup(context.Context, *LookupRequest) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(context.Context, *RunQueryRequest) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(context.Context, *AllocateIdsRequest) (*AllocateIdsResponse, error)
	// Prevents the supplied keys' IDs from being auto-allocated by Cloud
	// Datastore.
	ReserveIds(context.Context, *ReserveIdsRequest) (*ReserveIdsResponse, error)
}

// UnimplementedDatastoreServer can be embedded to have forward compatible implementations.
type UnimplementedDatastoreServer struct {
}

func (*UnimplementedDatastoreServer) Lookup(ctx context.Context, req *LookupRequest) (*LookupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Lookup not implemented")
}
func (*UnimplementedDatastoreServer) RunQuery(ctx context.Context, req *RunQueryRequest) (*RunQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunQuery not implemented")
}
func (*UnimplementedDatastoreServer) BeginTransaction(ctx context.Context, req *BeginTransactionRequest) (*BeginTransactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BeginTransaction not implemented")
}
func (*UnimplementedDatastoreServer) Commit(ctx context.Context, req *CommitRequest) (*CommitResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Commit not implemented")
}
func (*UnimplementedDatastoreServer) Rollback(ctx context.Context, req *RollbackRequest) (*RollbackResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rollback not implemented")
}
func (*UnimplementedDatastoreServer) AllocateIds(ctx context.Context, req *AllocateIdsRequest) (*AllocateIdsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AllocateIds not implemented")
}
func (*UnimplementedDatastoreServer) ReserveIds(ctx context.Context, req *ReserveIdsRequest) (*ReserveIdsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReserveIds not implemented")
}

func RegisterDatastoreServer(s *grpc.Server, srv DatastoreServer) {
	s.RegisterService(&_Datastore_serviceDesc, srv)
}

func _Datastore_Lookup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Lookup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Lookup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Lookup(ctx, req.(*LookupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_RunQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).RunQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/RunQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).RunQuery(ctx, req.(*RunQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_AllocateIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocateIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).AllocateIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/AllocateIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).AllocateIds(ctx, req.(*AllocateIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_ReserveIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReserveIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).ReserveIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/ReserveIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).ReserveIds(ctx, req.(*ReserveIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Datastore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.v1.Datastore",
	HandlerType: (*DatastoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Lookup",
			Handler:    _Datastore_Lookup_Handler,
		},
		{
			MethodName: "RunQuery",
			Handler:    _Datastore_RunQuery_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Datastore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Datastore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Datastore_Rollback_Handler,
		},
		{
			MethodName: "AllocateIds",
			Handler:    _Datastore_AllocateIds_Handler,
		},
		{
			MethodName: "ReserveIds",
			Handler:    _Datastore_ReserveIds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/v1/datastore.proto",
}
