package generics

import (
	"go.uber.org/mock/mockgen/internal/tests/generics/other"
	"golang.org/x/exp/constraints"
)

//go:generate mockgen --source=generics.go --destination=source/mock_generics_mock.go --package source
//go:generate mockgen --destination=package_mode/mock_test.go --package=package_mode . Bar,Universe,MilkyWay,SolarSystem,Earth,Water

type Bar[T any, R any] interface {
	One(string) string
	Two(T) string
	Three(T) R
	Four(T) Foo[T, R]
	Five(T) Baz[T]
	Six(T) *Baz[T]
	Seven(T) other.One[T]
	Eight(T) other.Two[T, R]
	Nine(Iface[T])
	Ten(*T)
	Eleven() (*other.One[T], error)
	Twelve() (*other.Two[T, R], error)
	Thirteen() (Baz[StructType], error)
	Fourteen() (*Foo[StructType, StructType2], error)
	Fifteen() (Iface[StructType], error)
	Sixteen() (Baz[other.Three], error)
	Seventeen() (*Foo[other.Three, other.Four], error)
	Eighteen() (Iface[*other.Five], error)
	Nineteen() AliasType
}

type Foo[T any, R any] struct{}

type Baz[T any] struct{}

type Iface[T any] any

type StructType struct{}

type StructType2 struct{}

type AliasType Baz[other.Three]

type Universe[T constraints.Signed] interface {
	MilkyWay[T]
}

type MilkyWay[R constraints.Integer] interface {
	SolarSystem[R]
}

type SolarSystem[T constraints.Ordered] interface {
	Earth[T]
}

type Earth[R any] interface {
	Water(R) []R
}

type Water[R any, C UnsignedInteger] interface {
	Fish(R) []C
}

type UnsignedInteger interface {
	~uint | ~uint32 | ~uint64
}
