/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://discord.gg/8naAwJfWN6
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// ListStoresResponse struct for ListStoresResponse
type ListStoresResponse struct {
	Stores []Store `json:"stores"yaml:"stores"`
	// The continuation token will be empty if there are no more stores.
	ContinuationToken string `json:"continuation_token"yaml:"continuation_token"`
}

// NewListStoresResponse instantiates a new ListStoresResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListStoresResponse(stores []Store, continuationToken string) *ListStoresResponse {
	this := ListStoresResponse{}
	this.Stores = stores
	this.ContinuationToken = continuationToken
	return &this
}

// NewListStoresResponseWithDefaults instantiates a new ListStoresResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListStoresResponseWithDefaults() *ListStoresResponse {
	this := ListStoresResponse{}
	return &this
}

// GetStores returns the Stores field value
func (o *ListStoresResponse) GetStores() []Store {
	if o == nil {
		var ret []Store
		return ret
	}

	return o.Stores
}

// GetStoresOk returns a tuple with the Stores field value
// and a boolean to check if the value has been set.
func (o *ListStoresResponse) GetStoresOk() (*[]Store, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Stores, true
}

// SetStores sets field value
func (o *ListStoresResponse) SetStores(v []Store) {
	o.Stores = v
}

// GetContinuationToken returns the ContinuationToken field value
func (o *ListStoresResponse) GetContinuationToken() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ContinuationToken
}

// GetContinuationTokenOk returns a tuple with the ContinuationToken field value
// and a boolean to check if the value has been set.
func (o *ListStoresResponse) GetContinuationTokenOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ContinuationToken, true
}

// SetContinuationToken sets field value
func (o *ListStoresResponse) SetContinuationToken(v string) {
	o.ContinuationToken = v
}

func (o ListStoresResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["stores"] = o.Stores
	toSerialize["continuation_token"] = o.ContinuationToken
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableListStoresResponse struct {
	value *ListStoresResponse
	isSet bool
}

func (v NullableListStoresResponse) Get() *ListStoresResponse {
	return v.value
}

func (v *NullableListStoresResponse) Set(val *ListStoresResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableListStoresResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableListStoresResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListStoresResponse(val *ListStoresResponse) *NullableListStoresResponse {
	return &NullableListStoresResponse{value: val, isSet: true}
}

func (v NullableListStoresResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListStoresResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
