// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package spark

import original "github.com/Azure/azure-sdk-for-go/services/preview/synapse/2019-11-01-preview/spark"

const (
	DefaultLivyAPIVersion = original.DefaultLivyAPIVersion
)

type BatchJobResultType = original.BatchJobResultType

const (
	Cancelled BatchJobResultType = original.Cancelled
	Failed    BatchJobResultType = original.Failed
	Succeeded BatchJobResultType = original.Succeeded
	Uncertain BatchJobResultType = original.Uncertain
)

type ErrorSource = original.ErrorSource

const (
	Dependency ErrorSource = original.Dependency
	System     ErrorSource = original.System
	Unknown    ErrorSource = original.Unknown
	User       ErrorSource = original.User
)

type JobType = original.JobType

const (
	SparkBatch   JobType = original.SparkBatch
	SparkSession JobType = original.SparkSession
)

type PluginCurrentState = original.PluginCurrentState

const (
	Cleanup             PluginCurrentState = original.Cleanup
	Ended               PluginCurrentState = original.Ended
	Monitoring          PluginCurrentState = original.Monitoring
	Preparation         PluginCurrentState = original.Preparation
	Queued              PluginCurrentState = original.Queued
	ResourceAcquisition PluginCurrentState = original.ResourceAcquisition
	Submission          PluginCurrentState = original.Submission
)

type SchedulerCurrentState = original.SchedulerCurrentState

const (
	SchedulerCurrentStateEnded     SchedulerCurrentState = original.SchedulerCurrentStateEnded
	SchedulerCurrentStateQueued    SchedulerCurrentState = original.SchedulerCurrentStateQueued
	SchedulerCurrentStateScheduled SchedulerCurrentState = original.SchedulerCurrentStateScheduled
)

type SessionResultType = original.SessionResultType

const (
	SessionResultTypeCancelled SessionResultType = original.SessionResultTypeCancelled
	SessionResultTypeFailed    SessionResultType = original.SessionResultTypeFailed
	SessionResultTypeSucceeded SessionResultType = original.SessionResultTypeSucceeded
	SessionResultTypeUncertain SessionResultType = original.SessionResultTypeUncertain
)

type StatementLanguageType = original.StatementLanguageType

const (
	Dotnetspark StatementLanguageType = original.Dotnetspark
	Pyspark     StatementLanguageType = original.Pyspark
	Spark       StatementLanguageType = original.Spark
	SQL         StatementLanguageType = original.SQL
)

type BaseClient = original.BaseClient
type BatchClient = original.BatchClient
type BatchJob = original.BatchJob
type BatchJobCollection = original.BatchJobCollection
type BatchJobOptions = original.BatchJobOptions
type BatchJobState = original.BatchJobState
type Request = original.Request
type Scheduler = original.Scheduler
type ServiceError = original.ServiceError
type ServicePlugin = original.ServicePlugin
type Session = original.Session
type SessionClient = original.SessionClient
type SessionCollection = original.SessionCollection
type SessionOptions = original.SessionOptions
type SessionState = original.SessionState
type Statement = original.Statement
type StatementCancellationResult = original.StatementCancellationResult
type StatementCollection = original.StatementCollection
type StatementOptions = original.StatementOptions
type StatementOutput = original.StatementOutput

func New(endpoint string, sparkPoolName string) BaseClient {
	return original.New(endpoint, sparkPoolName)
}
func NewBatchClient(endpoint string, sparkPoolName string) BatchClient {
	return original.NewBatchClient(endpoint, sparkPoolName)
}
func NewSessionClient(endpoint string, sparkPoolName string) SessionClient {
	return original.NewSessionClient(endpoint, sparkPoolName)
}
func NewWithoutDefaults(endpoint string, sparkPoolName string, livyAPIVersion string) BaseClient {
	return original.NewWithoutDefaults(endpoint, sparkPoolName, livyAPIVersion)
}
func PossibleBatchJobResultTypeValues() []BatchJobResultType {
	return original.PossibleBatchJobResultTypeValues()
}
func PossibleErrorSourceValues() []ErrorSource {
	return original.PossibleErrorSourceValues()
}
func PossibleJobTypeValues() []JobType {
	return original.PossibleJobTypeValues()
}
func PossiblePluginCurrentStateValues() []PluginCurrentState {
	return original.PossiblePluginCurrentStateValues()
}
func PossibleSchedulerCurrentStateValues() []SchedulerCurrentState {
	return original.PossibleSchedulerCurrentStateValues()
}
func PossibleSessionResultTypeValues() []SessionResultType {
	return original.PossibleSessionResultTypeValues()
}
func PossibleStatementLanguageTypeValues() []StatementLanguageType {
	return original.PossibleStatementLanguageTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
