// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package applicationautoscaling provides a client for Application Auto Scaling.
package applicationautoscaling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opDeleteScalingPolicy = "DeleteScalingPolicy"

// DeleteScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteScalingPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteScalingPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteScalingPolicyRequest method.
//    req, resp := client.DeleteScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationAutoScaling) DeleteScalingPolicyRequest(input *DeleteScalingPolicyInput) (req *request.Request, output *DeleteScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteScalingPolicyOutput{}
	req.Data = output
	return
}

// DeleteScalingPolicy API operation for Application Auto Scaling.
//
// Deletes an Application Auto Scaling scaling policy that was previously created.
// If you are no longer using a scaling policy, you can delete it with this
// operation.
//
// Deleting a policy deletes the underlying alarm action, but does not delete
// the CloudWatch alarm associated with the scaling policy, even if it no longer
// has an associated action.
//
// To create a new scaling policy or update an existing one, see PutScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeleteScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ValidationException
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ObjectNotFoundException
//   The specified object could not be found. For any Put or Register API operation,
//   which depends on the existence of a scalable target, this exception is thrown
//   if the scalable target with the specified service namespace, resource ID,
//   and scalable dimension does not exist. For any Delete or Deregister API operation,
//   this exception is thrown if the resource that is to be deleted or deregistered
//   cannot be found.
//
//   * ConcurrentUpdateException
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * InternalServiceException
//   The service encountered an internal error.
//
func (c *ApplicationAutoScaling) DeleteScalingPolicy(input *DeleteScalingPolicyInput) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterScalableTarget = "DeregisterScalableTarget"

// DeregisterScalableTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterScalableTarget operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeregisterScalableTarget for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeregisterScalableTarget method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeregisterScalableTargetRequest method.
//    req, resp := client.DeregisterScalableTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationAutoScaling) DeregisterScalableTargetRequest(input *DeregisterScalableTargetInput) (req *request.Request, output *DeregisterScalableTargetOutput) {
	op := &request.Operation{
		Name:       opDeregisterScalableTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterScalableTargetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterScalableTargetOutput{}
	req.Data = output
	return
}

// DeregisterScalableTarget API operation for Application Auto Scaling.
//
// Deregisters a scalable target that was previously registered. If you are
// no longer using a scalable target, you can delete it with this operation.
// When you deregister a scalable target, all of the scaling policies that are
// associated with that scalable target are deleted.
//
// To create a new scalable target or update an existing one, see RegisterScalableTarget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DeregisterScalableTarget for usage and error information.
//
// Returned Error Codes:
//   * ValidationException
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * ObjectNotFoundException
//   The specified object could not be found. For any Put or Register API operation,
//   which depends on the existence of a scalable target, this exception is thrown
//   if the scalable target with the specified service namespace, resource ID,
//   and scalable dimension does not exist. For any Delete or Deregister API operation,
//   this exception is thrown if the resource that is to be deleted or deregistered
//   cannot be found.
//
//   * ConcurrentUpdateException
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * InternalServiceException
//   The service encountered an internal error.
//
func (c *ApplicationAutoScaling) DeregisterScalableTarget(input *DeregisterScalableTargetInput) (*DeregisterScalableTargetOutput, error) {
	req, out := c.DeregisterScalableTargetRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScalableTargets = "DescribeScalableTargets"

// DescribeScalableTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalableTargets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScalableTargets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScalableTargets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScalableTargetsRequest method.
//    req, resp := client.DescribeScalableTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationAutoScaling) DescribeScalableTargetsRequest(input *DescribeScalableTargetsInput) (req *request.Request, output *DescribeScalableTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeScalableTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalableTargetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalableTargetsOutput{}
	req.Data = output
	return
}

// DescribeScalableTargets API operation for Application Auto Scaling.
//
// Provides descriptive information for scalable targets with a specified service
// namespace.
//
// You can filter the results in a service namespace with the ResourceIds and
// ScalableDimension parameters.
//
// To create a new scalable target or update an existing one, see RegisterScalableTarget.
// If you are no longer using a scalable target, you can deregister it with
// DeregisterScalableTarget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalableTargets for usage and error information.
//
// Returned Error Codes:
//   * ValidationException
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * InvalidNextTokenException
//   The next token supplied was invalid.
//
//   * ConcurrentUpdateException
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * InternalServiceException
//   The service encountered an internal error.
//
func (c *ApplicationAutoScaling) DescribeScalableTargets(input *DescribeScalableTargetsInput) (*DescribeScalableTargetsOutput, error) {
	req, out := c.DescribeScalableTargetsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeScalableTargetsPages iterates over the pages of a DescribeScalableTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalableTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalableTargets operation.
//    pageNum := 0
//    err := client.DescribeScalableTargetsPages(params,
//        func(page *DescribeScalableTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationAutoScaling) DescribeScalableTargetsPages(input *DescribeScalableTargetsInput, fn func(p *DescribeScalableTargetsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScalableTargetsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScalableTargetsOutput), lastPage)
	})
}

const opDescribeScalingActivities = "DescribeScalingActivities"

// DescribeScalingActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingActivities operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScalingActivities for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScalingActivities method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScalingActivitiesRequest method.
//    req, resp := client.DescribeScalingActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationAutoScaling) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) (req *request.Request, output *DescribeScalingActivitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingActivitiesOutput{}
	req.Data = output
	return
}

// DescribeScalingActivities API operation for Application Auto Scaling.
//
// Provides descriptive information for scaling activities with a specified
// service namespace for the previous six weeks.
//
// You can filter the results in a service namespace with the ResourceId and
// ScalableDimension parameters.
//
// Scaling activities are triggered by CloudWatch alarms that are associated
// with scaling policies. To view the existing scaling policies for a service
// namespace, see DescribeScalingPolicies. To create a new scaling policy or
// update an existing one, see PutScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalingActivities for usage and error information.
//
// Returned Error Codes:
//   * ValidationException
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * InvalidNextTokenException
//   The next token supplied was invalid.
//
//   * ConcurrentUpdateException
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * InternalServiceException
//   The service encountered an internal error.
//
func (c *ApplicationAutoScaling) DescribeScalingActivities(input *DescribeScalingActivitiesInput) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeScalingActivitiesPages iterates over the pages of a DescribeScalingActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalingActivities operation.
//    pageNum := 0
//    err := client.DescribeScalingActivitiesPages(params,
//        func(page *DescribeScalingActivitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationAutoScaling) DescribeScalingActivitiesPages(input *DescribeScalingActivitiesInput, fn func(p *DescribeScalingActivitiesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScalingActivitiesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScalingActivitiesOutput), lastPage)
	})
}

const opDescribeScalingPolicies = "DescribeScalingPolicies"

// DescribeScalingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScalingPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScalingPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScalingPoliciesRequest method.
//    req, resp := client.DescribeScalingPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationAutoScaling) DescribeScalingPoliciesRequest(input *DescribeScalingPoliciesInput) (req *request.Request, output *DescribeScalingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingPoliciesOutput{}
	req.Data = output
	return
}

// DescribeScalingPolicies API operation for Application Auto Scaling.
//
// Provides descriptive information for scaling policies with a specified service
// namespace.
//
// You can filter the results in a service namespace with the ResourceId, ScalableDimension,
// and PolicyNames parameters.
//
// To create a new scaling policy or update an existing one, see PutScalingPolicy.
// If you are no longer using a scaling policy, you can delete it with DeleteScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation DescribeScalingPolicies for usage and error information.
//
// Returned Error Codes:
//   * ValidationException
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * FailedResourceAccessException
//   Failed access to resources caused an exception. This exception currently
//   only applies to DescribeScalingPolicies. It is thrown when Application Auto
//   Scaling is unable to retrieve the alarms associated with a scaling policy
//   due to a client error, for example, if the role ARN specified for a scalable
//   target does not have the proper permissions to call the CloudWatch DescribeAlarms
//   (http://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarms.html)
//   API operation on behalf of your account.
//
//   * InvalidNextTokenException
//   The next token supplied was invalid.
//
//   * ConcurrentUpdateException
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * InternalServiceException
//   The service encountered an internal error.
//
func (c *ApplicationAutoScaling) DescribeScalingPolicies(input *DescribeScalingPoliciesInput) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeScalingPoliciesPages iterates over the pages of a DescribeScalingPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalingPolicies operation.
//    pageNum := 0
//    err := client.DescribeScalingPoliciesPages(params,
//        func(page *DescribeScalingPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ApplicationAutoScaling) DescribeScalingPoliciesPages(input *DescribeScalingPoliciesInput, fn func(p *DescribeScalingPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScalingPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScalingPoliciesOutput), lastPage)
	})
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutScalingPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutScalingPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutScalingPolicyRequest method.
//    req, resp := client.PutScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationAutoScaling) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutScalingPolicyOutput{}
	req.Data = output
	return
}

// PutScalingPolicy API operation for Application Auto Scaling.
//
// Creates or updates a policy for an existing Application Auto Scaling scalable
// target. Each scalable target is identified by service namespace, a resource
// ID, and a scalable dimension, and a scaling policy applies to a scalable
// target that is identified by those three attributes. You cannot create a
// scaling policy without first registering a scalable target with RegisterScalableTarget.
//
// To update an existing policy, use the existing policy name and set the parameters
// you want to change. Any existing parameter not changed in an update to an
// existing policy is not changed in this update request.
//
// You can view the existing scaling policies for a service namespace with DescribeScalingPolicies.
// If you are no longer using a scaling policy, you can delete it with DeleteScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ValidationException
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * LimitExceededException
//   Your account exceeded a limit. This exception is thrown when a per-account
//   resource limit is exceeded. For more information, see Application Auto Scaling
//   Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_as-app).
//
//   * ObjectNotFoundException
//   The specified object could not be found. For any Put or Register API operation,
//   which depends on the existence of a scalable target, this exception is thrown
//   if the scalable target with the specified service namespace, resource ID,
//   and scalable dimension does not exist. For any Delete or Deregister API operation,
//   this exception is thrown if the resource that is to be deleted or deregistered
//   cannot be found.
//
//   * ConcurrentUpdateException
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * InternalServiceException
//   The service encountered an internal error.
//
func (c *ApplicationAutoScaling) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterScalableTarget = "RegisterScalableTarget"

// RegisterScalableTargetRequest generates a "aws/request.Request" representing the
// client's request for the RegisterScalableTarget operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterScalableTarget for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterScalableTarget method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterScalableTargetRequest method.
//    req, resp := client.RegisterScalableTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ApplicationAutoScaling) RegisterScalableTargetRequest(input *RegisterScalableTargetInput) (req *request.Request, output *RegisterScalableTargetOutput) {
	op := &request.Operation{
		Name:       opRegisterScalableTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterScalableTargetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterScalableTargetOutput{}
	req.Data = output
	return
}

// RegisterScalableTarget API operation for Application Auto Scaling.
//
// Registers or updates a scalable target. A scalable target is a resource that
// can be scaled out or in with Application Auto Scaling. After you have registered
// a scalable target, you can use this operation to update the minimum and maximum
// values for your scalable dimension.
//
// After you register a scalable target with Application Auto Scaling, you can
// create and apply scaling policies to it with PutScalingPolicy. You can view
// the existing scaling policies for a service namespace with DescribeScalableTargets.
// If you are no longer using a scalable target, you can deregister it with
// DeregisterScalableTarget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Auto Scaling's
// API operation RegisterScalableTarget for usage and error information.
//
// Returned Error Codes:
//   * ValidationException
//   An exception was thrown for a validation issue. Review the available parameters
//   for the API request.
//
//   * LimitExceededException
//   Your account exceeded a limit. This exception is thrown when a per-account
//   resource limit is exceeded. For more information, see Application Auto Scaling
//   Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_as-app).
//
//   * ConcurrentUpdateException
//   Concurrent updates caused an exception, for example, if you request an update
//   to an Application Auto Scaling resource that already has a pending update.
//
//   * InternalServiceException
//   The service encountered an internal error.
//
func (c *ApplicationAutoScaling) RegisterScalableTarget(input *RegisterScalableTargetInput) (*RegisterScalableTargetOutput, error) {
	req, out := c.RegisterScalableTargetRequest(input)
	err := req.Send()
	return out, err
}

// An object representing a CloudWatch alarm associated with a scaling policy.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	//
	// AlarmARN is a required field
	AlarmARN *string `type:"string" required:"true"`

	// The name of the alarm.
	//
	// AlarmName is a required field
	AlarmName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

type DeleteScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy to delete.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The resource type and unique identifier string for the resource associated
	// with the scaling policy. For Amazon ECS services, the resource type is services,
	// and the identifier is the cluster name and service name; for example, service/default/sample-webapp.
	// For Amazon EC2 Spot fleet requests, the resource type is spot-fleet-request,
	// and the identifier is the Spot fleet request ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scaling policy. The scalable dimension
	// contains the service namespace, resource type, and scaling property, such
	// as ecs:service:DesiredCount for the desired task count of an Amazon ECS service,
	// or ec2:spot-fleet-request:TargetCapacity for the target capacity of an Amazon
	// EC2 Spot fleet request.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scaling policy is associated with.
	// For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DeleteScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyOutput) GoString() string {
	return s.String()
}

type DeregisterScalableTargetInput struct {
	_ struct{} `type:"structure"`

	// The resource type and unique identifier string for the resource associated
	// with the scalable target. For Amazon ECS services, the resource type is services,
	// and the identifier is the cluster name and service name; for example, service/default/sample-webapp.
	// For Amazon EC2 Spot fleet requests, the resource type is spot-fleet-request,
	// and the identifier is the Spot fleet request ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scalable target. The scalable
	// dimension contains the service namespace, resource type, and scaling property,
	// such as ecs:service:DesiredCount for the desired task count of an Amazon
	// ECS service, or ec2:spot-fleet-request:TargetCapacity for the target capacity
	// of an Amazon EC2 Spot fleet request.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scalable target is associated
	// with. For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DeregisterScalableTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterScalableTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterScalableTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterScalableTargetInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterScalableTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterScalableTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterScalableTargetOutput) GoString() string {
	return s.String()
}

type DescribeScalableTargetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable target results returned by DescribeScalableTargets
	// in paginated output. When this parameter is used, DescribeScalableTargets
	// returns up to MaxResults results in a single page along with a NextToken
	// response element. The remaining results of the initial request can be seen
	// by sending another DescribeScalableTargets request with the returned NextToken
	// value. This value can be between 1 and 50. If this parameter is not used,
	// then DescribeScalableTargets returns up to 50 results and a NextToken value,
	// if applicable.
	MaxResults *int64 `type:"integer"`

	// The NextToken value returned from a previous paginated DescribeScalableTargets
	// request. Pagination continues from the end of the previous results that returned
	// the NextToken value. This value is null when there are no more results to
	// return.
	NextToken *string `type:"string"`

	// The resource type and unique identifier string for the resource associated
	// with the scalable target. For Amazon ECS services, the resource type is services,
	// and the identifier is the cluster name and service name; for example, service/default/sample-webapp.
	// For Amazon EC2 Spot fleet requests, the resource type is spot-fleet-request,
	// and the identifier is the Spot fleet request ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	// If you specify a scalable dimension, you must also specify a resource ID.
	ResourceIds []*string `type:"list"`

	// The scalable dimension associated with the scalable target. The scalable
	// dimension contains the service namespace, resource type, and scaling property,
	// such as ecs:service:DesiredCount for the desired task count of an Amazon
	// ECS service, or ec2:spot-fleet-request:TargetCapacity for the target capacity
	// of an Amazon EC2 Spot fleet request. If you specify a scalable dimension,
	// you must also specify a resource ID.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scalable target is associated
	// with. For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DescribeScalableTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalableTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalableTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalableTargetsInput"}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeScalableTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a future DescribeScalableTargets request.
	// When the results of a DescribeScalableTargets request exceed MaxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `type:"string"`

	// The list of scalable targets that matches the request parameters.
	ScalableTargets []*ScalableTarget `type:"list"`
}

// String returns the string representation
func (s DescribeScalableTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalableTargetsOutput) GoString() string {
	return s.String()
}

type DescribeScalingActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scaling activity results returned by DescribeScalingActivities
	// in paginated output. When this parameter is used, DescribeScalingActivities
	// returns up to MaxResults results in a single page along with a NextToken
	// response element. The remaining results of the initial request can be seen
	// by sending another DescribeScalingActivities request with the returned NextToken
	// value. This value can be between 1 and 50. If this parameter is not used,
	// then DescribeScalingActivities returns up to 50 results and a NextToken value,
	// if applicable.
	MaxResults *int64 `type:"integer"`

	// The NextToken value returned from a previous paginated DescribeScalingActivities
	// request. Pagination continues from the end of the previous results that returned
	// the NextToken value. This value is null when there are no more results to
	// return.
	NextToken *string `type:"string"`

	// The resource type and unique identifier string for the resource associated
	// with the scaling activity. For Amazon ECS services, the resource type is
	// services, and the identifier is the cluster name and service name; for example,
	// service/default/sample-webapp. For Amazon EC2 Spot fleet requests, the resource
	// type is spot-fleet-request, and the identifier is the Spot fleet request
	// ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	// If you specify a scalable dimension, you must also specify a resource ID.
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension associated with the scaling activity. The scalable
	// dimension contains the service namespace, resource type, and scaling property,
	// such as ecs:service:DesiredCount for the desired task count of an Amazon
	// ECS service, or ec2:spot-fleet-request:TargetCapacity for the target capacity
	// of an Amazon EC2 Spot fleet request. If you specify a scalable dimension,
	// you must also specify a resource ID.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scaling activity is associated
	// with. For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DescribeScalingActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingActivitiesInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeScalingActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a future DescribeScalingActivities request.
	// When the results of a DescribeScalingActivities request exceed MaxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `type:"string"`

	// A list of scaling activity objects.
	ScalingActivities []*ScalingActivity `type:"list"`
}

// String returns the string representation
func (s DescribeScalingActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesOutput) GoString() string {
	return s.String()
}

type DescribeScalingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scaling policy results returned by DescribeScalingPolicies
	// in paginated output. When this parameter is used, DescribeScalingPolicies
	// returns up to MaxResults results in a single page along with a NextToken
	// response element. The remaining results of the initial request can be seen
	// by sending another DescribeScalingPolicies request with the returned NextToken
	// value. This value can be between 1 and 50. If this parameter is not used,
	// then DescribeScalingPolicies returns up to 50 results and a NextToken value,
	// if applicable.
	MaxResults *int64 `type:"integer"`

	// The NextToken value returned from a previous paginated DescribeScalingPolicies
	// request. Pagination continues from the end of the previous results that returned
	// the NextToken value. This value is null when there are no more results to
	// return.
	NextToken *string `type:"string"`

	// The names of the scaling policies to describe.
	PolicyNames []*string `type:"list"`

	// The unique resource identifier string of the scalable target that the scaling
	// policy is associated with. For Amazon ECS services, the resource type is
	// services, and the identifier is the cluster name and service name; for example,
	// service/default/sample-webapp. For Amazon EC2 Spot fleet requests, the resource
	// type is spot-fleet-request, and the identifier is the Spot fleet request
	// ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	// If you specify a scalable dimension, you must also specify a resource ID.
	ResourceId *string `min:"1" type:"string"`

	// The scalable dimension of the scalable target that the scaling policy is
	// associated with. The scalable dimension contains the service namespace, resource
	// type, and scaling property, such as ecs:service:DesiredCount for the desired
	// task count of an Amazon ECS service, or ec2:spot-fleet-request:TargetCapacity
	// for the target capacity of an Amazon EC2 Spot fleet request. If you specify
	// a scalable dimension, you must also specify a resource ID.
	ScalableDimension *string `type:"string" enum:"ScalableDimension"`

	// The AWS service namespace of the scalable target that the scaling policy
	// is associated with. For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s DescribeScalingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPoliciesInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeScalingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a future DescribeScalingPolicies request.
	// When the results of a DescribeScalingPolicies request exceed MaxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `type:"string"`

	// A list of scaling policy objects.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesOutput) GoString() string {
	return s.String()
}

type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The policy type. If you are creating a new policy, this parameter is required.
	// If you are updating an existing policy, this parameter is not required.
	PolicyType *string `type:"string" enum:"PolicyType"`

	// The unique resource identifier string for the scalable target that this scaling
	// policy applies to. For Amazon ECS services, the resource type is services,
	// and the identifier is the cluster name and service name; for example, service/default/sample-webapp.
	// For Amazon EC2 Spot fleet requests, the resource type is spot-fleet-request,
	// and the identifier is the Spot fleet request ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension of the scalable target that this scaling policy applies
	// to. The scalable dimension contains the service namespace, resource type,
	// and scaling property, such as ecs:service:DesiredCount for the desired task
	// count of an Amazon ECS service, or ec2:spot-fleet-request:TargetCapacity
	// for the target capacity of an Amazon EC2 Spot fleet request.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The AWS service namespace of the scalable target that this scaling policy
	// applies to. For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The configuration for the step scaling policy. If you are creating a new
	// policy, this parameter is required. If you are updating an existing policy,
	// this parameter is not required. For more information, see StepScalingPolicyConfiguration
	// and StepAdjustment.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}
	if s.StepScalingPolicyConfiguration != nil {
		if err := s.StepScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StepScalingPolicyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resulting scaling policy.
	//
	// PolicyARN is a required field
	PolicyARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

type RegisterScalableTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum value for this scalable target to scale out to in response to
	// scaling activities. This parameter is required if you are registering a new
	// scalable target, and it is optional if you are updating an existing one.
	MaxCapacity *int64 `type:"integer"`

	// The minimum value for this scalable target to scale in to in response to
	// scaling activities. This parameter is required if you are registering a new
	// scalable target, and it is optional if you are updating an existing one.
	MinCapacity *int64 `type:"integer"`

	// The resource type and unique identifier string for the resource to associate
	// with the scalable target. For Amazon ECS services, the resource type is services,
	// and the identifier is the cluster name and service name; for example, service/default/sample-webapp.
	// For Amazon EC2 Spot fleet requests, the resource type is spot-fleet-request,
	// and the identifier is the Spot fleet request ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that allows Application Auto Scaling to modify your
	// scalable target on your behalf. This parameter is required if you are registering
	// a new scalable target, and it is optional if you are updating an existing
	// one.
	RoleARN *string `min:"1" type:"string"`

	// The scalable dimension associated with the scalable target. The scalable
	// dimension contains the service namespace, resource type, and scaling property,
	// such as ecs:service:DesiredCount for the desired task count of an Amazon
	// ECS service, or ec2:spot-fleet-request:TargetCapacity for the target capacity
	// of an Amazon EC2 Spot fleet request.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scalable target is associated
	// with. For Amazon ECS services, the namespace value is ecs. For more information,
	// see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s RegisterScalableTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterScalableTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterScalableTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterScalableTargetInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterScalableTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterScalableTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterScalableTargetOutput) GoString() string {
	return s.String()
}

// An object representing a scalable target.
type ScalableTarget struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for when the scalable target was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The maximum value for this scalable target to scale out to in response to
	// scaling activities.
	//
	// MaxCapacity is a required field
	MaxCapacity *int64 `type:"integer" required:"true"`

	// The minimum value for this scalable target to scale in to in response to
	// scaling activities.
	//
	// MinCapacity is a required field
	MinCapacity *int64 `type:"integer" required:"true"`

	// The resource type and unique identifier string for the resource associated
	// with the scalable target. For Amazon ECS services, the resource type is services,
	// and the identifier is the cluster name and service name; for example, service/default/sample-webapp.
	// For Amazon EC2 Spot fleet requests, the resource type is spot-fleet-request,
	// and the identifier is the Spot fleet request ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that allows Application Auto Scaling to modify your
	// scalable target on your behalf.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scalable target. The scalable
	// dimension contains the service namespace, resource type, and scaling property,
	// such as ecs:service:DesiredCount for the desired task count of an Amazon
	// ECS service, or ec2:spot-fleet-request:TargetCapacity for the target capacity
	// of an Amazon EC2 Spot fleet request.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scalable target is associated
	// with. For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s ScalableTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalableTarget) GoString() string {
	return s.String()
}

// An object representing a scaling activity.
type ScalingActivity struct {
	_ struct{} `type:"structure"`

	// The unique identifier string for the scaling activity.
	//
	// ActivityId is a required field
	ActivityId *string `type:"string" required:"true"`

	// A simple description of what caused the scaling activity to happen.
	//
	// Cause is a required field
	Cause *string `type:"string" required:"true"`

	// A simple description of what action the scaling activity intends to accomplish.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The details about the scaling activity.
	Details *string `type:"string"`

	// The Unix timestamp for when the scaling activity ended.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The resource type and unique identifier string for the resource associated
	// with the scaling activity. For Amazon ECS services, the resource type is
	// services, and the identifier is the cluster name and service name; for example,
	// service/default/sample-webapp. For Amazon EC2 Spot fleet requests, the resource
	// type is spot-fleet-request, and the identifier is the Spot fleet request
	// ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scaling activity. The scalable
	// dimension contains the service namespace, resource type, and scaling property,
	// such as ecs:service:DesiredCount for the desired task count of an Amazon
	// ECS service, or ec2:spot-fleet-request:TargetCapacity for the target capacity
	// of an Amazon EC2 Spot fleet request.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scaling activity is associated
	// with. For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The Unix timestamp for when the scaling activity began.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Indicates the status of the scaling activity.
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true" enum:"ScalingActivityStatusCode"`

	// A simple message about the current status of the scaling activity.
	StatusMessage *string `type:"string"`
}

// String returns the string representation
func (s ScalingActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingActivity) GoString() string {
	return s.String()
}

// An object representing a scaling policy.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms that are associated with the scaling policy.
	Alarms []*Alarm `type:"list"`

	// The Unix timestamp for when the scaling policy was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The Amazon Resource Name (ARN) of the scaling policy.
	//
	// PolicyARN is a required field
	PolicyARN *string `min:"1" type:"string" required:"true"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The scaling policy type.
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The resource type and unique identifier string for the resource associated
	// with the scaling policy. For Amazon ECS services, the resource type is services,
	// and the identifier is the cluster name and service name; for example, service/default/sample-webapp.
	// For Amazon EC2 Spot fleet requests, the resource type is spot-fleet-request,
	// and the identifier is the Spot fleet request ID; for example, spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the scaling policy. The scalable dimension
	// contains the service namespace, resource type, and scaling property, such
	// as ecs:service:DesiredCount for the desired task count of an Amazon ECS service,
	// or ec2:spot-fleet-request:TargetCapacity for the target capacity of an Amazon
	// EC2 Spot fleet request.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The namespace for the AWS service that the scaling policy is associated with.
	// For more information, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the Amazon Web Services General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The configuration for the step scaling policy.
	StepScalingPolicyConfiguration *StepScalingPolicyConfiguration `type:"structure"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// An object representing a step adjustment for a StepScalingPolicyConfiguration.
// Describes an adjustment based on the difference between the value of the
// aggregated CloudWatch metric and the breach threshold that you've defined
// for the alarm.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//    * If you want the adjustment to be triggered when the metric is greater
//    than or equal to 50 and less than 60, specify a lower bound of 0 and an
//    upper bound of 10.
//
//    * If you want the adjustment to be triggered when the metric is greater
//    than 40 and less than or equal to 50, specify a lower bound of -10 and
//    an upper bound of 0.
//
// There are a few rules for the step adjustments for your step policy:
//
//    * The ranges of your step adjustments can't overlap or have a gap.
//
//    * At most one step adjustment can have a null lower bound. If one step
//    adjustment has a negative lower bound, then there must be a step adjustment
//    with a null lower bound.
//
//    * At most one step adjustment can have a null upper bound. If one step
//    adjustment has a positive upper bound, then there must be a step adjustment
//    with a null upper bound.
//
//    * The upper and lower bound can't be null in the same step adjustment.
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current scalable dimension while a negative number removes
	// from the current scalable dimension.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepAdjustment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAdjustment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepAdjustment"}
	if s.ScalingAdjustment == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object representing a step scaling policy configuration.
type StepScalingPolicyConfiguration struct {
	_ struct{} `type:"structure"`

	// The adjustment type, which specifies how the ScalingAdjustment parameter
	// in a StepAdjustment is interpreted.
	AdjustmentType *string `type:"string" enum:"AdjustmentType"`

	// The amount of time, in seconds, after a scaling activity completes where
	// previous trigger-related scaling activities can influence future scaling
	// events.
	//
	// For scale out policies, while Cooldown is in effect, the capacity that has
	// been added by the previous scale out event that initiated the Cooldown is
	// calculated as part of the desired capacity for the next scale out. The intention
	// is to continuously (but not excessively) scale out. For example, an alarm
	// triggers a step scaling policy to scale out an Amazon ECS service by 2 tasks,
	// the scaling activity completes successfully, and a Cooldown period of 5 minutes
	// starts. During the Cooldown period, if the alarm triggers the same policy
	// again but at a more aggressive step adjustment to scale out the service by
	// 3 tasks, the 2 tasks that were added in the previous scale out event are
	// considered part of that capacity and only 1 additional task is added to the
	// desired count.
	//
	// For scale in policies, the Cooldown period is used to block subsequent scale
	// in requests until it has expired. The intention is to scale in conservatively
	// to protect your application's availability. However, if another alarm triggers
	// a scale out policy during the Cooldown period after a scale-in, Application
	// Auto Scaling scales out your scalable target immediately.
	Cooldown *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum,
	// Maximum, and Average.
	MetricAggregationType *string `type:"string" enum:"MetricAggregationType"`

	// The minimum number to adjust your scalable dimension as a result of a scaling
	// activity. If the adjustment type is PercentChangeInCapacity, the scaling
	// policy changes the scalable dimension of the scalable target by this amount.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []*StepAdjustment `type:"list"`
}

// String returns the string representation
func (s StepScalingPolicyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepScalingPolicyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepScalingPolicyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepScalingPolicyConfiguration"}
	if s.StepAdjustments != nil {
		for i, v := range s.StepAdjustments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StepAdjustments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

const (
	// AdjustmentTypeChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypeChangeInCapacity = "ChangeInCapacity"

	// AdjustmentTypePercentChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypePercentChangeInCapacity = "PercentChangeInCapacity"

	// AdjustmentTypeExactCapacity is a AdjustmentType enum value
	AdjustmentTypeExactCapacity = "ExactCapacity"
)

const (
	// MetricAggregationTypeAverage is a MetricAggregationType enum value
	MetricAggregationTypeAverage = "Average"

	// MetricAggregationTypeMinimum is a MetricAggregationType enum value
	MetricAggregationTypeMinimum = "Minimum"

	// MetricAggregationTypeMaximum is a MetricAggregationType enum value
	MetricAggregationTypeMaximum = "Maximum"
)

const (
	// PolicyTypeStepScaling is a PolicyType enum value
	PolicyTypeStepScaling = "StepScaling"
)

const (
	// ScalableDimensionEcsServiceDesiredCount is a ScalableDimension enum value
	ScalableDimensionEcsServiceDesiredCount = "ecs:service:DesiredCount"

	// ScalableDimensionEc2SpotFleetRequestTargetCapacity is a ScalableDimension enum value
	ScalableDimensionEc2SpotFleetRequestTargetCapacity = "ec2:spot-fleet-request:TargetCapacity"
)

const (
	// ScalingActivityStatusCodePending is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodePending = "Pending"

	// ScalingActivityStatusCodeInProgress is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeInProgress = "InProgress"

	// ScalingActivityStatusCodeSuccessful is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeSuccessful = "Successful"

	// ScalingActivityStatusCodeOverridden is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeOverridden = "Overridden"

	// ScalingActivityStatusCodeUnfulfilled is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeUnfulfilled = "Unfulfilled"

	// ScalingActivityStatusCodeFailed is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeFailed = "Failed"
)

const (
	// ServiceNamespaceEcs is a ServiceNamespace enum value
	ServiceNamespaceEcs = "ecs"

	// ServiceNamespaceEc2 is a ServiceNamespace enum value
	ServiceNamespaceEc2 = "ec2"
)
