// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package kms provides a client for AWS Key Management Service.
package kms

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCancelKeyDeletion = "CancelKeyDeletion"

// CancelKeyDeletionRequest generates a request for the CancelKeyDeletion operation.
func (c *KMS) CancelKeyDeletionRequest(input *CancelKeyDeletionInput) (req *request.Request, output *CancelKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opCancelKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelKeyDeletionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelKeyDeletionOutput{}
	req.Data = output
	return
}

// Cancels the deletion of a customer master key (CMK). When this operation
// is successful, the CMK is set to the Disabled state. To enable a CMK, use
// EnableKey.
//
// For more information about scheduling and canceling deletion of a CMK, go
// to Deleting Customer Master Keys (http://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
// in the AWS Key Management Service Developer Guide.
func (c *KMS) CancelKeyDeletion(input *CancelKeyDeletionInput) (*CancelKeyDeletionOutput, error) {
	req, out := c.CancelKeyDeletionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a request for the CreateAlias operation.
func (c *KMS) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAliasOutput{}
	req.Data = output
	return
}

// Creates a display name for a customer master key. An alias can be used to
// identify a key and should be unique. The console enforces a one-to-one mapping
// between the alias and a key. An alias name can contain only alphanumeric
// characters, forward slashes (/), underscores (_), and dashes (-). An alias
// must start with the word "alias" followed by a forward slash (alias/). An
// alias that begins with "aws" after the forward slash (alias/aws...) is reserved
// by Amazon Web Services (AWS).
//
// The alias and the key it is mapped to must be in the same AWS account and
// the same region.
//
// To map an alias to a different key, call UpdateAlias.
func (c *KMS) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateGrant = "CreateGrant"

// CreateGrantRequest generates a request for the CreateGrant operation.
func (c *KMS) CreateGrantRequest(input *CreateGrantInput) (req *request.Request, output *CreateGrantOutput) {
	op := &request.Operation{
		Name:       opCreateGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateGrantOutput{}
	req.Data = output
	return
}

// Adds a grant to a key to specify who can use the key and under what conditions.
// Grants are alternate permission mechanisms to key policies.
//
// For more information about grants, see Grants (http://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the AWS Key Management Service Developer Guide.
func (c *KMS) CreateGrant(input *CreateGrantInput) (*CreateGrantOutput, error) {
	req, out := c.CreateGrantRequest(input)
	err := req.Send()
	return out, err
}

const opCreateKey = "CreateKey"

// CreateKeyRequest generates a request for the CreateKey operation.
func (c *KMS) CreateKeyRequest(input *CreateKeyInput) (req *request.Request, output *CreateKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateKeyOutput{}
	req.Data = output
	return
}

// Creates a customer master key. Customer master keys can be used to encrypt
// small amounts of data (less than 4K) directly, but they are most commonly
// used to encrypt or envelope data keys that are then used to encrypt customer
// data. For more information about data keys, see GenerateDataKey and GenerateDataKeyWithoutPlaintext.
func (c *KMS) CreateKey(input *CreateKeyInput) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDecrypt = "Decrypt"

// DecryptRequest generates a request for the Decrypt operation.
func (c *KMS) DecryptRequest(input *DecryptInput) (req *request.Request, output *DecryptOutput) {
	op := &request.Operation{
		Name:       opDecrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DecryptOutput{}
	req.Data = output
	return
}

// Decrypts ciphertext. Ciphertext is plaintext that has been previously encrypted
// by using any of the following functions:  GenerateDataKey GenerateDataKeyWithoutPlaintext
// Encrypt
//
// Note that if a caller has been granted access permissions to all keys (through,
// for example, IAM user policies that grant Decrypt permission on all resources),
// then ciphertext encrypted by using keys in other accounts where the key grants
// access to the caller can be decrypted. To remedy this, we recommend that
// you do not grant Decrypt access in an IAM user policy. Instead grant Decrypt
// access only in key policies. If you must grant Decrypt access in an IAM user
// policy, you should scope the resource to specific keys or to specific trusted
// accounts.
func (c *KMS) Decrypt(input *DecryptInput) (*DecryptOutput, error) {
	req, out := c.DecryptRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a request for the DeleteAlias operation.
func (c *KMS) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAliasOutput{}
	req.Data = output
	return
}

// Deletes the specified alias. To map an alias to a different key, call UpdateAlias.
func (c *KMS) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeKey = "DescribeKey"

// DescribeKeyRequest generates a request for the DescribeKey operation.
func (c *KMS) DescribeKeyRequest(input *DescribeKeyInput) (req *request.Request, output *DescribeKeyOutput) {
	op := &request.Operation{
		Name:       opDescribeKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeKeyOutput{}
	req.Data = output
	return
}

// Provides detailed information about the specified customer master key.
func (c *KMS) DescribeKey(input *DescribeKeyInput) (*DescribeKeyOutput, error) {
	req, out := c.DescribeKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDisableKey = "DisableKey"

// DisableKeyRequest generates a request for the DisableKey operation.
func (c *KMS) DisableKeyRequest(input *DisableKeyInput) (req *request.Request, output *DisableKeyOutput) {
	op := &request.Operation{
		Name:       opDisableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableKeyOutput{}
	req.Data = output
	return
}

// Sets the state of a master key to disabled, thereby preventing its use for
// cryptographic operations. For more information about how key state affects
// the use of a master key, go to How Key State Affects the Use of a Customer
// Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
func (c *KMS) DisableKey(input *DisableKeyInput) (*DisableKeyOutput, error) {
	req, out := c.DisableKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDisableKeyRotation = "DisableKeyRotation"

// DisableKeyRotationRequest generates a request for the DisableKeyRotation operation.
func (c *KMS) DisableKeyRotationRequest(input *DisableKeyRotationInput) (req *request.Request, output *DisableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opDisableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyRotationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableKeyRotationOutput{}
	req.Data = output
	return
}

// Disables rotation of the specified key.
func (c *KMS) DisableKeyRotation(input *DisableKeyRotationInput) (*DisableKeyRotationOutput, error) {
	req, out := c.DisableKeyRotationRequest(input)
	err := req.Send()
	return out, err
}

const opEnableKey = "EnableKey"

// EnableKeyRequest generates a request for the EnableKey operation.
func (c *KMS) EnableKeyRequest(input *EnableKeyInput) (req *request.Request, output *EnableKeyOutput) {
	op := &request.Operation{
		Name:       opEnableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableKeyOutput{}
	req.Data = output
	return
}

// Marks a key as enabled, thereby permitting its use.
func (c *KMS) EnableKey(input *EnableKeyInput) (*EnableKeyOutput, error) {
	req, out := c.EnableKeyRequest(input)
	err := req.Send()
	return out, err
}

const opEnableKeyRotation = "EnableKeyRotation"

// EnableKeyRotationRequest generates a request for the EnableKeyRotation operation.
func (c *KMS) EnableKeyRotationRequest(input *EnableKeyRotationInput) (req *request.Request, output *EnableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opEnableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyRotationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableKeyRotationOutput{}
	req.Data = output
	return
}

// Enables rotation of the specified customer master key.
func (c *KMS) EnableKeyRotation(input *EnableKeyRotationInput) (*EnableKeyRotationOutput, error) {
	req, out := c.EnableKeyRotationRequest(input)
	err := req.Send()
	return out, err
}

const opEncrypt = "Encrypt"

// EncryptRequest generates a request for the Encrypt operation.
func (c *KMS) EncryptRequest(input *EncryptInput) (req *request.Request, output *EncryptOutput) {
	op := &request.Operation{
		Name:       opEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EncryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EncryptOutput{}
	req.Data = output
	return
}

// Encrypts plaintext into ciphertext by using a customer master key. The Encrypt
// function has two primary use cases:  You can encrypt up to 4 KB of arbitrary
// data such as an RSA key, a database password, or other sensitive customer
// information. If you are moving encrypted data from one region to another,
// you can use this API to encrypt in the new region the plaintext data key
// that was used to encrypt the data in the original region. This provides you
// with an encrypted copy of the data key that can be decrypted in the new region
// and used there to decrypt the encrypted data.
//
// Unless you are moving encrypted data from one region to another, you don't
// use this function to encrypt a generated data key within a region. You retrieve
// data keys already encrypted by calling the GenerateDataKey or GenerateDataKeyWithoutPlaintext
// function. Data keys don't need to be encrypted again by calling Encrypt.
//
// If you want to encrypt data locally in your application, you can use the
// GenerateDataKey function to return a plaintext data encryption key and a
// copy of the key encrypted under the customer master key (CMK) of your choosing.
func (c *KMS) Encrypt(input *EncryptInput) (*EncryptOutput, error) {
	req, out := c.EncryptRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateDataKey = "GenerateDataKey"

// GenerateDataKeyRequest generates a request for the GenerateDataKey operation.
func (c *KMS) GenerateDataKeyRequest(input *GenerateDataKeyInput) (req *request.Request, output *GenerateDataKeyOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateDataKeyOutput{}
	req.Data = output
	return
}

// Generates a data key that you can use in your application to locally encrypt
// data. This call returns a plaintext version of the key in the Plaintext field
// of the response object and an encrypted copy of the key in the CiphertextBlob
// field. The key is encrypted by using the master key specified by the KeyId
// field. To decrypt the encrypted key, pass it to the Decrypt API.
//
// We recommend that you use the following pattern to locally encrypt data:
// call the GenerateDataKey API, use the key returned in the Plaintext response
// field to locally encrypt data, and then erase the plaintext data key from
// memory. Store the encrypted data key (contained in the CiphertextBlob field)
// alongside of the locally encrypted data.
//
// You should not call the Encrypt function to re-encrypt your data keys within
// a region. GenerateDataKey always returns the data key encrypted and tied
// to the customer master key that will be used to decrypt it. There is no need
// to decrypt it twice.  If you decide to use the optional EncryptionContext
// parameter, you must also store the context in full or at least store enough
// information along with the encrypted data to be able to reconstruct the context
// when submitting the ciphertext to the Decrypt API. It is a good practice
// to choose a context that you can reconstruct on the fly to better secure
// the ciphertext. For more information about how this parameter is used, see
// Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html).
//
// To decrypt data, pass the encrypted data key to the Decrypt API. Decrypt
// uses the associated master key to decrypt the encrypted data key and returns
// it as plaintext. Use the plaintext data key to locally decrypt your data
// and then erase the key from memory. You must specify the encryption context,
// if any, that you specified when you generated the key. The encryption context
// is logged by CloudTrail, and you can use this log to help track the use of
// particular data.
func (c *KMS) GenerateDataKey(input *GenerateDataKeyInput) (*GenerateDataKeyOutput, error) {
	req, out := c.GenerateDataKeyRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"

// GenerateDataKeyWithoutPlaintextRequest generates a request for the GenerateDataKeyWithoutPlaintext operation.
func (c *KMS) GenerateDataKeyWithoutPlaintextRequest(input *GenerateDataKeyWithoutPlaintextInput) (req *request.Request, output *GenerateDataKeyWithoutPlaintextOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKeyWithoutPlaintext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyWithoutPlaintextInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateDataKeyWithoutPlaintextOutput{}
	req.Data = output
	return
}

// Returns a data key encrypted by a customer master key without the plaintext
// copy of that key. Otherwise, this API functions exactly like GenerateDataKey.
// You can use this API to, for example, satisfy an audit requirement that an
// encrypted key be made available without exposing the plaintext copy of that
// key.
func (c *KMS) GenerateDataKeyWithoutPlaintext(input *GenerateDataKeyWithoutPlaintextInput) (*GenerateDataKeyWithoutPlaintextOutput, error) {
	req, out := c.GenerateDataKeyWithoutPlaintextRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateRandom = "GenerateRandom"

// GenerateRandomRequest generates a request for the GenerateRandom operation.
func (c *KMS) GenerateRandomRequest(input *GenerateRandomInput) (req *request.Request, output *GenerateRandomOutput) {
	op := &request.Operation{
		Name:       opGenerateRandom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateRandomInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateRandomOutput{}
	req.Data = output
	return
}

// Generates an unpredictable byte string.
func (c *KMS) GenerateRandom(input *GenerateRandomInput) (*GenerateRandomOutput, error) {
	req, out := c.GenerateRandomRequest(input)
	err := req.Send()
	return out, err
}

const opGetKeyPolicy = "GetKeyPolicy"

// GetKeyPolicyRequest generates a request for the GetKeyPolicy operation.
func (c *KMS) GetKeyPolicyRequest(input *GetKeyPolicyInput) (req *request.Request, output *GetKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opGetKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetKeyPolicyOutput{}
	req.Data = output
	return
}

// Retrieves a policy attached to the specified key.
func (c *KMS) GetKeyPolicy(input *GetKeyPolicyInput) (*GetKeyPolicyOutput, error) {
	req, out := c.GetKeyPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetKeyRotationStatus = "GetKeyRotationStatus"

// GetKeyRotationStatusRequest generates a request for the GetKeyRotationStatus operation.
func (c *KMS) GetKeyRotationStatusRequest(input *GetKeyRotationStatusInput) (req *request.Request, output *GetKeyRotationStatusOutput) {
	op := &request.Operation{
		Name:       opGetKeyRotationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyRotationStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetKeyRotationStatusOutput{}
	req.Data = output
	return
}

// Retrieves a Boolean value that indicates whether key rotation is enabled
// for the specified key.
func (c *KMS) GetKeyRotationStatus(input *GetKeyRotationStatusInput) (*GetKeyRotationStatusOutput, error) {
	req, out := c.GetKeyRotationStatusRequest(input)
	err := req.Send()
	return out, err
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a request for the ListAliases operation.
func (c *KMS) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAliasesOutput{}
	req.Data = output
	return
}

// Lists all of the key aliases in the account.
func (c *KMS) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListAliasesPages(input *ListAliasesInput, fn func(p *ListAliasesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAliasesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAliasesOutput), lastPage)
	})
}

const opListGrants = "ListGrants"

// ListGrantsRequest generates a request for the ListGrants operation.
func (c *KMS) ListGrantsRequest(input *ListGrantsInput) (req *request.Request, output *ListGrantsResponse) {
	op := &request.Operation{
		Name:       opListGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListGrantsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGrantsResponse{}
	req.Data = output
	return
}

// List the grants for a specified key.
func (c *KMS) ListGrants(input *ListGrantsInput) (*ListGrantsResponse, error) {
	req, out := c.ListGrantsRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListGrantsPages(input *ListGrantsInput, fn func(p *ListGrantsResponse, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGrantsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGrantsResponse), lastPage)
	})
}

const opListKeyPolicies = "ListKeyPolicies"

// ListKeyPoliciesRequest generates a request for the ListKeyPolicies operation.
func (c *KMS) ListKeyPoliciesRequest(input *ListKeyPoliciesInput) (req *request.Request, output *ListKeyPoliciesOutput) {
	op := &request.Operation{
		Name:       opListKeyPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListKeyPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListKeyPoliciesOutput{}
	req.Data = output
	return
}

// Retrieves a list of policies attached to a key.
func (c *KMS) ListKeyPolicies(input *ListKeyPoliciesInput) (*ListKeyPoliciesOutput, error) {
	req, out := c.ListKeyPoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListKeyPoliciesPages(input *ListKeyPoliciesInput, fn func(p *ListKeyPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListKeyPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListKeyPoliciesOutput), lastPage)
	})
}

const opListKeys = "ListKeys"

// ListKeysRequest generates a request for the ListKeys operation.
func (c *KMS) ListKeysRequest(input *ListKeysInput) (req *request.Request, output *ListKeysOutput) {
	op := &request.Operation{
		Name:       opListKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListKeysOutput{}
	req.Data = output
	return
}

// Lists the customer master keys.
func (c *KMS) ListKeys(input *ListKeysInput) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListKeysPages(input *ListKeysInput, fn func(p *ListKeysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListKeysRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListKeysOutput), lastPage)
	})
}

const opListRetirableGrants = "ListRetirableGrants"

// ListRetirableGrantsRequest generates a request for the ListRetirableGrants operation.
func (c *KMS) ListRetirableGrantsRequest(input *ListRetirableGrantsInput) (req *request.Request, output *ListGrantsResponse) {
	op := &request.Operation{
		Name:       opListRetirableGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRetirableGrantsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGrantsResponse{}
	req.Data = output
	return
}

// Returns a list of all grants for which the grant's RetiringPrincipal matches
// the one specified.
//
// A typical use is to list all grants that you are able to retire. To retire
// a grant, use RetireGrant.
func (c *KMS) ListRetirableGrants(input *ListRetirableGrantsInput) (*ListGrantsResponse, error) {
	req, out := c.ListRetirableGrantsRequest(input)
	err := req.Send()
	return out, err
}

const opPutKeyPolicy = "PutKeyPolicy"

// PutKeyPolicyRequest generates a request for the PutKeyPolicy operation.
func (c *KMS) PutKeyPolicyRequest(input *PutKeyPolicyInput) (req *request.Request, output *PutKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opPutKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKeyPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutKeyPolicyOutput{}
	req.Data = output
	return
}

// Attaches a policy to the specified key.
func (c *KMS) PutKeyPolicy(input *PutKeyPolicyInput) (*PutKeyPolicyOutput, error) {
	req, out := c.PutKeyPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opReEncrypt = "ReEncrypt"

// ReEncryptRequest generates a request for the ReEncrypt operation.
func (c *KMS) ReEncryptRequest(input *ReEncryptInput) (req *request.Request, output *ReEncryptOutput) {
	op := &request.Operation{
		Name:       opReEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReEncryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReEncryptOutput{}
	req.Data = output
	return
}

// Encrypts data on the server side with a new customer master key without exposing
// the plaintext of the data on the client side. The data is first decrypted
// and then encrypted. This operation can also be used to change the encryption
// context of a ciphertext.
//
// Unlike other actions, ReEncrypt is authorized twice - once as ReEncryptFrom
// on the source key and once as ReEncryptTo on the destination key. We therefore
// recommend that you include the "action":"kms:ReEncrypt*" statement in your
// key policies to permit re-encryption from or to the key. The statement is
// included automatically when you authorize use of the key through the console
// but must be included manually when you set a policy by using the PutKeyPolicy
// function.
func (c *KMS) ReEncrypt(input *ReEncryptInput) (*ReEncryptOutput, error) {
	req, out := c.ReEncryptRequest(input)
	err := req.Send()
	return out, err
}

const opRetireGrant = "RetireGrant"

// RetireGrantRequest generates a request for the RetireGrant operation.
func (c *KMS) RetireGrantRequest(input *RetireGrantInput) (req *request.Request, output *RetireGrantOutput) {
	op := &request.Operation{
		Name:       opRetireGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetireGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetireGrantOutput{}
	req.Data = output
	return
}

// Retires a grant. You can retire a grant when you're done using it to clean
// up. You should revoke a grant when you intend to actively deny operations
// that depend on it. The following are permitted to call this API:  The account
// that created the grant The RetiringPrincipal, if present The GranteePrincipal,
// if RetireGrant is a grantee operation  The grant to retire must be identified
// by its grant token or by a combination of the key ARN and the grant ID. A
// grant token is a unique variable-length base64-encoded string. A grant ID
// is a 64 character unique identifier of a grant. Both are returned by the
// CreateGrant function.
func (c *KMS) RetireGrant(input *RetireGrantInput) (*RetireGrantOutput, error) {
	req, out := c.RetireGrantRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeGrant = "RevokeGrant"

// RevokeGrantRequest generates a request for the RevokeGrant operation.
func (c *KMS) RevokeGrantRequest(input *RevokeGrantInput) (req *request.Request, output *RevokeGrantOutput) {
	op := &request.Operation{
		Name:       opRevokeGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeGrantOutput{}
	req.Data = output
	return
}

// Revokes a grant. You can revoke a grant to actively deny operations that
// depend on it.
func (c *KMS) RevokeGrant(input *RevokeGrantInput) (*RevokeGrantOutput, error) {
	req, out := c.RevokeGrantRequest(input)
	err := req.Send()
	return out, err
}

const opScheduleKeyDeletion = "ScheduleKeyDeletion"

// ScheduleKeyDeletionRequest generates a request for the ScheduleKeyDeletion operation.
func (c *KMS) ScheduleKeyDeletionRequest(input *ScheduleKeyDeletionInput) (req *request.Request, output *ScheduleKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opScheduleKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleKeyDeletionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ScheduleKeyDeletionOutput{}
	req.Data = output
	return
}

// Schedules the deletion of a customer master key (CMK). You may provide a
// waiting period, specified in days, before deletion occurs. If you do not
// provide a waiting period, the default period of 30 days is used. When this
// operation is successful, the state of the CMK changes to PendingDeletion.
// Before the waiting period ends, you can use CancelKeyDeletion to cancel the
// deletion of the CMK. After the waiting period ends, AWS KMS deletes the CMK
// and all AWS KMS data associated with it, including all aliases that point
// to it.
//
//  Deleting a CMK is a destructive and potentially dangerous operation. When
// a CMK is deleted, all data that was encrypted under the CMK is rendered unrecoverable.
// To restrict the use of a CMK without deleting it, use DisableKey.
//
//  For more information about scheduling a CMK for deletion, go to Deleting
// Customer Master Keys (http://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
// in the AWS Key Management Service Developer Guide.
func (c *KMS) ScheduleKeyDeletion(input *ScheduleKeyDeletionInput) (*ScheduleKeyDeletionOutput, error) {
	req, out := c.ScheduleKeyDeletionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a request for the UpdateAlias operation.
func (c *KMS) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAliasOutput{}
	req.Data = output
	return
}

// Updates an alias to map it to a different key.
//
// An alias is not a property of a key. Therefore, an alias can be mapped to
// and unmapped from an existing key without changing the properties of the
// key.
//
// An alias name can contain only alphanumeric characters, forward slashes
// (/), underscores (_), and dashes (-). An alias must start with the word "alias"
// followed by a forward slash (alias/). An alias that begins with "aws" after
// the forward slash (alias/aws...) is reserved by Amazon Web Services (AWS).
//
// The alias and the key it is mapped to must be in the same AWS account and
// the same region.
func (c *KMS) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateKeyDescription = "UpdateKeyDescription"

// UpdateKeyDescriptionRequest generates a request for the UpdateKeyDescription operation.
func (c *KMS) UpdateKeyDescriptionRequest(input *UpdateKeyDescriptionInput) (req *request.Request, output *UpdateKeyDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateKeyDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateKeyDescriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateKeyDescriptionOutput{}
	req.Data = output
	return
}

// Updates the description of a key.
func (c *KMS) UpdateKeyDescription(input *UpdateKeyDescriptionInput) (*UpdateKeyDescriptionOutput, error) {
	req, out := c.UpdateKeyDescriptionRequest(input)
	err := req.Send()
	return out, err
}

// Contains information about an alias.
type AliasListEntry struct {
	_ struct{} `type:"structure"`

	// String that contains the key ARN.
	AliasArn *string `min:"20" type:"string"`

	// String that contains the alias.
	AliasName *string `min:"1" type:"string"`

	// String that contains the key identifier pointed to by the alias.
	TargetKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AliasListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasListEntry) GoString() string {
	return s.String()
}

type CancelKeyDeletionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the customer master key (CMK) for which to cancel
	// deletion.
	//
	// To specify this value, use the unique key ID or the Amazon Resource Name
	// (ARN) of the CMK. Examples:  Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	// Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//
	// To obtain the unique key ID and key ARN for a given CMK, use ListKeys or
	// DescribeKey.
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelKeyDeletionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelKeyDeletionInput) GoString() string {
	return s.String()
}

type CancelKeyDeletionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the master key for which deletion is canceled.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CancelKeyDeletionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelKeyDeletionOutput) GoString() string {
	return s.String()
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// String that contains the display name. The name must start with the word
	// "alias" followed by a forward slash (alias/). Aliases that begin with "alias/AWS"
	// are reserved.
	AliasName *string `min:"1" type:"string" required:"true"`

	// An identifier of the key for which you are creating the alias. This value
	// cannot be another alias but can be a globally unique identifier or a fully
	// specified ARN to a key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

type CreateGrantInput struct {
	_ struct{} `type:"structure"`

	// The conditions under which the operations permitted by the grant are allowed.
	//
	// You can use this value to allow the operations permitted by the grant only
	// when a specified encryption context is present. For more information, see
	// Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html)
	// in the AWS Key Management Service Developer Guide.
	Constraints *GrantConstraints `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, go to Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// The principal that is given permission to perform the operations that the
	// grant permits.
	//
	// To specify the principal, use the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an AWS principal. Valid AWS principals include AWS accounts (root), IAM
	// users, federated users, and assumed role users. For examples of the ARN syntax
	// to use for specifying a principal, see AWS Identity and Access Management
	// (IAM) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the AWS General Reference.
	GranteePrincipal *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the customer master key (CMK) that the grant applies
	// to.
	//
	// To specify this value, use the globally unique key ID or the Amazon Resource
	// Name (ARN) of the key. Examples:  Globally unique key ID: 12345678-1234-1234-1234-123456789012
	// Key ARN: arn:aws:kms:us-west-2:123456789012:key/12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// A friendly name for identifying the grant. Use this value to prevent unintended
	// creation of duplicate grants when retrying this request.
	//
	// When this value is absent, all CreateGrant requests result in a new grant
	// with a unique GrantId even if all the supplied parameters are identical.
	// This can result in unintended duplicates when you retry the CreateGrant request.
	//
	// When this value is present, you can retry a CreateGrant request with identical
	// parameters; if the grant already exists, the original GrantId is returned
	// without creating a new grant. Note that the returned grant token is unique
	// with every CreateGrant request, even when a duplicate GrantId is returned.
	// All grant tokens obtained in this way can be used interchangeably.
	Name *string `min:"1" type:"string"`

	// A list of operations that the grant permits. The list can contain any combination
	// of one or more of the following values:  Decrypt Encrypt GenerateDataKey
	// GenerateDataKeyWithoutPlaintext ReEncryptFrom ReEncryptTo CreateGrant RetireGrant
	Operations []*string `type:"list"`

	// The principal that is given permission to retire the grant by using RetireGrant
	// operation.
	//
	// To specify the principal, use the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an AWS principal. Valid AWS principals include AWS accounts (root), IAM
	// users, federated users, and assumed role users. For examples of the ARN syntax
	// to use for specifying a principal, see AWS Identity and Access Management
	// (IAM) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the AWS General Reference.
	RetiringPrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGrantInput) GoString() string {
	return s.String()
}

type CreateGrantOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the grant.
	//
	// You can use the GrantId in a subsequent RetireGrant or RevokeGrant operation.
	GrantId *string `min:"1" type:"string"`

	// The grant token.
	//
	// For more information about using grant tokens, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGrantOutput) GoString() string {
	return s.String()
}

type CreateKeyInput struct {
	_ struct{} `type:"structure"`

	// Description of the key. We recommend that you choose a description that helps
	// your customer decide whether the key is appropriate for a task.
	Description *string `type:"string"`

	// Specifies the intended use of the key. Currently this defaults to ENCRYPT/DECRYPT,
	// and only symmetric encryption and decryption are supported.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	// Policy to attach to the key. This is required and delegates back to the account.
	// The key is the root of trust. The policy size limit is 32 KiB (32768 bytes).
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyInput) GoString() string {
	return s.String()
}

type CreateKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the key.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation
func (s CreateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyOutput) GoString() string {
	return s.String()
}

type DecryptInput struct {
	_ struct{} `type:"structure"`

	// Ciphertext to be decrypted. The blob includes metadata.
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// The encryption context. If this was specified in the Encrypt function, it
	// must be specified here or the decryption operation will fail. For more information,
	// see Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html).
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, go to Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`
}

// String returns the string representation
func (s DecryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecryptInput) GoString() string {
	return s.String()
}

type DecryptOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the key used to perform the decryption. This value is returned if
	// no errors are encountered during the operation.
	KeyId *string `min:"1" type:"string"`

	// Decrypted plaintext data. This value may not be returned if the customer
	// master key is not available or if you didn't have permission to use it.
	Plaintext []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s DecryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecryptOutput) GoString() string {
	return s.String()
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias to be deleted. The name must start with the word "alias" followed
	// by a forward slash (alias/). Aliases that begin with "alias/AWS" are reserved.
	AliasName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DescribeKeyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, go to Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyInput) GoString() string {
	return s.String()
}

type DescribeKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the key.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyOutput) GoString() string {
	return s.String()
}

type DisableKeyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyInput) GoString() string {
	return s.String()
}

type DisableKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyOutput) GoString() string {
	return s.String()
}

type DisableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationInput) GoString() string {
	return s.String()
}

type DisableKeyRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationOutput) GoString() string {
	return s.String()
}

type EnableKeyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyInput) GoString() string {
	return s.String()
}

type EnableKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyOutput) GoString() string {
	return s.String()
}

type EnableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyRotationInput) GoString() string {
	return s.String()
}

type EnableKeyRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyRotationOutput) GoString() string {
	return s.String()
}

type EncryptInput struct {
	_ struct{} `type:"structure"`

	// Name/value pair that specifies the encryption context to be used for authenticated
	// encryption. If used here, the same value must be supplied to the Decrypt
	// API or decryption will fail. For more information, see Encryption Context
	// (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html).
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, go to Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// Data to be encrypted.
	Plaintext []byte `min:"1" type:"blob" required:"true"`
}

// String returns the string representation
func (s EncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptInput) GoString() string {
	return s.String()
}

type EncryptOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted plaintext. If you are using the CLI, the value is Base64 encoded.
	// Otherwise, it is not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The ID of the key used during encryption.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptOutput) GoString() string {
	return s.String()
}

type GenerateDataKeyInput struct {
	_ struct{} `type:"structure"`

	// Name/value pair that contains additional data to be authenticated during
	// the encryption and decryption processes that use the key. This value is logged
	// by AWS CloudTrail to provide context around the data encrypted by the key.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, go to Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// Value that identifies the encryption algorithm and key size to generate a
	// data key for. Currently this can be AES_128 or AES_256.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// Integer that contains the number of bytes to generate. Common values are
	// 128, 256, 512, and 1024. 1024 is the current limit. We recommend that you
	// use the KeySpec parameter instead.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GenerateDataKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyInput) GoString() string {
	return s.String()
}

type GenerateDataKeyOutput struct {
	_ struct{} `type:"structure"`

	// Ciphertext that contains the encrypted data key. You must store the blob
	// and enough information to reconstruct the encryption context so that the
	// data encrypted by using the key can later be decrypted. You must provide
	// both the ciphertext blob and the encryption context to the Decrypt API to
	// recover the plaintext data key and decrypt the object.
	//
	// If you are using the CLI, the value is Base64 encoded. Otherwise, it is
	// not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// System generated unique identifier of the key to be used to decrypt the encrypted
	// copy of the data key.
	KeyId *string `min:"1" type:"string"`

	// Plaintext that contains the data key. Use this for encryption and decryption
	// and then remove it from memory as soon as possible.
	Plaintext []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s GenerateDataKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyOutput) GoString() string {
	return s.String()
}

type GenerateDataKeyWithoutPlaintextInput struct {
	_ struct{} `type:"structure"`

	// Name:value pair that contains additional data to be authenticated during
	// the encryption and decryption processes.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, go to Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// Value that identifies the encryption algorithm and key size. Currently this
	// can be AES_128 or AES_256.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// Integer that contains the number of bytes to generate. Common values are
	// 128, 256, 512, 1024 and so on. We recommend that you use the KeySpec parameter
	// instead.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GenerateDataKeyWithoutPlaintextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyWithoutPlaintextInput) GoString() string {
	return s.String()
}

type GenerateDataKeyWithoutPlaintextOutput struct {
	_ struct{} `type:"structure"`

	// Ciphertext that contains the wrapped data key. You must store the blob and
	// encryption context so that the key can be used in a future decrypt operation.
	//
	// If you are using the CLI, the value is Base64 encoded. Otherwise, it is
	// not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// System generated unique identifier of the key to be used to decrypt the encrypted
	// copy of the data key.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GenerateDataKeyWithoutPlaintextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyWithoutPlaintextOutput) GoString() string {
	return s.String()
}

type GenerateRandomInput struct {
	_ struct{} `type:"structure"`

	// Integer that contains the number of bytes to generate. Common values are
	// 128, 256, 512, 1024 and so on. The current limit is 1024 bytes.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GenerateRandomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateRandomInput) GoString() string {
	return s.String()
}

type GenerateRandomOutput struct {
	_ struct{} `type:"structure"`

	// Plaintext that contains the unpredictable byte string.
	Plaintext []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s GenerateRandomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateRandomOutput) GoString() string {
	return s.String()
}

type GetKeyPolicyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// String that contains the name of the policy. Currently, this must be "default".
	// Policy names can be discovered by calling ListKeyPolicies.
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPolicyInput) GoString() string {
	return s.String()
}

type GetKeyPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A policy document in JSON format.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPolicyOutput) GoString() string {
	return s.String()
}

type GetKeyRotationStatusInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyRotationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyRotationStatusInput) GoString() string {
	return s.String()
}

type GetKeyRotationStatusOutput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that specifies whether key rotation is enabled.
	KeyRotationEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GetKeyRotationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyRotationStatusOutput) GoString() string {
	return s.String()
}

// A structure for specifying the conditions under which the operations permitted
// by the grant are allowed.
//
// You can use this structure to allow the operations permitted by the grant
// only when a specified encryption context is present. For more information
// about encryption context, see Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html)
// in the AWS Key Management Service Developer Guide.
type GrantConstraints struct {
	_ struct{} `type:"structure"`

	// Contains a list of key-value pairs that must be present in the encryption
	// context of a subsequent operation permitted by the grant. When a subsequent
	// operation permitted by the grant includes an encryption context that matches
	// this list, the grant allows the operation. Otherwise, the operation is not
	// allowed.
	EncryptionContextEquals map[string]*string `type:"map"`

	// Contains a list of key-value pairs, a subset of which must be present in
	// the encryption context of a subsequent operation permitted by the grant.
	// When a subsequent operation permitted by the grant includes an encryption
	// context that matches this list or is a subset of this list, the grant allows
	// the operation. Otherwise, the operation is not allowed.
	EncryptionContextSubset map[string]*string `type:"map"`
}

// String returns the string representation
func (s GrantConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantConstraints) GoString() string {
	return s.String()
}

// Contains information about an entry in a list of grants.
type GrantListEntry struct {
	_ struct{} `type:"structure"`

	// The conditions under which the grant's operations are allowed.
	Constraints *GrantConstraints `type:"structure"`

	// The date and time when the grant was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The unique identifier for the grant.
	GrantId *string `min:"1" type:"string"`

	// The principal that receives the grant's permissions.
	GranteePrincipal *string `min:"1" type:"string"`

	// The AWS account under which the grant was issued.
	IssuingAccount *string `min:"1" type:"string"`

	// The unique identifier for the customer master key (CMK) to which the grant
	// applies.
	KeyId *string `min:"1" type:"string"`

	// The friendly name that identifies the grant. If a name was provided in the
	// CreateGrant request, that name is returned. Otherwise this value is null.
	Name *string `min:"1" type:"string"`

	// The list of operations permitted by the grant.
	Operations []*string `type:"list"`

	// The principal that can retire the grant.
	RetiringPrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GrantListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantListEntry) GoString() string {
	return s.String()
}

// Contains information about each entry in the key list.
type KeyListEntry struct {
	_ struct{} `type:"structure"`

	// ARN of the key.
	KeyArn *string `min:"20" type:"string"`

	// Unique identifier of the key.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyListEntry) GoString() string {
	return s.String()
}

// Contains metadata about a customer master key (CMK).
//
// This data type is used as a response element for the CreateKey and DescribeKey
// operations.
type KeyMetadata struct {
	_ struct{} `type:"structure"`

	// The twelve-digit account ID of the AWS account that owns the key.
	AWSAccountId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the key. For examples, see AWS Key Management
	// Service (AWS KMS) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms)
	// in the Example ARNs section of the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The date and time when the key was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time after which AWS KMS deletes the customer master key (CMK).
	// This value is present only when KeyState is PendingDeletion, otherwise this
	// value is null.
	DeletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The friendly description of the key.
	Description *string `type:"string"`

	// Specifies whether the key is enabled. When KeyState is Enabled this value
	// is true, otherwise it is false.
	Enabled *bool `type:"boolean"`

	// The globally unique identifier for the key.
	KeyId *string `min:"1" type:"string" required:"true"`

	// The state of the customer master key (CMK).
	//
	// For more information about how key state affects the use of a CMK, go to
	// How Key State Affects the Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
	// in the AWS Key Management Service Developer Guide.
	KeyState *string `type:"string" enum:"KeyState"`

	// The cryptographic operations for which you can use the key. Currently the
	// only allowed value is ENCRYPT_DECRYPT, which means you can use the key for
	// the Encrypt and Decrypt operations.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`
}

// String returns the string representation
func (s KeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyMetadata) GoString() string {
	return s.String()
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you've received a response with truncated results. Set it to
	// the value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of key aliases in the user's account.
	Aliases []*AliasListEntry `type:"list"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

type ListGrantsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you've received a response with truncated results. Set it to
	// the value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGrantsInput) GoString() string {
	return s.String()
}

type ListGrantsResponse struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*GrantListEntry `type:"list"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListGrantsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGrantsResponse) GoString() string {
	return s.String()
}

type ListKeyPoliciesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 1000, inclusive. If you do not include a value, it defaults to 100.
	//
	// Currently only 1 policy can be attached to a key.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you've received a response with truncated results. Set it to
	// the value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPoliciesInput) GoString() string {
	return s.String()
}

type ListKeyPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A list of policy names. Currently, there is only one policy and it is named
	// "Default".
	PolicyNames []*string `type:"list"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListKeyPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPoliciesOutput) GoString() string {
	return s.String()
}

type ListKeysInput struct {
	_ struct{} `type:"structure"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 1000, inclusive. If you do not include a value, it defaults to 100.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you've received a response with truncated results. Set it to
	// the value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeysInput) GoString() string {
	return s.String()
}

type ListKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of keys.
	Keys []*KeyListEntry `type:"list"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeysOutput) GoString() string {
	return s.String()
}

type ListRetirableGrantsInput struct {
	_ struct{} `type:"structure"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you've received a response with truncated results. Set it to
	// the value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`

	// The retiring principal for which to list grants.
	//
	// To specify the retiring principal, use the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an AWS principal. Valid AWS principals include AWS accounts (root), IAM
	// users, federated users, and assumed role users. For examples of the ARN syntax
	// for specifying a principal, go to AWS Identity and Access Management (IAM)
	// (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the Amazon Web Services General Reference.
	RetiringPrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRetirableGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRetirableGrantsInput) GoString() string {
	return s.String()
}

type PutKeyPolicyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// The policy to attach to the key. This is required and delegates back to the
	// account. The key is the root of trust. The policy size limit is 32 KiB (32768
	// bytes).
	Policy *string `min:"1" type:"string" required:"true"`

	// Name of the policy to be attached. Currently, the only supported name is
	// "default".
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKeyPolicyInput) GoString() string {
	return s.String()
}

type PutKeyPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKeyPolicyOutput) GoString() string {
	return s.String()
}

type ReEncryptInput struct {
	_ struct{} `type:"structure"`

	// Ciphertext of the data to re-encrypt.
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// Encryption context to be used when the data is re-encrypted.
	DestinationEncryptionContext map[string]*string `type:"map"`

	// A unique identifier for the customer master key used to re-encrypt the data.
	// This value can be a globally unique identifier, a fully specified ARN to
	// either an alias or a key, or an alias name prefixed by "alias/".  Key ARN
	// Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	DestinationKeyId *string `min:"1" type:"string" required:"true"`

	// A list of grant tokens.
	//
	// For more information, go to Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Encryption context used to encrypt and decrypt the data specified in the
	// CiphertextBlob parameter.
	SourceEncryptionContext map[string]*string `type:"map"`
}

// String returns the string representation
func (s ReEncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptInput) GoString() string {
	return s.String()
}

type ReEncryptOutput struct {
	_ struct{} `type:"structure"`

	// The re-encrypted data. If you are using the CLI, the value is Base64 encoded.
	// Otherwise, it is not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// Unique identifier of the key used to re-encrypt the data.
	KeyId *string `min:"1" type:"string"`

	// Unique identifier of the key used to originally encrypt the data.
	SourceKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ReEncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptOutput) GoString() string {
	return s.String()
}

type RetireGrantInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the grant to be retired. The grant ID is returned by
	// the CreateGrant function.  Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
	GrantId *string `min:"1" type:"string"`

	// Token that identifies the grant to be retired.
	GrantToken *string `min:"1" type:"string"`

	// A unique identifier for the customer master key associated with the grant.
	// This value can be a globally unique identifier or a fully specified ARN of
	// the key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RetireGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetireGrantInput) GoString() string {
	return s.String()
}

type RetireGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RetireGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetireGrantOutput) GoString() string {
	return s.String()
}

type RevokeGrantInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the grant to be revoked.
	GrantId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the customer master key associated with the grant.
	// This value can be a globally unique identifier or the fully specified ARN
	// to a key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeGrantInput) GoString() string {
	return s.String()
}

type RevokeGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeGrantOutput) GoString() string {
	return s.String()
}

type ScheduleKeyDeletionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the customer master key (CMK) to delete.
	//
	// To specify this value, use the unique key ID or the Amazon Resource Name
	// (ARN) of the CMK. Examples:  Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	// Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//
	// To obtain the unique key ID and key ARN for a given CMK, use ListKeys or
	// DescribeKey.
	KeyId *string `min:"1" type:"string" required:"true"`

	// The waiting period, specified in number of days. After the waiting period
	// ends, AWS KMS deletes the customer master key (CMK).
	//
	// This value is optional. If you include a value, it must be between 7 and
	// 30, inclusive. If you do not include a value, it defaults to 30.
	PendingWindowInDays *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ScheduleKeyDeletionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleKeyDeletionInput) GoString() string {
	return s.String()
}

type ScheduleKeyDeletionOutput struct {
	_ struct{} `type:"structure"`

	// The date and time after which AWS KMS deletes the customer master key (CMK).
	DeletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The unique identifier of the customer master key (CMK) for which deletion
	// is scheduled.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ScheduleKeyDeletionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleKeyDeletionOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// String that contains the name of the alias to be modified. The name must
	// start with the word "alias" followed by a forward slash (alias/). Aliases
	// that begin with "alias/aws" are reserved.
	AliasName *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the customer master key to be mapped to the alias. This
	// value can be a globally unique identifier or the fully specified ARN of a
	// key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// You can call ListAliases to verify that the alias is mapped to the correct
	// TargetKeyId.
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

type UpdateKeyDescriptionInput struct {
	_ struct{} `type:"structure"`

	// New description for the key.
	Description *string `type:"string" required:"true"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateKeyDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyDescriptionInput) GoString() string {
	return s.String()
}

type UpdateKeyDescriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateKeyDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyDescriptionOutput) GoString() string {
	return s.String()
}

const (
	// @enum DataKeySpec
	DataKeySpecAes256 = "AES_256"
	// @enum DataKeySpec
	DataKeySpecAes128 = "AES_128"
)

const (
	// @enum GrantOperation
	GrantOperationDecrypt = "Decrypt"
	// @enum GrantOperation
	GrantOperationEncrypt = "Encrypt"
	// @enum GrantOperation
	GrantOperationGenerateDataKey = "GenerateDataKey"
	// @enum GrantOperation
	GrantOperationGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"
	// @enum GrantOperation
	GrantOperationReEncryptFrom = "ReEncryptFrom"
	// @enum GrantOperation
	GrantOperationReEncryptTo = "ReEncryptTo"
	// @enum GrantOperation
	GrantOperationCreateGrant = "CreateGrant"
	// @enum GrantOperation
	GrantOperationRetireGrant = "RetireGrant"
	// @enum GrantOperation
	GrantOperationDescribeKey = "DescribeKey"
)

const (
	// @enum KeyState
	KeyStateEnabled = "Enabled"
	// @enum KeyState
	KeyStateDisabled = "Disabled"
	// @enum KeyState
	KeyStatePendingDeletion = "PendingDeletion"
)

const (
	// @enum KeyUsageType
	KeyUsageTypeEncryptDecrypt = "ENCRYPT_DECRYPT"
)
