// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the active log subscriptions for the Amazon Web Services account.
func (c *Client) ListLogSubscriptions(ctx context.Context, params *ListLogSubscriptionsInput, optFns ...func(*Options)) (*ListLogSubscriptionsOutput, error) {
	if params == nil {
		params = &ListLogSubscriptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLogSubscriptions", params, optFns, c.addOperationListLogSubscriptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLogSubscriptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLogSubscriptionsInput struct {

	// If a DirectoryID is provided, lists only the log subscription associated with
	// that directory. If no DirectoryId is provided, lists all log subscriptions
	// associated with your Amazon Web Services account. If there are no log
	// subscriptions for the Amazon Web Services account or the directory, an empty
	// list will be returned.
	DirectoryId *string

	// The maximum number of items returned.
	Limit *int32

	// The token for the next set of items to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListLogSubscriptionsOutput struct {

	// A list of active LogSubscription objects for calling the Amazon Web Services account.
	LogSubscriptions []types.LogSubscription

	// The token for the next set of items to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLogSubscriptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListLogSubscriptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListLogSubscriptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLogSubscriptions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLogSubscriptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListLogSubscriptionsPaginatorOptions is the paginator options for
// ListLogSubscriptions
type ListLogSubscriptionsPaginatorOptions struct {
	// The maximum number of items returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLogSubscriptionsPaginator is a paginator for ListLogSubscriptions
type ListLogSubscriptionsPaginator struct {
	options   ListLogSubscriptionsPaginatorOptions
	client    ListLogSubscriptionsAPIClient
	params    *ListLogSubscriptionsInput
	nextToken *string
	firstPage bool
}

// NewListLogSubscriptionsPaginator returns a new ListLogSubscriptionsPaginator
func NewListLogSubscriptionsPaginator(client ListLogSubscriptionsAPIClient, params *ListLogSubscriptionsInput, optFns ...func(*ListLogSubscriptionsPaginatorOptions)) *ListLogSubscriptionsPaginator {
	if params == nil {
		params = &ListLogSubscriptionsInput{}
	}

	options := ListLogSubscriptionsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLogSubscriptionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLogSubscriptionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLogSubscriptions page.
func (p *ListLogSubscriptionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLogSubscriptionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLogSubscriptions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLogSubscriptionsAPIClient is a client that implements the
// ListLogSubscriptions operation.
type ListLogSubscriptionsAPIClient interface {
	ListLogSubscriptions(context.Context, *ListLogSubscriptionsInput, ...func(*Options)) (*ListLogSubscriptionsOutput, error)
}

var _ ListLogSubscriptionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLogSubscriptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLogSubscriptions",
	}
}
