// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains API key credential information.
type ApiKeyCredential struct {

	// An API key for an application.
	//
	// This member is required.
	ApiKey *string

	noSmithyDocumentSerde
}

// Contains information about an app authorization.
type AppAuthorization struct {

	// The name of the application.
	//
	// This member is required.
	App *string

	// The Amazon Resource Name (ARN) of the app authorization.
	//
	// This member is required.
	AppAuthorizationArn *string

	// The Amazon Resource Name (ARN) of the app bundle for the app authorization.
	//
	// This member is required.
	AppBundleArn *string

	// The authorization type.
	//
	// This member is required.
	AuthType AuthType

	// The timestamp of when the app authorization was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The state of the app authorization. The following states are possible:
	//   - PendingConnect : The initial state of the app authorization. The app
	//   authorization is created but not yet connected.
	//   - Connected : The app authorization is connected to the application, and is
	//   ready to be used.
	//   - ConnectionValidationFailed : The app authorization received a validation
	//   exception when trying to connect to the application. If the app authorization is
	//   in this state, you should verify the configured credentials and try to connect
	//   the app authorization again.
	//   - TokenAutoRotationFailed : AppFabric failed to refresh the access token. If
	//   the app authorization is in this state, you should try to reconnect the app
	//   authorization.
	//
	// This member is required.
	Status AppAuthorizationStatus

	// Contains information about an application tenant, such as the application
	// display name and identifier.
	//
	// This member is required.
	Tenant *Tenant

	// The timestamp of when the app authorization was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The application URL for the OAuth flow.
	AuthUrl *string

	// The user persona of the app authorization. This field should always be admin .
	Persona Persona

	noSmithyDocumentSerde
}

// Contains a summary of an app authorization.
type AppAuthorizationSummary struct {

	// The name of the application.
	//
	// This member is required.
	App *string

	// The Amazon Resource Name (ARN) of the app authorization.
	//
	// This member is required.
	AppAuthorizationArn *string

	// The Amazon Resource Name (ARN) of the app bundle for the app authorization.
	//
	// This member is required.
	AppBundleArn *string

	// The state of the app authorization. The following states are possible:
	//   - PendingConnect : The initial state of the app authorization. The app
	//   authorization is created but not yet connected.
	//   - Connected : The app authorization is connected to the application, and is
	//   ready to be used.
	//   - ConnectionValidationFailed : The app authorization received a validation
	//   exception when trying to connect to the application. If the app authorization is
	//   in this state, you should verify the configured credentials and try to connect
	//   the app authorization again.
	//   - TokenAutoRotationFailed : AppFabric failed to refresh the access token. If
	//   the app authorization is in this state, you should try to reconnect the app
	//   authorization.
	//
	// This member is required.
	Status AppAuthorizationStatus

	// Contains information about an application tenant, such as the application
	// display name and identifier.
	//
	// This member is required.
	Tenant *Tenant

	// Timestamp for when the app authorization was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about an app bundle.
type AppBundle struct {

	// The Amazon Resource Name (ARN) of the app bundle.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to
	// encrypt the application data.
	CustomerManagedKeyArn *string

	noSmithyDocumentSerde
}

// Contains a summary of an app bundle.
type AppBundleSummary struct {

	// The Amazon Resource Name (ARN) of the app bundle.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Contains information about an audit log destination configuration.
type AuditLogDestinationConfiguration struct {

	// Contains information about an audit log destination.
	//
	// This member is required.
	Destination Destination

	noSmithyDocumentSerde
}

// Contains information about an audit log processing configuration.
type AuditLogProcessingConfiguration struct {

	// The format in which the audit logs need to be formatted.
	//
	// This member is required.
	Format Format

	// The event schema in which the audit logs need to be formatted.
	//
	// This member is required.
	Schema Schema

	noSmithyDocumentSerde
}

// Contains authorization request information, which is required for Amazon Web
// Services AppFabric to get the OAuth2 access token for an application.
type AuthRequest struct {

	// The authorization code returned by the application after permission is granted
	// in the application OAuth page (after clicking on the AuthURL).
	//
	// This member is required.
	Code *string

	// The redirect URL that is specified in the AuthURL and the application client.
	//
	// This member is required.
	RedirectUri *string

	noSmithyDocumentSerde
}

// Contains credential information for an application.
//
// The following types satisfy this interface:
//
//	CredentialMemberApiKeyCredential
//	CredentialMemberOauth2Credential
type Credential interface {
	isCredential()
}

// Contains API key credential information.
type CredentialMemberApiKeyCredential struct {
	Value ApiKeyCredential

	noSmithyDocumentSerde
}

func (*CredentialMemberApiKeyCredential) isCredential() {}

// Contains OAuth2 client credential information.
type CredentialMemberOauth2Credential struct {
	Value Oauth2Credential

	noSmithyDocumentSerde
}

func (*CredentialMemberOauth2Credential) isCredential() {}

// Contains information about an audit log destination.
//
// The following types satisfy this interface:
//
//	DestinationMemberFirehoseStream
//	DestinationMemberS3Bucket
type Destination interface {
	isDestination()
}

// Contains information about an Amazon Kinesis Data Firehose delivery stream.
type DestinationMemberFirehoseStream struct {
	Value FirehoseStream

	noSmithyDocumentSerde
}

func (*DestinationMemberFirehoseStream) isDestination() {}

// Contains information about an Amazon S3 bucket.
type DestinationMemberS3Bucket struct {
	Value S3Bucket

	noSmithyDocumentSerde
}

func (*DestinationMemberS3Bucket) isDestination() {}

// Contains information about the destination of ingested data.
//
// The following types satisfy this interface:
//
//	DestinationConfigurationMemberAuditLog
type DestinationConfiguration interface {
	isDestinationConfiguration()
}

// Contains information about an audit log destination configuration.
type DestinationConfigurationMemberAuditLog struct {
	Value AuditLogDestinationConfiguration

	noSmithyDocumentSerde
}

func (*DestinationConfigurationMemberAuditLog) isDestinationConfiguration() {}

// Contains information about an Amazon Kinesis Data Firehose delivery stream.
type FirehoseStream struct {

	// The name of the Amazon Kinesis Data Firehose delivery stream.
	//
	// This member is required.
	StreamName *string

	noSmithyDocumentSerde
}

// Contains information about an ingestion.
type Ingestion struct {

	// The name of the application.
	//
	// This member is required.
	App *string

	// The Amazon Resource Name (ARN) of the app bundle for the ingestion.
	//
	// This member is required.
	AppBundleArn *string

	// The Amazon Resource Name (ARN) of the ingestion.
	//
	// This member is required.
	Arn *string

	// The timestamp of when the ingestion was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The type of the ingestion.
	//
	// This member is required.
	IngestionType IngestionType

	// The status of the ingestion.
	//
	// This member is required.
	State IngestionState

	// The ID of the application tenant.
	//
	// This member is required.
	TenantId *string

	// The timestamp of when the ingestion was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about an ingestion destination.
type IngestionDestination struct {

	// The Amazon Resource Name (ARN) of the ingestion destination.
	//
	// This member is required.
	Arn *string

	// Contains information about the destination of ingested data.
	//
	// This member is required.
	DestinationConfiguration DestinationConfiguration

	// The Amazon Resource Name (ARN) of the ingestion.
	//
	// This member is required.
	IngestionArn *string

	// Contains information about how ingested data is processed.
	//
	// This member is required.
	ProcessingConfiguration ProcessingConfiguration

	// The timestamp of when the ingestion destination was created.
	CreatedAt *time.Time

	// The state of the ingestion destination. The following states are possible:
	//   - Active : The ingestion destination is active and is ready to be used.
	//   - Failed : The ingestion destination has failed. If the ingestion destination
	//   is in this state, you should verify the ingestion destination configuration and
	//   try again.
	Status IngestionDestinationStatus

	// The reason for the current status of the ingestion destination. Only present
	// when the status of ingestion destination is Failed .
	StatusReason *string

	// The timestamp of when the ingestion destination was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains a summary of an ingestion destination.
type IngestionDestinationSummary struct {

	// The Amazon Resource Name (ARN) of the ingestion destination.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Contains a summary of an ingestion.
type IngestionSummary struct {

	// The name of the application.
	//
	// This member is required.
	App *string

	// The Amazon Resource Name (ARN) of the ingestion.
	//
	// This member is required.
	Arn *string

	// The status of the ingestion.
	//
	// This member is required.
	State IngestionState

	// The ID of the application tenant.
	//
	// This member is required.
	TenantId *string

	noSmithyDocumentSerde
}

// Contains OAuth2 client credential information.
type Oauth2Credential struct {

	// The client ID of the client application.
	//
	// This member is required.
	ClientId *string

	// The client secret of the client application.
	//
	// This member is required.
	ClientSecret *string

	noSmithyDocumentSerde
}

// Contains information about how ingested data is processed.
//
// The following types satisfy this interface:
//
//	ProcessingConfigurationMemberAuditLog
type ProcessingConfiguration interface {
	isProcessingConfiguration()
}

// Contains information about an audit log processing configuration.
type ProcessingConfigurationMemberAuditLog struct {
	Value AuditLogProcessingConfiguration

	noSmithyDocumentSerde
}

func (*ProcessingConfigurationMemberAuditLog) isProcessingConfiguration() {}

// Contains information about an Amazon S3 bucket.
type S3Bucket struct {

	// The name of the Amazon S3 bucket.
	//
	// This member is required.
	BucketName *string

	// The object key to use.
	Prefix *string

	noSmithyDocumentSerde
}

// The key or keys of the key-value pairs for the tag or tags assigned to a
// resource.
type Tag struct {

	// Tag key.
	//
	// This member is required.
	Key *string

	// Tag value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about an error returned from a user access task.
type TaskError struct {

	// The code of the error.
	ErrorCode *string

	// The message of the error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Contains information about an application tenant.
type Tenant struct {

	// The display name of the tenant.
	//
	// This member is required.
	TenantDisplayName *string

	// The ID of the application tenant.
	//
	// This member is required.
	TenantIdentifier *string

	noSmithyDocumentSerde
}

// Contains information about a user's access to an application.
type UserAccessResultItem struct {

	// The name of the application.
	App *string

	// The email address of the target user.
	Email *string

	// The status of the user access result item. The following states are possible:
	//   - IN_PROGRESS : The user access task is in progress.
	//   - COMPLETED : The user access task completed successfully.
	//   - FAILED : The user access task failed.
	//   - EXPIRED : The user access task expired.
	ResultStatus ResultStatus

	// Contains information about an error returned from a user access task.
	TaskError *TaskError

	// The unique ID of the task.
	TaskId *string

	// The display name of the tenant.
	TenantDisplayName *string

	// The ID of the application tenant.
	TenantId *string

	// The first name of the user.
	UserFirstName *string

	// The full name of the user.
	UserFullName *string

	// The unique ID of user.
	UserId *string

	// The last name of the user.
	UserLastName *string

	// The status of the user returned by the application.
	UserStatus *string

	noSmithyDocumentSerde
}

// Contains information about a user access task.
type UserAccessTaskItem struct {

	// The name of the application.
	//
	// This member is required.
	App *string

	// The ID of the application tenant.
	//
	// This member is required.
	TenantId *string

	// Error from the task, if any.
	Error *TaskError

	// The unique ID of the task.
	TaskId *string

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionField struct {

	// A message about the validation exception.
	//
	// This member is required.
	Message *string

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCredential()               {}
func (*UnknownUnionMember) isDestination()              {}
func (*UnknownUnionMember) isDestinationConfiguration() {}
func (*UnknownUnionMember) isProcessingConfiguration()  {}
