/*=========================================================================
 Authors: The GoFigure Dev. Team.
 at Megason Lab, Systems biology, Harvard Medical school, 2009-11

 Copyright (c) 2009-11, President and Fellows of Harvard College.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.
 Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation
 and/or other materials provided with the distribution.
 Neither the name of the  President and Fellows of Harvard College
 nor the names of its contributors may be used to endorse or promote
 products derived from this software without specific prior written
 permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "itkQuadEdgeMesh.h"
#include "itkRegularSphereMeshSource.h"
#include "itkQuadEdgeMeshTovtkPolyData.h"
#include "vtkSmartPointer.h"
#include "vtkPolyData.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkProperty.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"

int main( int, char** )
{
  typedef double CoordType;
  const unsigned int Dimension = 3;
  typedef itk::QuadEdgeMesh< CoordType, Dimension > MeshType;
  typedef itk::RegularSphereMeshSource< MeshType > SphereSourceType;

  MeshType::PointType center;
  center.Fill( 0. );

  SphereSourceType::Pointer sphere = SphereSourceType::New();
  sphere->SetCenter( center );
  sphere->SetResolution( 5 );
  sphere->Update();

  typedef itk::QuadEdgeMeshTovtkPolyData< MeshType > ConverterType;
  ConverterType::Pointer converter = ConverterType::New();
  converter->SetInput( sphere->GetOutput() );
  converter->Update();

  vtkSmartPointer< vtkPolyData > vtk_mesh = converter->GetOutput();

  vtkSmartPointer< vtkPolyDataMapper > mapper =
      vtkSmartPointer< vtkPolyDataMapper >::New();
  mapper->SetInput( vtk_mesh );

  vtkSmartPointer< vtkActor > actor =
      vtkSmartPointer< vtkActor >::New();
  actor->SetMapper( mapper );
  actor->GetProperty()->SetColor( 0.5, 0.5, 0.5 );

  vtkSmartPointer< vtkRenderer > renderer =
      vtkSmartPointer< vtkRenderer >::New();
  renderer->AddActor( actor );

  // Create a render window
  vtkSmartPointer<vtkRenderWindow> renwin =
      vtkSmartPointer<vtkRenderWindow>::New();
  renwin->AddRenderer(renderer);

  // Create an interactor
  vtkSmartPointer<vtkRenderWindowInteractor> iren =
      vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renwin);
  iren->Initialize();
  iren->Start();

  return EXIT_SUCCESS;
}
