/* Tests of euidaccess.
   Copyright (C) 2019-2024 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#include <config.h>

#include <unistd.h>

#include "signature.h"
SIGNATURE_CHECK (euidaccess, int, (const char *, int));

#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "root-uid.h"
#include "macros.h"

#define BASE "test-euidaccess.t"

#include "test-access.h"

int
main ()
{
  test_access (euidaccess);

  return test_exit_status;
}
