------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-environments.ads,v 1.10 2007/04/25 10:08:46 vagul Exp $

with
   OCI.Lib,
   OCI.Reference_Finalization;

package OCI.Environments is

   use OCI.Lib;
   package RF renames Reference_Finalization;

   subtype Memory_Byte is Ub1;

   type Thread_Environment is new RF.Controlled_Reference with record
      Handle : OCIEnv := OCIEnv (Empty_Handle);
   end record;

   function Create return Thread_Environment;

   Init_Environment : constant Thread_Environment;

   procedure Set_Create_Mode_Flag (Flag : in Ub4);
   procedure Set_Memory_Fill_Byte (Byte : in Memory_Byte);

   function Is_Objects return Boolean;

   package Counter is
      function Value return Integer;
      pragma Inline (Value);
   end Counter;

   Last_Size : Integer := 0;

private

   procedure Destroy   (Object : in out Thread_Environment);

   Init_Environment : constant Thread_Environment
     := (RF.Controlled_Reference with
         Handle => OCIEnv (Empty_Handle));

   Environment_Creation_Error : exception;

end OCI.Environments;
