/*
book.h/book.cpp - Source Code for ElephantEye, Part VI

ElephantEye - a Chinese Chess Program (UCCI Engine)
Designed by Morning Yellow, Version: 3.1, Last Modified: Nov. 2007
Copyright (C) 2004-2007 www.elephantbase.net

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "position.h"
#include "book.h"

#pragma GCC push_option
#pragma GCC optimize("00")
int GetBookMoves(const PositionStruct &pos, const char *szBookFile, MoveStruct *lpmvs) {
  BookFileStruct BookFile;
  PositionStruct posScan;
  BookStruct bk;
  int nScan, nLow, nHigh, nPtr;
  int i, j, nMoves;
  // ӿֿỵ̂¼裺

  // 1. 򿪿ֿ⣬ʧܣ򷵻ؿֵ
  if (!BookFile.Open(szBookFile)) {
    return 0;
  }

  // 2. òҷ棻
  posScan = pos;
  for (nScan = 0; nScan < 2; nScan ++) {
    nPtr = nLow = 0;
    nHigh = BookFile.nLen - 1;
    while (nLow <= nHigh) {
      nPtr = (nLow + nHigh) / 2;
      BookFile.Read(bk, nPtr);
      if (BOOK_POS_CMP(bk, posScan) < 0) {
        nLow = nPtr + 1;          
      } else if (BOOK_POS_CMP(bk, posScan) > 0) {
        nHigh = nPtr - 1;
      } else {
        break;
      }
    }
    if (nLow <= nHigh) {
      break;
    }
    // ԭ;һ
    posScan.Mirror();
  }

  // 3. 棬򷵻ؿţ
  if (nScan == 2) {
    BookFile.Close();
    return 0;
  }
  __ASSERT_BOUND(0, nPtr, BookFile.nLen - 1);

  // 4. ҵ棬ǰҵһŷ
  for (nPtr --; nPtr >= 0; nPtr --) {
    BookFile.Read(bk, nPtr);
    if (BOOK_POS_CMP(bk, posScan) < 0) {
      break;
    }
  }

  // 5. ζڸþÿŷ
  nMoves = 0;
  for (nPtr ++; nPtr < BookFile.nLen; nPtr ++) {
    BookFile.Read(bk, nPtr);
    if (BOOK_POS_CMP(bk, posScan) > 0) {
      break;
    }
    if (posScan.LegalMove(bk.wmv)) {
      // ǵڶģŷ
      lpmvs[nMoves].wmv = (nScan == 0 ? bk.wmv : MOVE_MIRROR(bk.wmv));
      lpmvs[nMoves].wvl = bk.wvl;
      nMoves ++;
      if (nMoves == MAX_GEN_MOVES) {
        break;
      }
    }
  }
  BookFile.Close();


  // 6. ŷֵ
  for (i = 0; i < nMoves - 1; i ++) {
    for (j = nMoves - 1; j > i; j --) {
      if (lpmvs[j - 1].wvl < lpmvs[j].wvl) {
        SWAP(lpmvs[j - 1], lpmvs[j]);
      }
    }
  }
  return nMoves;
}
#pragma GCC pop_option
