static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Michael Muré <batolettre@gmail.com>                        \n"
" * Copyright 2011 Robert Sasu <sasu.robert@gmail.com>                         \n"
" * Copyright 2011 Hans Lo <hansshulo@gmail.com>                               \n"
" * Copyright 1997 Brian Degenhardt <bdegenha@ucsd.edu>                        \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_enum (sampler_type, _(\"Sampler\"), GeglSamplerType, gegl_sampler_type,\n"
"                 GEGL_SAMPLER_CUBIC)                                          \n"
"   description (_(\"Sampler used internally\"))                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE ditto.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"RGBA float\"));                   \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gint x = result->x; /* initial x                   */                       \n"
"  gint y = result->y; /*           and y coordinates */                       \n"
"                                                                              \n"
"  gfloat *dst_buf = g_slice_alloc (result->width * result->height * 4 * sizeof (float));\n"
"  gfloat *out_pixel = dst_buf;                                                \n"
"                                                                              \n"
"  GeglSampler *sampler = gegl_buffer_sampler_new (input,                      \n"
"                                                  babl_format (\"RGBA float\"),\n"
"                                                  o->sampler_type);           \n"
"                                                                              \n"
"  gint n_pixels = result->width * result->height;                             \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gegl_sampler_get (sampler,                                              \n"
"                        x,                                                    \n"
"                        y,                                                    \n"
"                        NULL,                                                 \n"
"                        out_pixel,                                            \n"
"                        GEGL_ABYSS_NONE);                                     \n"
"                                                                              \n"
"      out_pixel += 4;                                                         \n"
"                                                                              \n"
"      /* update x and y coordinates */                                        \n"
"      x++;                                                                    \n"
"      if (x>=result->x + result->width)                                       \n"
"        {                                                                     \n"
"          x=result->x;                                                        \n"
"          y++;                                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, babl_format (\"RGBA float\"), dst_buf, GEGL_AUTO_ROWSTRIDE);\n"
"  g_slice_free1 (result->width * result->height * 4 * sizeof(gfloat), dst_buf);\n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"categories\"  , \"distort\",                                              \n"
"  \"name\"        , \"gegl:ditto\",                                           \n"
"  \"description\" , _(\"Test op to do a 1:1 map of input to output, while sampling\"),\n"
"  NULL);                                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
