/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.net.URL;
import java.util.Vector;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientLite;

public class AsyncBenchmark
implements Runnable {
    XmlRpcClient client = new XmlRpcClientLite(url);
    static String url;
    static int clients;
    static int loops;
    int calls = 0;
    int gCalls = 0;
    int gErrors = 0;
    long start;

    public AsyncBenchmark() throws Exception {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(123));
        this.client.execute("math.abs", vector);
        this.start = System.currentTimeMillis();
        int n = 0;
        while (n < clients) {
            new Thread(this).start();
            ++n;
        }
    }

    public void run() {
        int n = 0;
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < loops) {
            Vector<Integer> vector = new Vector<Integer>();
            Integer n3 = new Integer(Math.round((int)(Math.random() * -1000.0)));
            vector.addElement(n3);
            this.client.executeAsync("math.abs", vector, new Callback(n3));
            ++n;
            ++n2;
        }
        int n4 = (int)(System.currentTimeMillis() - l);
        System.err.println("Benchmark thread finished: " + n + " calls in " + n4 + " milliseconds.");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0 && stringArray.length < 3) {
            url = stringArray[0];
            XmlRpc.setKeepAlive(true);
            if (stringArray.length == 2) {
                XmlRpc.setDriver(stringArray[1]);
            }
            new AsyncBenchmark();
        } else {
            System.err.println("Usage: java org.apache.xmlrpc.Benchmark URL [SAXDriver]");
        }
    }

    static {
        clients = 16;
        loops = 100;
    }

    class Callback
    implements AsyncCallback {
        int n;

        public Callback(Integer n) {
            this.n = Math.abs(n);
        }

        public synchronized void handleResult(Object object, URL uRL, String string) {
            if (this.n == (Integer)object) {
                ++AsyncBenchmark.this.gCalls;
            } else {
                ++AsyncBenchmark.this.gErrors;
            }
            if (AsyncBenchmark.this.gCalls + AsyncBenchmark.this.gErrors >= clients * loops) {
                this.printStats();
            }
        }

        public synchronized void handleError(Exception exception, URL uRL, String string) {
            System.err.println(exception);
            exception.printStackTrace();
            ++AsyncBenchmark.this.gErrors;
            if (AsyncBenchmark.this.gCalls + AsyncBenchmark.this.gErrors >= clients * loops) {
                this.printStats();
            }
        }

        public void printStats() {
            System.err.println("");
            System.err.println(AsyncBenchmark.this.gCalls + " calls, " + AsyncBenchmark.this.gErrors + " errors in " + (System.currentTimeMillis() - AsyncBenchmark.this.start) + " millis");
            System.err.println((long)(1000 * (AsyncBenchmark.this.gCalls + AsyncBenchmark.this.gErrors)) / (System.currentTimeMillis() - AsyncBenchmark.this.start) + " calls per second");
        }
    }
}

