import QtQuick 2.0
import Ubuntu.Components 0.1
import Friends 0.2


Row {
    id: favorite

    height: favoriteIcon.height + units.gu(1)
    anchors {
        left: parent.left
        right: parent.right
        bottomMargin: units.gu(1)
    }
    spacing: units.dp(3)

    Image {
        id: favoriteIcon
        width: units.gu(3)
        height: units.gu(3)
        opacity: liked ? 1.0 : 0.1

        source: "images/favorite.png"
        asynchronous: true
        MouseArea {
            anchors.fill: favoriteIcon
            onClicked: {
                favoriteSpinner.visible = true;
                if (liked) {
                    friends.unlikeAsync(accountId, messageId);
                }
                else {
                    friends.likeAsync(accountId, messageId);
                }
            }
        }
        ActivityIndicator {
            id: favoriteSpinner
            anchors.centerIn: parent
            width: parent.width
            visible: false
            running: visible
        }
    }

    FriendsDispatcher {
        onLikeComplete: {
            favoriteSpinner.visible = false;
            if (success) {
                console.log ("Like succeeded");
            } else {
                console.log ("Like failed: " + errorMessage);
            }
        }
        onUnlikeComplete: {
            favoriteSpinner.visible = false;
            if (success) {
                console.log ("Like succeeded");
            } else {
                console.log ("UnLike failed: " + errorMessage);
            }
        }
    }

    Label {
        id: likesLabel
        text: (likeCount > 0) ? likeCount + " " + likesString : ""
        fontSize: "small"
        color: Theme.palette.normal.baseText
    }
}
