# -*- coding: iso-8859-1 -*-
# -----------------------------------------------------------------------
# gphoto.py - Special handling for digi cams through gphoto
# -----------------------------------------------------------------------
# $Id: gphoto.py 9561 2007-05-11 18:22:36Z duncan $
#
# Notes: you need gphoto and the python bindings to get this working
#        add plugin.activate('image.gphoto') to your local_conf.py
#
# Todo:
#
# -----------------------------------------------------------------------
# Freevo - A Home Theater PC framework
# Copyright (C) 2002 Krister Lagerstrom, et al.
# Please see the file freevo/Docs/CREDITS for a complete list of authors.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MER-
# CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# -----------------------------------------------------------------------

import os
import time
import threading

import menu
import util
import config
from item import Item
from image import ImageItem
from video import VideoItem
from directory import DirItem
from gui import ProgressBox
import pygame
import pygphoto
import image.viewer
import osd
import util.mediainfo as mediainfo
import skin
import rc

import plugin


def copycamfile(camera, path, dstfname, filetype = pygphoto.FILE_TYPE_NORMAL, progressHandler = None):
    srcfile = camera.getfile(path, filetype, progressHandler) 
    if not srcfile:
        return False
    dstfile = open(dstfname, "wb")
    dstfile.write(srcfile.read())
    srcfile.close()
    dstfile.close()
    return True


class ProgressHandler(pygphoto.Context):
	
    def __init__(self, menuw = None, maxticks = 50):
        self.id = 0
	self.target = 0
	self.curticks = 0
	self.maxticks = maxticks
	self.pop = None
	self.menuw = menuw
	self.menuwashidden = False
	
	
    def progress_start(self, target, text):
	if self.id != 0:
		return None
	self.id = 42
	self.target = target
	if self.menuw:
	    if not self.menuw.visible:
	        self.menuwashidden = True
		self.menuw.show()
	    self.pop = ProgressBox(text=text, full=self.maxticks)
            self.pop.show()
	return self.id
	
	
    def progress_update(self, id, current):
	if not self.pop:
	    return
	if self.target == 0 or id != self.id or id == 0:
	    return
	while self.curticks < current * self.maxticks / self.target:
	    self.pop.tick()
	    self.curticks += 1	
    
    
    def progress_stop(self, id):
	if id != self.id or id == 0:
	    return
	self.target = 0
	self.curticks = 0
	self.pop.destroy()
	self.pop = None
	if self.menuwashidden:
	    self.menuw.hide()
	    self.menuwashidden = False


class PluginInterface(plugin.MainMenuPlugin):
	
    def __init__(self):
        plugin.MainMenuPlugin.__init__(self)
	#keep a list of known cameras
	self.cameraList = []
        checker = threading.Thread(target=self.autocheck)
	checker.setDaemon(True)
	checker.start()



    def items(self, parent):
        items = []
        for cam in self.cameraList:
            folder = CameraFolder( parent, cam, "/", cam.name )
            folder.type = 'camera'
            folder.name = cam.name
            items.append(folder)
        return items


    def autocheck(self):
	while True:
	    time.sleep(10)
	    oldList = self.cameraList[:]
            self.cameraList = pygphoto.detect()
            change = False
	    if not len(oldList) == len(self.cameraList):
	        change = True
	    else:
	        for i in xrange(len(oldList)):
	            if not oldList[i] == self.cameraList[i]:
		        change = True
		        break
	    if change:
	        rc.post_event(plugin.event('CAMERA'))	 	
	 


class CameraFile( ImageItem ):
    def __init__(self, parent, camera, path, name, duration=0):
        ImageItem.__init__(self, 'gphoto://%s/%s' % (path,name), parent, name, duration)
        self.camera = camera
        self.path = path
        self.filename = None
        self.binsexif = {}
        # get file
	# TODO: caching 
        self.image = "/tmp/freevo/" + self.name	
	if not copycamfile( self.camera, self.path, self.image, pygphoto.FILE_TYPE_PREVIEW ):
	    self.image = None 
	

    def loadimage(self):
	progressHandler = ProgressHandler(self.menuw)
	file = self.camera.getfile(self.path, context = progressHandler)
	try:
            tmp = pygame.image.load(file)  # XXX Cannot load everything
            return tmp.convert_alpha()  # XXX Cannot load everything
        except:
	    return None
    
    
    def sort(self, mode=None):
        return self.name
	

class CameraVideo( VideoItem ):
    def __init__(self, parent, camera, path, name):
        VideoItem.__init__(self, 'gphoto://%s/%s' % (path,name), parent)
        self.camera = camera
        self.path = path
        self.filename = None
        self.binsexif = {}
	self.name = name
        self.image = "/tmp/freevo/" + self.name + ".JPG"	
	if not copycamfile( self.camera, self.path, self.image, pygphoto.FILE_TYPE_PREVIEW ):
	    self.image = None 


    def play(self, arg=None, menuw=None, alternateplayer=False):
	tmpfname = "/tmp/freevo/gphoto.avi"
	if not self.menuw:
	    self.menuw = menuw
	# enable menu for progress indicator	
	progressHandler = ProgressHandler(self.menuw)	
	if not copycamfile( self.camera, self.path, tmpfname, progressHandler = progressHandler ):
	    self.menuw.show()
	    return 
	oldUrl = self.url
	self.set_url("file:/" + tmpfname)
	VideoItem.play(self, arg, menuw, alternateplayer)
	self.set_url(oldUrl)
	
	
    def sort(self, mode=None):
        return self.name
	
	
class CameraFolder(DirItem):
    
    def __init__(self, parent, camera, path, name ):
        DirItem.__init__(self, "gphoto:/%s" % path, parent, name, display_type = 'image')
        self.camera = camera
        self.path = path
        # self.type = 'folder'  #or dir?
	self.dir = "gphoto:/%s" % path
	
  
    def build(self, arg=None, menuw=None):
        """
        build the items for the directory
        """
        self.playlist   = []
        self.play_items = []
        self.dir_items  = []
        self.pl_items   = []

        if self.media:
            self.media.mount()

        if hasattr(self, '__dirwatcher_last_time__'):
            del self.__dirwatcher_last_time__

        if arg == 'update':
            if not self.menu.choices:
                selected_pos = -1
            else:
                # store the current selected item
                selected_id  = self.menu.selected.id()
                selected_pos = self.menu.choices.index(self.menu.selected)
            if hasattr(self.menu, 'skin_default_has_description'):
                del self.menu.skin_default_has_description
            if hasattr(self.menu, 'skin_default_no_images'):
                del self.menu.skin_default_no_images
            if hasattr(self.menu, 'skin_force_text_view'):
                del self.menu.skin_force_text_view
        #elif not os.path.exists(self.dir):
        #    AlertBox(text=_('Directory does not exist')).show()
        #    return

        display_type = self.display_type

        if arg and arg.startswith('playlist:'):
            if arg.endswith(':random'):
                Playlist(playlist = [ (self.dir, 0) ], parent = self,
                         display_type=display_type, random=True).play(menuw=menuw)
            elif arg.endswith(':recursive'):
                Playlist(playlist = [ (self.dir, 1) ], parent = self,
                         display_type=display_type, random=False).play(menuw=menuw)
            elif arg.endswith(':random_recursive'):
                Playlist(playlist = [ (self.dir, 1) ], parent = self,
                         display_type=display_type, random=True).play(menuw=menuw)
            return

        pop = None
	maxticks = 50
	progressHandler = None
        if skin.active():
            pop = ProgressBox(text=_('Waiting for Camera, be patient...'),
                                      full=maxticks)
            pop.show()
	    progressHandler = ProgressHandler(self.menuw, maxticks)
        elif config.OSD_BUSYICON_TIMER:
            osd.get_singleton().busyicon.wait(config.OSD_BUSYICON_TIMER[0])
        # files       = vfs.listdir(self.dir, include_overlay=True)
        files = self.camera.listfiles(self.path, progressHandler)
        if pop:
            pop.destroy()
	
	# num_changes = mediainfo.check_cache(self.dir)
	if not files:
	    files = []
        num_changes = len(files)
 
        pop = None
        callback=None
        if skin.active():
            if num_changes:
                pop = ProgressBox(text=_('Scanning directory, be patient...'), full=num_changes)
                pop.show()
                callback=pop.tick


        elif config.OSD_BUSYICON_TIMER and len(files) > config.OSD_BUSYICON_TIMER[1]:
            # many files, just show the busy icon now
            osd.get_singleton().busyicon.wait(0)


        # if num_changes > 0:
        #    mediainfo.cache_dir(self.dir, callback=callback)


        #
        # build items
        #
        # build play_items, pl_items and dir_items
        #for p in plugin.mimetype(display_type):
        #    for i in p.get(self, files):
        #        if i.type == 'playlist':
        #            self.pl_items.append(i)
        #        elif i.type == 'dir':
        #            self.dir_items.append(i)
        #        else:
        #            self.play_items.append(i)
        for f in files:
	    path = os.path.join(self.path, f)
	    mimetype = self.camera.getmimetype(path)
            if mimetype.startswith("image/"):
	        self.play_items.append(CameraFile( self, self.camera, path, f ))
            elif mimetype.startswith("video/"):
		self.play_items.append(CameraVideo(self, self.camera, path, f ))
	    # tick progress indicator
	    callback()

        # normal DirItems
        folders = self.camera.listfolders( self.path )
	if not folders:
	    folders = []
        number = len(folders)
	for folder in folders:
    	    path = os.path.join(self.path, folder)
            subFolder = CameraFolder( self, self.camera, path, folder )
	    self.dir_items.append(subFolder)

        # remove same beginning from all play_items
	try:
	    smartnames = self.DIRECTORY_SMART_NAMES
	except AttributeError:
	    smartnames = False
        if smartnames:
            substr = ''
            if len(self.play_items) > 4 and len(self.play_items[0].name) > 5:
                substr = self.play_items[0].name[:-5].lower()
                for i in self.play_items[1:]:
                    if len(i.name) > 5:
                        substr = util.find_start_string(i.name.lower(), substr)
                        if not substr or len(substr) < 10:
                            break
                    else:
                        break
                else:
                    for i in self.play_items:
                        i.name = util.remove_start_string(i.name, substr)

        #
        # sort all items
        #

        # sort directories
        if self.DIRECTORY_SMART_SORT:
            self.dir_items.sort(lambda l, o: util.smartsort(l.dir,o.dir))
        else:
            self.dir_items.sort(lambda l, o: cmp(l.dir.upper(), o.dir.upper()))

        # sort playlist
        self.pl_items.sort(lambda l, o: cmp(l.name.upper(), o.name.upper()))

        # sort normal items
        if self.DIRECTORY_SORT_BY_DATE:
            self.play_items.sort(lambda l, o: cmp(l.sort('date').upper(),
                                                  o.sort('date').upper()))
        elif self['%s_advanced_sort' % display_type]:
            self.play_items.sort(lambda l, o: cmp(l.sort('advanced').upper(),
                                                  o.sort('advanced').upper()))
        else:
            self.play_items.sort(lambda l, o: cmp(l.sort().upper(), o.sort().upper()))

        if self['num_dir_items'] != len(self.dir_items):
            self['num_dir_items'] = len(self.dir_items)

        if self['num_%s_items' % display_type] != len(self.play_items) + len(self.pl_items):
            self['num_%s_items' % display_type] = len(self.play_items) + len(self.pl_items)

        if self.DIRECTORY_REVERSE_SORT:
            self.dir_items.reverse()
            self.play_items.reverse()
            self.pl_items.reverse()

        # delete pl_items if they should not be displayed
        if self.display_type and not self.display_type in self.DIRECTORY_ADD_PLAYLIST_FILES:
            self.pl_items = []

        # add all playable items to the playlist of the directory
        # to play one files after the other
        if not self.display_type or self.display_type in self.DIRECTORY_CREATE_PLAYLIST:
            self.playlist = self.play_items


        # build a list of all items
        items = self.dir_items + self.pl_items + self.play_items

        # random playlist (only active for audio)
        if self.display_type and self.display_type in self.DIRECTORY_ADD_RANDOM_PLAYLIST \
               and len(self.play_items) > 1:
            pl = Playlist(_('Random playlist'), self.play_items, self, random=True)
            pl.autoplay = True
            items = [ pl ] + items



        if pop:
            pop.destroy()
            # closing the poup will rebuild the menu which may umount
            # the drive
            if self.media:
                self.media.mount()

        if config.OSD_BUSYICON_TIMER:
            # stop the timer. If the icons is drawn, it will stay there
            # until the osd is redrawn, if not, we don't need it to pop
            # up the next milliseconds
            osd.get_singleton().busyicon.stop()


        #
        # action
        #

        if arg == 'update':
            # update because of dirwatcher changes
            self.menu.choices = items

            if selected_pos != -1:
                for i in items:
                    if Unicode(i.id()) == Unicode(selected_id):
                        self.menu.selected = i
                        break
                else:
                    # item is gone now, try to the selection close
                    # to the old item
                    pos = max(0, min(selected_pos-1, len(items)-1))
                    if items:
                        self.menu.selected = items[pos]
                    else:
                        self.menu.selected = None
            if self.menu.selected and selected_pos != -1:
                self.menuw.rebuild_page()
            else:
                self.menuw.init_page()
            self.menuw.refresh()


        elif len(items) == 1 and items[0].actions() and \
                 self.DIRECTORY_AUTOPLAY_SINGLE_ITEM:
            # autoplay
            items[0].actions()[0][0](menuw=menuw)

        elif arg=='play' and self.play_items:
            # called by play function
            self.playlist = self.play_items
            Playlist.play(self, menuw=menuw)

        else:
            # normal menu build
            item_menu = menu.Menu(self.name, items, reload_func=self.reload,
                                  item_types = self.skin_display_type,
                                  force_skin_layout = self.DIRECTORY_FORCE_SKIN_LAYOUT)

            if self.skin_fxd:
                item_menu.skin_settings = skin.load(self.skin_fxd)

            menuw.pushmenu(item_menu)

            # dirwatcher.cwd(menuw, self, item_menu, self.dir)
            self.menu  = item_menu
            self.menuw = menuw


    def reload(self):
        """
        called when we return to this menu
        """
        #dirwatcher.cwd(self.menuw, self, self.menu, self.dir)
        #dirwatcher.scan()

        # we changed the menu, don't build a new one
        return None
