/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#ifndef _H_DRAW_TEXT_
#define _H_DRAW_TEXT_

#include <SDL/SDL_ttf.h>
#include <SDL.h>
#include <config.h>

void draw_text( char *text, 
		SDL_Surface *surface,
		TTF_Font *font, 
		Uint32 fore_color, 
		int x, int y 
		);

void draw_text_shadow( char *text, 
		       SDL_Surface *surface,
		       TTF_Font *font, 
		       Uint32 fore_color, 
		       Uint32 shadow_color, 
		       int x, int y,
		       int sh_x, int sh_y
		       );


#endif /* _H_DRAW_TEXT_ */
